/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.ID;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class FileTypeIndex {
    @Deprecated
    public static final ID<FileType, Void> NAME = ID.create((String)"filetypes");

    @NotNull
    public static Collection<VirtualFile> getFiles(@NotNull FileType fileType, @NotNull GlobalSearchScope scope) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/search/FileTypeIndex", "getFiles"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FileTypeIndex", "getFiles"));
        }
        Collection<VirtualFile> collection = FilenameIndex.getService().getFilesWithFileType(fileType, scope);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/FileTypeIndex", "getFiles"));
        }
        return collection;
    }

    public static boolean containsFileOfType(@NotNull FileType type2, @NotNull GlobalSearchScope scope) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/search/FileTypeIndex", "containsFileOfType"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FileTypeIndex", "containsFileOfType"));
        }
        return !FilenameIndex.getService().processFilesWithFileType(type2, (Processor<VirtualFile>)((Processor)file2 -> false), scope);
    }

    public static boolean processFiles(@NotNull FileType fileType, @NotNull Processor<VirtualFile> processor2, @NotNull GlobalSearchScope scope) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/psi/search/FileTypeIndex", "processFiles"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/search/FileTypeIndex", "processFiles"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/FileTypeIndex", "processFiles"));
        }
        return FilenameIndex.getService().processFilesWithFileType(fileType, processor2, scope);
    }
}

