/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.impl.java.stubs.hierarchy.IndexTree;
import com.intellij.psi.stubsHierarchy.StubHierarchyIndexer;
import com.intellij.psi.stubsHierarchy.impl.SerializedUnit;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class StubHierarchyIndex
extends FileBasedIndexExtension<Integer, SerializedUnit>
implements PsiDependentIndex {
    private static final int KEY_COUNT = 20;
    static final int[] BINARY_KEYS = IntStream.rangeClosed(1, 20).toArray();
    static final int[] SOURCE_KEYS = IntStream.rangeClosed(-20, -1).toArray();
    static final ID<Integer, SerializedUnit> INDEX_ID = ID.create((String)"jvm.hierarchy");
    private static final StubHierarchyIndexer[] ourIndexers = (StubHierarchyIndexer[])StubHierarchyIndexer.EP_NAME.getExtensions();

    @NotNull
    public ID<Integer, SerializedUnit> getName() {
        ID<Integer, SerializedUnit> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubsHierarchy/impl/StubHierarchyIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<Integer, SerializedUnit, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            for (StubHierarchyIndexer indexer : ourIndexers) {
                IndexTree.Unit unit;
                VirtualFile file2 = inputData.getFile();
                IndexTree.Unit unit2 = unit = indexer.handlesFile(file2) ? indexer.indexFile((FileContent)inputData) : null;
                if (unit == null || unit.myDecls.length <= 0) continue;
                int[] keys = file2.getFileType().isBinary() ? BINARY_KEYS : SOURCE_KEYS;
                return Collections.singletonMap(keys[((VirtualFileWithId)file2).getId() % keys.length], new SerializedUnit(unit));
            }
            return Collections.emptyMap();
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubsHierarchy/impl/StubHierarchyIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        if (enumeratorIntegerDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubsHierarchy/impl/StubHierarchyIndex", "getKeyDescriptor"));
        }
        return enumeratorIntegerDescriptor;
    }

    @NotNull
    public DataExternalizer<SerializedUnit> getValueExternalizer() {
        DataExternalizer<SerializedUnit> dataExternalizer = new DataExternalizer<SerializedUnit>(){

            public void save(@NotNull DataOutput out, SerializedUnit value2) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/stubsHierarchy/impl/StubHierarchyIndex$1", "save"));
                }
                byte[] bytes = value2.getSerializedBytes();
                DataInputOutputUtil.writeINT((DataOutput)out, (int)bytes.length);
                out.write(bytes);
            }

            public SerializedUnit read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/psi/stubsHierarchy/impl/StubHierarchyIndex$1", "read"));
                }
                byte[] bytes = new byte[DataInputOutputUtil.readINT((DataInput)in)];
                in.readFully(bytes);
                return new SerializedUnit(bytes);
            }
        };
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubsHierarchy/impl/StubHierarchyIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    public int getVersion() {
        return IndexTree.STUB_HIERARCHY_ENABLED ? 8 + Arrays.stream(ourIndexers).mapToInt(StubHierarchyIndexer::getVersion).sum() : 0;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = file2 -> IndexTree.STUB_HIERARCHY_ENABLED && Arrays.stream(ourIndexers).anyMatch(indexer -> indexer.handlesFile(file2)) && StubHierarchyIndex.isSourceOrLibrary(file2);
        if (inputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubsHierarchy/impl/StubHierarchyIndex", "getInputFilter"));
        }
        return inputFilter;
    }

    private static boolean isSourceOrLibrary(VirtualFile file2) {
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project2);
            if (!index.isInLibraryClasses(file2) && !index.isInSourceContent(file2)) continue;
            return true;
        }
        return false;
    }

    public boolean dependsOnFileContent() {
        return true;
    }
}

