/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.proximity.ProximityWeigher;
import com.intellij.psi.util.proximity.SdkOrLibraryWeigher;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KnownElementWeigher
extends ProximityWeigher {
    private static final Set<String> POPULAR_JDK_CLASSES = ContainerUtil.newHashSet((Object[])new String[]{"java.lang.String", "java.lang.Class", System.class.getName(), "java.lang.Runnable", "java.lang.Exception", "java.lang.Throwable", "java.lang.RuntimeException", "java.util.ArrayList", "java.util.HashMap", "java.util.HashSet"});

    @Override
    public Comparable weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        PsiMethod method;
        PsiClass containingClass;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/proximity/KnownElementWeigher", "weigh"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/psi/util/proximity/KnownElementWeigher", "weigh"));
        }
        Project project2 = location.getProject();
        if (project2 == null) {
            return Integer.valueOf(0);
        }
        Integer tests = KnownElementWeigher.getTestFrameworkWeight(element, location, project2);
        if (tests != null) {
            return tests;
        }
        if (element instanceof PsiMember && JavaCompletionUtil.isInExcludedPackage((PsiMember)element, false)) {
            return Integer.valueOf(-1);
        }
        if (!SdkOrLibraryWeigher.isJdkElement(element, project2)) {
            return Integer.valueOf(0);
        }
        if (element instanceof PsiClass) {
            return KnownElementWeigher.getJdkClassProximity((PsiClass)element);
        }
        if (element instanceof PsiMethod && (containingClass = (method = (PsiMethod)element).getContainingClass()) != null) {
            String methodName = method.getName();
            if (("finalize".equals(methodName) || "registerNatives".equals(methodName) || methodName.startsWith("wait") || methodName.startsWith("notify")) && "java.lang.Object".equals(containingClass.getQualifiedName())) {
                return Integer.valueOf(-1);
            }
            if (KnownElementWeigher.isGetClass(method)) {
                return Integer.valueOf(-1);
            }
            if ("subSequence".equals(methodName) && "java.lang.String".equals(containingClass.getQualifiedName())) {
                return Integer.valueOf(-1);
            }
            if ("java.lang.Object".equals(containingClass.getQualifiedName())) {
                return Integer.valueOf(0);
            }
            return KnownElementWeigher.getJdkClassProximity(method.getContainingClass());
        }
        if (element instanceof PsiField) {
            return KnownElementWeigher.getJdkClassProximity(((PsiField)element).getContainingClass());
        }
        return Integer.valueOf(0);
    }

    @Nullable
    private static Integer getTestFrameworkWeight(@NotNull PsiElement element, @NotNull ProximityLocation location, @NotNull Project project2) {
        String qualifiedName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/proximity/KnownElementWeigher", "getTestFrameworkWeight"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/psi/util/proximity/KnownElementWeigher", "getTestFrameworkWeight"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/util/proximity/KnownElementWeigher", "getTestFrameworkWeight"));
        }
        if (element instanceof PsiClass && (qualifiedName = ((PsiClass)element).getQualifiedName()) != null) {
            if (qualifiedName.startsWith("org.testng.internal")) {
                return -1;
            }
            VirtualFile locationFile = PsiUtilCore.getVirtualFile((PsiElement)location.getPosition());
            if (locationFile != null && ProjectFileIndex.SERVICE.getInstance((Project)project2).isInTestSourceContent(locationFile) && (qualifiedName.contains("junit") || qualifiedName.contains("test"))) {
                return 1;
            }
        }
        return null;
    }

    public static boolean isGetClass(PsiMethod method) {
        return "getClass".equals(method.getName()) && method.getParameterList().getParametersCount() <= 0;
    }

    private static Comparable getJdkClassProximity(@Nullable PsiClass element) {
        if (element == null || element.getContainingClass() != null) {
            return Integer.valueOf(0);
        }
        String qname = element.getQualifiedName();
        if (qname != null) {
            String pkg = StringUtil.getPackageName((String)qname);
            if (qname.equals("java.lang.Object")) {
                return Integer.valueOf(5);
            }
            if (POPULAR_JDK_CLASSES.contains(qname)) {
                return Integer.valueOf(8);
            }
            if (pkg.equals("java.lang")) {
                return Integer.valueOf(6);
            }
            if (pkg.equals("java.util")) {
                return Integer.valueOf(7);
            }
            if (qname.startsWith("java.lang")) {
                return Integer.valueOf(5);
            }
            if (qname.startsWith("java.util")) {
                return Integer.valueOf(4);
            }
            if (pkg.equals("javax.swing")) {
                return Integer.valueOf(3);
            }
            if (qname.startsWith("java.")) {
                return Integer.valueOf(2);
            }
            if (qname.startsWith("javax.")) {
                return Integer.valueOf(1);
            }
            if (qname.startsWith("com.")) {
                return Integer.valueOf(-1);
            }
            if (qname.startsWith("net.")) {
                return Integer.valueOf(-1);
            }
        }
        return Integer.valueOf(0);
    }
}

