/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.proximity.ProximityWeigher;
import org.jetbrains.annotations.NotNull;

public class SamePsiMemberWeigher
extends ProximityWeigher {
    private static final NotNullLazyKey<Boolean, ProximityLocation> INSIDE_PSI_MEMBER = NotNullLazyKey.create((String)"insidePsiMember", proximityLocation -> PsiTreeUtil.getContextOfType((PsiElement)proximityLocation.getPosition(), PsiMember.class, (boolean)false) != null);
    private static final NotNullLazyKey<PsiElement, ProximityLocation> PHYSICAL_POSITION = NotNullLazyKey.create((String)"physicalPosition", location -> {
        PsiFile file2;
        PsiElement position = location.getPosition();
        assert (position != null);
        if (!position.isPhysical() && (file2 = position.getContainingFile()) != null) {
            int offset;
            PsiFile originalFile = file2.getOriginalFile();
            PsiElement candidate = originalFile.findElementAt(offset = position.getTextRange().getStartOffset());
            if (candidate == null) {
                candidate = originalFile.findElementAt(offset - 1);
            }
            if (candidate != null) {
                return candidate;
            }
        }
        return position;
    });

    @Override
    public Comparable weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        PsiMember member;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/proximity/SamePsiMemberWeigher", "weigh"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/psi/util/proximity/SamePsiMemberWeigher", "weigh"));
        }
        PsiElement position = location.getPosition();
        if (position == null) {
            return null;
        }
        if (!((Boolean)INSIDE_PSI_MEMBER.getValue((UserDataHolder)location)).booleanValue()) {
            return Integer.valueOf(0);
        }
        if (element.isPhysical()) {
            position = (PsiElement)PHYSICAL_POSITION.getValue((UserDataHolder)location);
        }
        if ((member = (PsiMember)PsiTreeUtil.getContextOfType((PsiElement)PsiTreeUtil.findCommonContext((PsiElement)position, (PsiElement)element), PsiMember.class, (boolean)false)) instanceof PsiClass) {
            return Integer.valueOf(1);
        }
        if (member != null) {
            return Integer.valueOf(2);
        }
        return Integer.valueOf(0);
    }
}

