/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.anonymousToInner;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.anonymousToInner.AnonymousToInnerHandler;
import com.intellij.refactoring.anonymousToInner.VariableInfo;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ParameterTablePanel;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class AnonymousToInnerDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.anonymousToInner.AnonymousToInnerDialog");
    private final Project myProject;
    private final PsiAnonymousClass myAnonClass;
    private final boolean myShowCanBeStatic;
    private NameSuggestionsField myNameField;
    private final VariableData[] myVariableData;
    private final Map<PsiVariable, VariableInfo> myVariableToInfoMap = new HashMap();
    private JCheckBox myCbMakeStatic;

    public AnonymousToInnerDialog(Project project2, PsiAnonymousClass anonClass, VariableInfo[] variableInfos, boolean showCanBeStatic) {
        super(project2, true);
        this.myProject = project2;
        this.myAnonClass = anonClass;
        this.myShowCanBeStatic = showCanBeStatic;
        this.setTitle(AnonymousToInnerHandler.REFACTORING_NAME);
        for (VariableInfo info : variableInfos) {
            this.myVariableToInfoMap.put(info.variable, info);
        }
        this.myVariableData = new VariableData[variableInfos.length];
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        for (int idx = 0; idx < variableInfos.length; ++idx) {
            VariableInfo info = variableInfos[idx];
            String name2 = info.variable.getName();
            VariableKind kind2 = codeStyleManager.getVariableKind(info.variable);
            name2 = codeStyleManager.variableNameToPropertyName(name2, kind2);
            name2 = codeStyleManager.propertyNameToVariableName(name2, VariableKind.PARAMETER);
            VariableData data = new VariableData(info.variable);
            data.name = name2;
            data.passAsParameter = true;
            this.myVariableData[idx] = data;
        }
        this.init();
        String name3 = this.myAnonClass.getBaseClassReference().getReferenceName();
        Object[] typeParameters = this.myAnonClass.getBaseClassReference().getTypeParameters();
        String typeParamsList = StringUtil.join((Object[])typeParameters, psiType -> {
            PsiType type2 = psiType;
            if (psiType instanceof PsiClassType) {
                type2 = TypeConversionUtil.erasure((PsiType)psiType);
            }
            if (type2 == null || type2.equalsToText("java.lang.Object")) {
                return "";
            }
            if (type2 instanceof PsiArrayType) {
                type2 = type2.getDeepComponentType();
            }
            return StringUtil.getShortName((String)type2.getPresentableText());
        }, (String)"") + name3;
        String[] names = !typeParamsList.equals(name3) ? new String[]{typeParamsList, "My" + name3} : new String[]{"My" + name3};
        this.myNameField.setSuggestions(names);
        this.myNameField.selectNameWithoutExtension();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/anonymousToInner/AnonymousToInnerDialog", "createActions"));
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField.getFocusableComponent();
    }

    public boolean isMakeStatic() {
        return this.myCbMakeStatic.isSelected();
    }

    public String getClassName() {
        return this.myNameField.getEnteredName();
    }

    public VariableInfo[] getVariableInfos() {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        VariableInfo[] infos = new VariableInfo[this.myVariableData.length];
        for (int idx = 0; idx < this.myVariableData.length; ++idx) {
            VariableData data = this.myVariableData[idx];
            VariableInfo info = this.myVariableToInfoMap.get(data.variable);
            info.passAsParameter = data.passAsParameter;
            info.parameterName = data.name;
            info.parameterName = data.name;
            String propertyName = codeStyleManager.variableNameToPropertyName(data.name, VariableKind.PARAMETER);
            info.fieldName = codeStyleManager.propertyNameToVariableName(propertyName, VariableKind.FIELD);
            infos[idx] = info;
        }
        return infos;
    }

    protected void doOKAction() {
        String errorString = null;
        String innerClassName = this.getClassName();
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        if ("".equals(innerClassName)) {
            errorString = RefactoringBundle.message((String)"anonymousToInner.no.inner.class.name");
        } else if (!PsiNameHelper.getInstance((Project)manager.getProject()).isIdentifier(innerClassName)) {
            errorString = RefactoringMessageUtil.getIncorrectIdentifierMessage(innerClassName);
        } else {
            PsiElement targetContainer = AnonymousToInnerHandler.findTargetContainer(this.myAnonClass);
            if (targetContainer instanceof PsiClass) {
                PsiClass[] innerClasses;
                PsiClass targetClass = (PsiClass)targetContainer;
                for (PsiClass innerClass : innerClasses = targetClass.getInnerClasses()) {
                    if (!innerClassName.equals(innerClass.getName())) continue;
                    errorString = RefactoringBundle.message((String)"inner.class.exists", (Object[])new Object[]{innerClassName, targetClass.getName()});
                    break;
                }
            } else {
                LOG.assertTrue(false);
            }
        }
        if (errorString != null) {
            CommonRefactoringUtil.showErrorMessage((String)AnonymousToInnerHandler.REFACTORING_NAME, (String)errorString, (String)"refactoring.convertAnonymous", (Project)this.myProject);
            this.myNameField.requestFocusInWindow();
            return;
        }
        super.doOKAction();
        this.myNameField.requestFocusInWindow();
    }

    protected JComponent createNorthPanel() {
        this.myNameField = new NameSuggestionsField(this.myProject);
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addLabeledComponent(RefactoringBundle.message((String)"anonymousToInner.class.name.label.text"), (JComponent)this.myNameField);
        if (!this.myShowCanBeStatic) {
            this.myCbMakeStatic = new NonFocusableCheckBox(RefactoringBundle.message((String)"anonymousToInner.make.class.static.checkbox.text"));
            this.myCbMakeStatic.setSelected(true);
            formBuilder.addComponent((JComponent)this.myCbMakeStatic);
        }
        return formBuilder.getPanel();
    }

    private JComponent createParametersPanel() {
        ParameterTablePanel panel2 = new ParameterTablePanel(this.myProject, this.myVariableData, new PsiElement[]{this.myAnonClass}){

            @Override
            protected void updateSignature() {
            }

            @Override
            protected void doEnterAction() {
                AnonymousToInnerDialog.this.clickDefaultButton();
            }

            @Override
            protected void doCancelAction() {
                AnonymousToInnerDialog.this.doCancelAction();
            }
        };
        panel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"anonymousToInner.parameters.panel.border.title"), (boolean)false));
        return panel2;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.createParametersPanel(), "Center");
        return panel2;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.convertAnonymous");
    }
}

