/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inplace;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LanguageChangeSignatureDetector<C extends ChangeInfo> {
    @NotNull
    public C createInitialChangeInfo(@NotNull PsiElement var1);

    public boolean ignoreChanges(PsiElement var1);

    @Nullable
    public C createNextChangeInfo(String var1, @NotNull C var2, boolean var3);

    public void performChange(C var1, Editor var2, @NotNull String var3);

    public boolean isChangeSignatureAvailableOnElement(@NotNull PsiElement var1, C var2);

    public TextRange getHighlightingRange(@NotNull C var1);

    @NotNull
    default public String extractSignature(@NotNull C initialChangeInfo) {
        if (initialChangeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialChangeInfo", "com/intellij/refactoring/changeSignature/inplace/LanguageChangeSignatureDetector", "extractSignature"));
        }
        TextRange signatureRange = this.getHighlightingRange(initialChangeInfo);
        String string = signatureRange.shiftRight(-signatureRange.getStartOffset()).substring(initialChangeInfo.getMethod().getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/inplace/LanguageChangeSignatureDetector", "extractSignature"));
        }
        return string;
    }

    default public String getMethodSignaturePreview(C info, List<TextRange> deleteRanges, List<TextRange> newRanges) {
        return this.extractSignature(info);
    }

    public FileType getFileType();
}

