/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.encapsulateFields;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldHelper;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldUsageInfo;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsDescriptor;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsProcessor;
import com.intellij.refactoring.encapsulateFields.FieldDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaEncapsulateFieldHelper
extends EncapsulateFieldHelper {
    private static final Logger LOG = Logger.getInstance(JavaEncapsulateFieldHelper.class);

    @Nullable
    public EncapsulateFieldUsageInfo createUsage(@NotNull EncapsulateFieldsDescriptor descriptor, @NotNull FieldDescriptor fieldDescriptor, @NotNull PsiReference reference) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/refactoring/encapsulateFields/JavaEncapsulateFieldHelper", "createUsage"));
        }
        if (fieldDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldDescriptor", "com/intellij/refactoring/encapsulateFields/JavaEncapsulateFieldHelper", "createUsage"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/refactoring/encapsulateFields/JavaEncapsulateFieldHelper", "createUsage"));
        }
        if (!(reference instanceof PsiReferenceExpression)) {
            return null;
        }
        boolean findSet = descriptor.isToEncapsulateSet();
        boolean findGet = descriptor.isToEncapsulateGet();
        PsiReferenceExpression ref = (PsiReferenceExpression)reference;
        if (findGet && JavaEncapsulateFieldHelper.isUsedInExistingAccessor(descriptor.getTargetClass(), fieldDescriptor.getGetterPrototype(), (PsiElement)ref)) {
            return null;
        }
        if (findSet && JavaEncapsulateFieldHelper.isUsedInExistingAccessor(descriptor.getTargetClass(), fieldDescriptor.getSetterPrototype(), (PsiElement)ref)) {
            return null;
        }
        if (!findGet && !PsiUtil.isAccessedForWriting((PsiExpression)ref)) {
            return null;
        }
        if (!(findSet && !fieldDescriptor.getField().hasModifierProperty("final") || PsiUtil.isAccessedForReading((PsiExpression)ref))) {
            return null;
        }
        if (!descriptor.isToUseAccessorsWhenAccessible()) {
            PsiResolveHelper helper;
            PsiModifierList newModifierList = JavaEncapsulateFieldHelper.createNewModifierList(descriptor);
            PsiClass accessObjectClass = null;
            PsiExpression qualifier = ref.getQualifierExpression();
            if (qualifier != null) {
                accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement();
            }
            if ((helper = JavaPsiFacade.getInstance((Project)((PsiReferenceExpression)reference).getProject()).getResolveHelper()).isAccessible((PsiMember)fieldDescriptor.getField(), newModifierList, (PsiElement)ref, accessObjectClass, null)) {
                return null;
            }
        }
        return new EncapsulateFieldUsageInfo((PsiReference)ref, fieldDescriptor);
    }

    public static PsiModifierList createNewModifierList(EncapsulateFieldsDescriptor descriptor) {
        PsiModifierList newModifierList = null;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)descriptor.getTargetClass().getProject()).getElementFactory();
        try {
            PsiField field = factory.createField("a", (PsiType)PsiType.INT);
            EncapsulateFieldsProcessor.setNewFieldVisibility(field, descriptor);
            newModifierList = field.getModifierList();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return newModifierList;
    }

    public static boolean isUsedInExistingAccessor(PsiClass aClass, PsiMethod prototype, PsiElement element) {
        PsiMethod existingAccessor = aClass.findMethodBySignature(prototype, false);
        if (existingAccessor != null) {
            for (PsiElement parent = element; parent != null; parent = parent.getParent()) {
                if (!existingAccessor.equals(parent)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean processUsage(@NotNull EncapsulateFieldUsageInfo usage, @NotNull EncapsulateFieldsDescriptor descriptor, PsiMethod setter, PsiMethod getter) {
        boolean processSet;
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/refactoring/encapsulateFields/JavaEncapsulateFieldHelper", "processUsage"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/refactoring/encapsulateFields/JavaEncapsulateFieldHelper", "processUsage"));
        }
        PsiElement element = usage.getElement();
        if (!(element instanceof PsiReferenceExpression)) {
            return false;
        }
        FieldDescriptor fieldDescriptor = usage.getFieldDescriptor();
        PsiField field = fieldDescriptor.getField();
        boolean processGet = descriptor.isToEncapsulateGet();
        boolean bl = processSet = descriptor.isToEncapsulateSet() && !field.hasModifierProperty("final");
        if (!processGet && !processSet) {
            return true;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)descriptor.getTargetClass().getProject()).getElementFactory();
        try {
            PsiReferenceExpression expr = (PsiReferenceExpression)element;
            PsiElement parent = expr.getParent();
            if (parent instanceof PsiAssignmentExpression && expr.equals(((PsiAssignmentExpression)parent).getLExpression())) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                if (assignment.getRExpression() == null) {
                    return true;
                }
                PsiJavaToken opSign = assignment.getOperationSign();
                IElementType opType = opSign.getTokenType();
                if (opType == JavaTokenType.EQ) {
                    if (!processSet) {
                        return true;
                    }
                    PsiExpression setterArgument = assignment.getRExpression();
                    PsiMethodCallExpression methodCall = JavaEncapsulateFieldHelper.createSetterCall(fieldDescriptor, setterArgument, expr, descriptor.getTargetClass(), setter);
                    if (methodCall != null) {
                        assignment.replace((PsiElement)methodCall);
                    }
                } else if (opType == JavaTokenType.ASTERISKEQ || opType == JavaTokenType.DIVEQ || opType == JavaTokenType.PERCEQ || opType == JavaTokenType.PLUSEQ || opType == JavaTokenType.MINUSEQ || opType == JavaTokenType.LTLTEQ || opType == JavaTokenType.GTGTEQ || opType == JavaTokenType.GTGTGTEQ || opType == JavaTokenType.ANDEQ || opType == JavaTokenType.OREQ || opType == JavaTokenType.XOREQ) {
                    PsiMethodCallExpression setExpr;
                    PsiMethodCallExpression getterCall;
                    String opName = opSign.getText();
                    LOG.assertTrue(StringUtil.endsWithChar((CharSequence)opName, (char)'='));
                    opName = opName.substring(0, opName.length() - 1);
                    PsiReferenceExpression getExpr = expr;
                    if (processGet && (getterCall = JavaEncapsulateFieldHelper.createGetterCall(fieldDescriptor, expr, descriptor.getTargetClass(), getter)) != null) {
                        getExpr = getterCall;
                    }
                    String text2 = "a" + opName + "b";
                    PsiBinaryExpression binExpr = (PsiBinaryExpression)factory.createExpressionFromText(text2, (PsiElement)expr);
                    binExpr.getLOperand().replace((PsiElement)getExpr);
                    binExpr.getROperand().replace((PsiElement)assignment.getRExpression());
                    if (processSet) {
                        setExpr = JavaEncapsulateFieldHelper.createSetterCall(fieldDescriptor, (PsiExpression)binExpr, expr, descriptor.getTargetClass(), setter);
                    } else {
                        text2 = "a = b";
                        PsiAssignmentExpression assignment1 = (PsiAssignmentExpression)factory.createExpressionFromText(text2, null);
                        assignment1.getLExpression().replace((PsiElement)expr);
                        assignment1.getRExpression().replace((PsiElement)binExpr);
                        setExpr = assignment1;
                    }
                    assignment.replace((PsiElement)setExpr);
                }
            } else if (PsiUtil.isIncrementDecrementOperation((PsiElement)parent)) {
                PsiMethodCallExpression setExpr;
                PsiMethodCallExpression getterCall;
                IElementType sign = parent instanceof PsiPrefixExpression ? ((PsiPrefixExpression)parent).getOperationTokenType() : ((PsiPostfixExpression)parent).getOperationTokenType();
                PsiReferenceExpression getExpr = expr;
                if (processGet && (getterCall = JavaEncapsulateFieldHelper.createGetterCall(fieldDescriptor, expr, descriptor.getTargetClass(), getter)) != null) {
                    getExpr = getterCall;
                }
                String text3 = sign == JavaTokenType.PLUSPLUS ? "a+1" : "a-1";
                PsiBinaryExpression binExpr = (PsiBinaryExpression)factory.createExpressionFromText(text3, null);
                binExpr.getLOperand().replace((PsiElement)getExpr);
                if (processSet) {
                    setExpr = JavaEncapsulateFieldHelper.createSetterCall(fieldDescriptor, (PsiExpression)binExpr, expr, descriptor.getTargetClass(), setter);
                } else {
                    text3 = "a = b";
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)factory.createExpressionFromText(text3, null);
                    assignment.getLExpression().replace((PsiElement)expr);
                    assignment.getRExpression().replace((PsiElement)binExpr);
                    setExpr = assignment;
                }
                parent.replace((PsiElement)setExpr);
            } else {
                if (!processGet) {
                    return true;
                }
                PsiMethodCallExpression methodCall = JavaEncapsulateFieldHelper.createGetterCall(fieldDescriptor, expr, descriptor.getTargetClass(), getter);
                if (methodCall != null) {
                    expr.replace((PsiElement)methodCall);
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    private static PsiMethodCallExpression createSetterCall(FieldDescriptor fieldDescriptor, PsiExpression setterArgument, PsiReferenceExpression expr, PsiClass aClass, PsiMethod setter) throws IncorrectOperationException {
        String setterName = fieldDescriptor.getSetterName();
        String text2 = setterName + "(a)";
        PsiMethodCallExpression methodCall = JavaEncapsulateFieldHelper.prepareMethodCall(expr, text2);
        methodCall.getArgumentList().getExpressions()[0].replace((PsiElement)setterArgument);
        methodCall = JavaEncapsulateFieldHelper.checkMethodResolvable(methodCall, setter, expr, aClass);
        if (methodCall == null) {
            VisibilityUtil.escalateVisibility((PsiMember)fieldDescriptor.getField(), (PsiElement)expr);
        }
        return methodCall;
    }

    @Nullable
    private static PsiMethodCallExpression createGetterCall(FieldDescriptor fieldDescriptor, PsiReferenceExpression expr, PsiClass aClass, PsiMethod getter) throws IncorrectOperationException {
        String getterName = fieldDescriptor.getGetterName();
        String text2 = getterName + "()";
        PsiMethodCallExpression methodCall = JavaEncapsulateFieldHelper.prepareMethodCall(expr, text2);
        if ((methodCall = JavaEncapsulateFieldHelper.checkMethodResolvable(methodCall, getter, expr, aClass)) == null) {
            VisibilityUtil.escalateVisibility((PsiMember)fieldDescriptor.getField(), (PsiElement)expr);
        }
        return methodCall;
    }

    private static PsiMethodCallExpression prepareMethodCall(PsiReferenceExpression expr, String text2) {
        PsiElement referenceNameElement;
        PsiExpression qualifier = expr.getQualifierExpression();
        if (qualifier != null && (referenceNameElement = expr.getReferenceNameElement()) != null) {
            text2 = expr.getText().substring(0, referenceNameElement.getStartOffsetInParent()) + text2;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory();
        return (PsiMethodCallExpression)factory.createExpressionFromText(text2, (PsiElement)expr);
    }

    @Nullable
    private static PsiMethodCallExpression checkMethodResolvable(PsiMethodCallExpression methodCall, PsiMethod targetMethod, PsiReferenceExpression context, PsiClass aClass) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)targetMethod.getProject()).getElementFactory();
        PsiElement resolved = methodCall.getMethodExpression().resolve();
        if (resolved != targetMethod) {
            PsiClass containingClass;
            if (resolved instanceof PsiMethod) {
                containingClass = ((PsiMethod)resolved).getContainingClass();
            } else if (resolved instanceof PsiClass) {
                containingClass = (PsiClass)resolved;
            } else {
                return null;
            }
            if (containingClass != null && containingClass.isInheritor(aClass, false)) {
                PsiExpression newMethodExpression = factory.createExpressionFromText("super." + targetMethod.getName(), (PsiElement)context);
                methodCall.getMethodExpression().replace((PsiElement)newMethodExpression);
            } else {
                methodCall = null;
            }
        }
        return methodCall;
    }

    @NotNull
    public PsiField[] getApplicableFields(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/refactoring/encapsulateFields/JavaEncapsulateFieldHelper", "getApplicableFields"));
        }
        List fields = ContainerUtil.filter((Object[])aClass.getFields(), field -> !(field instanceof PsiEnumConstant));
        PsiField[] psiFieldArray = fields.toArray(new PsiField[fields.size()]);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/encapsulateFields/JavaEncapsulateFieldHelper", "getApplicableFields"));
        }
        return psiFieldArray;
    }

    @NotNull
    public String suggestSetterName(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/refactoring/encapsulateFields/JavaEncapsulateFieldHelper", "suggestSetterName"));
        }
        String string = GenerateMembersUtil.suggestSetterName(field);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/encapsulateFields/JavaEncapsulateFieldHelper", "suggestSetterName"));
        }
        return string;
    }

    @NotNull
    public String suggestGetterName(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/refactoring/encapsulateFields/JavaEncapsulateFieldHelper", "suggestGetterName"));
        }
        String string = GenerateMembersUtil.suggestGetterName(field);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/encapsulateFields/JavaEncapsulateFieldHelper", "suggestGetterName"));
        }
        return string;
    }

    @Nullable
    public PsiMethod generateMethodPrototype(@NotNull PsiField field, @NotNull String methodName, boolean isGetter) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/refactoring/encapsulateFields/JavaEncapsulateFieldHelper", "generateMethodPrototype"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/refactoring/encapsulateFields/JavaEncapsulateFieldHelper", "generateMethodPrototype"));
        }
        PsiMethod prototype = isGetter ? GenerateMembersUtil.generateGetterPrototype(field) : GenerateMembersUtil.generateSetterPrototype(field);
        try {
            prototype.setName(methodName);
            return prototype;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }
}

