/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inheritanceToDelegation;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.inheritanceToDelegation.InheritanceToDelegationDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.MemberInfoStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class InheritanceToDelegationHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.inheritanceToDelegation.InheritanceToDelegationHandler");
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"replace.inheritance.with.delegation.title");
    private static final MemberInfoBase.Filter<PsiMember> MEMBER_INFO_FILTER = new MemberInfoBase.Filter<PsiMember>(){

        public boolean includeMember(PsiMember element) {
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                return !method.hasModifierProperty("static") && !method.hasModifierProperty("private");
            }
            return element instanceof PsiClass && ((PsiClass)element).isInterface();
        }
    };

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationHandler", "isAvailableForQuickList"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationHandler", "isAvailableForQuickList"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationHandler", "isAvailableForQuickList"));
        }
        return !PsiUtil.isModuleFile((PsiFile)file2);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationHandler", "invoke"));
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.class"));
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.replaceInheritWithDelegat");
                return;
            }
            if (element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) {
                this.invoke(project2, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationHandler", "invoke"));
        }
        if (elements.length != 1) {
            return;
        }
        PsiClass aClass = (PsiClass)elements[0];
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (aClass.isInterface()) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"class.is.interface", (Object[])new Object[]{aClass.getQualifiedName()}));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.replaceInheritWithDelegat");
            return;
        }
        if (aClass instanceof JspClass) {
            RefactoringMessageUtil.showNotSupportedForJspClassesError(project2, editor, REFACTORING_NAME, "refactoring.replaceInheritWithDelegat");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)aClass)) {
            return;
        }
        PsiClass[] bases = aClass.getSupers();
        String javaLangObject = "java.lang.Object";
        if (bases.length == 0 || bases.length == 1 && "java.lang.Object".equals(bases[0].getQualifiedName())) {
            String message3 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"class.does.not.have.base.classes.or.interfaces", (Object[])new Object[]{aClass.getQualifiedName()}));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message3, (String)REFACTORING_NAME, (String)"refactoring.replaceInheritWithDelegat");
            return;
        }
        LinkedHashMap<PsiClass, Collection<MemberInfo>> basesToMemberInfos = new LinkedHashMap<PsiClass, Collection<MemberInfo>>();
        for (PsiClass base : bases) {
            if ("java.lang.Object".equals(base.getQualifiedName())) continue;
            basesToMemberInfos.put(base, InheritanceToDelegationHandler.createBaseClassMemberInfos(base));
        }
        Set baseClasses = ((HashMap)basesToMemberInfos).keySet();
        new InheritanceToDelegationDialog(project2, aClass, baseClasses.toArray(new PsiClass[baseClasses.size()]), basesToMemberInfos).show();
    }

    private static List<MemberInfo> createBaseClassMemberInfos(PsiClass baseClass) {
        PsiClass deepestBase = RefactoringHierarchyUtil.getDeepestNonObjectBase(baseClass);
        LOG.assertTrue(deepestBase != null);
        MemberInfoStorage memberInfoStorage = new MemberInfoStorage(baseClass, MEMBER_INFO_FILTER);
        ArrayList<MemberInfo> memberInfoList = new ArrayList<MemberInfo>();
        memberInfoList.addAll(memberInfoStorage.getClassMemberInfos(deepestBase));
        memberInfoList.addAll(memberInfoStorage.getIntermediateMemberInfosList(deepestBase));
        return memberInfoList;
    }
}

