/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineMethodHandler;
import com.intellij.refactoring.inline.InlineToAnonymousClassDialog;
import com.intellij.refactoring.inline.InlineToAnonymousClassProcessor;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineToAnonymousClassHandler
extends JavaInlineActionHandler {
    static final ElementPattern ourCatchClausePattern = PlatformPatterns.psiElement(PsiTypeElement.class).withParent((ElementPattern)PlatformPatterns.psiElement(PsiParameter.class).withParent((ElementPattern)PlatformPatterns.psiElement(PsiCatchSection.class)));
    static final ElementPattern ourThrowsClausePattern = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceList.class).withFirstChild((ElementPattern)PlatformPatterns.psiElement().withText("throws")));

    public boolean isEnabledOnElement(PsiElement element) {
        return element instanceof PsiMethod || element instanceof PsiClass;
    }

    public boolean canInlineElement(PsiElement element) {
        PsiMethod method;
        if (element.getLanguage() != StdLanguages.JAVA) {
            return false;
        }
        if (element instanceof PsiMethod && (method = (PsiMethod)element).isConstructor() && !InlineMethodHandler.isChainingConstructor(method)) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            return InlineToAnonymousClassHandler.findClassInheritors(containingClass);
        }
        if (!(element instanceof PsiClass)) {
            return false;
        }
        if (element instanceof PsiAnonymousClass) {
            return false;
        }
        return InlineToAnonymousClassHandler.findClassInheritors((PsiClass)element);
    }

    private static boolean findClassInheritors(PsiClass element) {
        ArrayList inheritors = new ArrayList();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass inheritor = (PsiClass)ClassInheritorsSearch.search((PsiClass)element).findFirst();
            if (inheritor != null) {
                inheritors.add(inheritor);
            } else {
                PsiFunctionalExpression functionalExpression = (PsiFunctionalExpression)FunctionalExpressionSearch.search((PsiClass)element).findFirst();
                if (functionalExpression != null) {
                    inheritors.add(functionalExpression);
                }
            }
        }), "Searching for class \"" + element.getQualifiedName() + "\" inheritors ...", true, element.getProject())) {
            return false;
        }
        return inheritors.isEmpty();
    }

    public boolean canInlineElementInEditor(PsiElement element, Editor editor) {
        if (this.canInlineElement(element)) {
            PsiReference reference;
            PsiReference psiReference = reference = editor != null ? TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset()) : null;
            if (!InlineMethodHandler.isThisReference(reference)) {
                if (element instanceof PsiMethod && reference != null) {
                    PsiElement referenceElement = reference.getElement();
                    return referenceElement != null && !PsiTreeUtil.isAncestor((PsiElement)((PsiMethod)element).getContainingClass(), (PsiElement)referenceElement, (boolean)false);
                }
                return true;
            }
        }
        return false;
    }

    public void inlineElement(Project project2, Editor editor, PsiElement psiElement) {
        PsiClass psiClass = psiElement instanceof PsiMethod ? ((PsiMethod)psiElement).getContainingClass() : (PsiClass)psiElement;
        PsiCall callToInline = InlineToAnonymousClassHandler.findCallToInline(editor);
        PsiClassType superType = InlineToAnonymousClassProcessor.getSuperType(psiClass);
        if (superType == null) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)"java.lang.Object is not found", (String)RefactoringBundle.message((String)"inline.to.anonymous.refactoring"), null);
            return;
        }
        Ref errorMessage = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> errorMessage.set((Object)InlineToAnonymousClassHandler.getCannotInlineMessage((PsiClass)psiClass.getNavigationElement()))), "Check if inline is possible...", true, project2)) {
            return;
        }
        if (errorMessage.get() != null) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)((String)errorMessage.get()), (String)RefactoringBundle.message((String)"inline.to.anonymous.refactoring"), null);
            return;
        }
        new InlineToAnonymousClassDialog(project2, psiClass, callToInline, InlineToAnonymousClassHandler.canBeInvokedOnReference(callToInline, (PsiType)superType)).show();
    }

    public static boolean canBeInvokedOnReference(PsiCall callToInline, PsiType superType) {
        if (callToInline != null) {
            JavaResolveResult resolveResult;
            PsiElement resolvedMethod;
            int paramIdx;
            PsiMethodCallExpression methodCallExpression;
            PsiElement parent = callToInline.getParent();
            if (parent instanceof PsiExpressionStatement || parent instanceof PsiSynchronizedStatement) {
                return true;
            }
            if (parent instanceof PsiReferenceExpression) {
                return true;
            }
            if (parent instanceof PsiExpressionList && (methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethodCallExpression.class)) != null && (paramIdx = ArrayUtil.find((Object[])methodCallExpression.getArgumentList().getExpressions(), (Object)callToInline)) != -1 && (resolvedMethod = (resolveResult = methodCallExpression.resolveMethodGenerics()).getElement()) instanceof PsiMethod) {
                PsiType paramType;
                PsiParameter[] parameters2 = ((PsiMethod)resolvedMethod).getParameterList().getParameters();
                if (paramIdx >= parameters2.length) {
                    PsiParameter varargParameter = parameters2[parameters2.length - 1];
                    paramType = varargParameter.getType();
                } else {
                    paramType = parameters2[paramIdx].getType();
                }
                if (paramType instanceof PsiEllipsisType) {
                    paramType = ((PsiEllipsisType)paramType).getComponentType();
                }
                paramType = resolveResult.getSubstitutor().substitute(paramType);
                PsiJavaCodeReferenceElement classReference2 = ((PsiNewExpression)callToInline).getClassOrAnonymousClassReference();
                if (classReference2 != null && TypeConversionUtil.isAssignable((PsiType)paramType, (PsiType)(superType = classReference2.advancedResolve(false).getSubstitutor().substitute(superType)))) {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static PsiCall findCallToInline(Editor editor) {
        PsiElement element;
        PsiReference reference;
        PsiCall callToInline = null;
        PsiReference psiReference = reference = editor != null ? TargetElementUtil.findReference(editor) : null;
        if (reference != null && (element = reference.getElement()) instanceof PsiJavaCodeReferenceElement) {
            callToInline = RefactoringUtil.getEnclosingConstructorCall((PsiJavaCodeReferenceElement)element);
        }
        return callToInline;
    }

    @Nullable
    public static String getCannotInlineMessage(PsiClass psiClass) {
        PsiClassInitializer[] initializers;
        PsiField[] fields;
        PsiClass[] psiClassArray;
        PsiMethod[] methods;
        PsiClassType[] classTypes;
        if (psiClass instanceof PsiTypeParameter) {
            return "Type parameters cannot be inlined";
        }
        if (psiClass.isAnnotationType()) {
            return "Annotation types cannot be inlined";
        }
        if (psiClass.isInterface()) {
            return "Interfaces cannot be inlined";
        }
        if (psiClass.isEnum()) {
            return "Enums cannot be inlined";
        }
        if (psiClass.hasModifierProperty("abstract")) {
            return RefactoringBundle.message((String)"inline.to.anonymous.no.abstract");
        }
        if (psiClass instanceof PsiCompiledElement) {
            return "Library classes cannot be inlined";
        }
        for (PsiClassType psiClassType : classTypes = psiClass.getExtendsListTypes()) {
            PsiClass superClass = psiClassType.resolve();
            if (superClass != null) continue;
            return "Class cannot be inlined because its superclass cannot be resolved";
        }
        PsiClassType[] interfaces = psiClass.getImplementsListTypes();
        if (interfaces.length > 1) {
            return RefactoringBundle.message((String)"inline.to.anonymous.no.multiple.interfaces");
        }
        if (interfaces.length == 1) {
            PsiClassType interfaceType;
            if (interfaces[0].resolve() == null) {
                return "Class cannot be inlined because an interface implemented by it cannot be resolved";
            }
            PsiClass superClass = psiClass.getSuperClass();
            if (superClass != null && !"java.lang.Object".equals(superClass.getQualifiedName()) && !InlineToAnonymousClassHandler.isRedundantImplements(superClass, interfaceType = interfaces[0])) {
                return RefactoringBundle.message((String)"inline.to.anonymous.no.superclass.and.interface");
            }
        }
        GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)psiClass.getProject());
        for (PsiMethod method : methods = psiClass.getMethods()) {
            if (method.isConstructor()) {
                if (PsiUtil.findReturnStatements((PsiMethod)method).length > 0) {
                    return "Class cannot be inlined because its constructor contains 'return' statements";
                }
            } else if (method.findSuperMethods().length == 0 && !ReferencesSearch.search((PsiElement)method, (SearchScope)searchScope).forEach((Processor)new AllowedUsagesProcessor((PsiElement)psiClass))) {
                return "Class cannot be inlined because there are usages of its methods not inherited from its superclass or interface";
            }
            if (!method.hasModifierProperty("static")) continue;
            return "Class cannot be inlined because it has static methods";
        }
        for (PsiClass innerClass : psiClassArray = psiClass.getInnerClasses()) {
            PsiModifierList classModifiers = innerClass.getModifierList();
            if (classModifiers.hasModifierProperty("static")) {
                return "Class cannot be inlined because it has static inner classes";
            }
            if (ReferencesSearch.search((PsiElement)innerClass, (SearchScope)searchScope).forEach((Processor)new AllowedUsagesProcessor((PsiElement)psiClass))) continue;
            return "Class cannot be inlined because it has usages of its inner classes";
        }
        for (PsiField field : fields = psiClass.getFields()) {
            PsiModifierList fieldModifiers = field.getModifierList();
            if (fieldModifiers != null && fieldModifiers.hasModifierProperty("static")) {
                if (!fieldModifiers.hasModifierProperty("final")) {
                    return "Class cannot be inlined because it has static non-final fields";
                }
                Object initValue = null;
                PsiExpression initializer = field.getInitializer();
                if (initializer != null) {
                    initValue = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)initializer);
                }
                if (initValue == null) {
                    return "Class cannot be inlined because it has static fields with non-constant initializers";
                }
            }
            if (ReferencesSearch.search((PsiElement)field, (SearchScope)searchScope).forEach((Processor)new AllowedUsagesProcessor((PsiElement)psiClass))) continue;
            return "Class cannot be inlined because it has usages of fields not inherited from its superclass";
        }
        for (PsiClassInitializer initializer : initializers = psiClass.getInitializers()) {
            PsiModifierList modifiers = initializer.getModifierList();
            if (modifiers == null || !modifiers.hasModifierProperty("static")) continue;
            return "Class cannot be inlined because it has static initializers";
        }
        return InlineToAnonymousClassHandler.getCannotInlineDueToUsagesMessage(psiClass);
    }

    static boolean isRedundantImplements(@NotNull PsiClass superClass, PsiClassType interfaceType) {
        PsiClassType[] superClassInterfaces;
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "com/intellij/refactoring/inline/InlineToAnonymousClassHandler", "isRedundantImplements"));
        }
        boolean redundantImplements = false;
        for (PsiClassType superClassInterface : superClassInterfaces = superClass.getImplementsListTypes()) {
            if (!superClassInterface.equals((Object)interfaceType)) continue;
            redundantImplements = true;
            break;
        }
        return redundantImplements;
    }

    @Nullable
    private static String getCannotInlineDueToUsagesMessage(PsiClass aClass) {
        boolean hasUsages = false;
        for (PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)GlobalSearchScope.projectScope((Project)aClass.getProject()))) {
            JavaResolveResult resolveResult;
            PsiExpressionList newArgumentList;
            PsiElement parentElement;
            PsiElement element = reference.getElement();
            if (element == null) continue;
            if (!PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)element, (boolean)false)) {
                hasUsages = true;
            }
            if ((parentElement = element.getParent()) != null) {
                PsiElement grandPa = parentElement.getParent();
                if (grandPa instanceof PsiClassObjectAccessExpression) {
                    return "Class cannot be inlined because it has usages of its class literal";
                }
                if (ourCatchClausePattern.accepts((Object)parentElement)) {
                    return "Class cannot be inlined because it is used in a 'catch' clause";
                }
            }
            if (ourThrowsClausePattern.accepts((Object)element)) {
                return "Class cannot be inlined because it is used in a 'throws' clause";
            }
            if (parentElement instanceof PsiThisExpression) {
                return "Class cannot be inlined because it is used as a 'this' qualifier";
            }
            if (!(parentElement instanceof PsiNewExpression)) continue;
            PsiNewExpression newExpression = (PsiNewExpression)parentElement;
            PsiMethod[] constructors = aClass.getConstructors();
            if (!(constructors.length == 0 ? (newArgumentList = newExpression.getArgumentList()) != null && newArgumentList.getExpressions().length > 0 : !(resolveResult = newExpression.resolveMethodGenerics()).isValidResult())) continue;
            return "Class cannot be inlined because a call to its constructor is unresolved";
        }
        if (!hasUsages) {
            return RefactoringBundle.message((String)"class.is.never.used");
        }
        return null;
    }

    private static class AllowedUsagesProcessor
    implements Processor<PsiReference> {
        private final PsiElement myPsiElement;

        public AllowedUsagesProcessor(PsiElement psiElement) {
            this.myPsiElement = psiElement;
        }

        public boolean process(PsiReference psiReference) {
            PsiElement element = psiReference.getElement();
            if (element != null && PsiTreeUtil.isAncestor((PsiElement)this.myPsiElement, (PsiElement)element.getNavigationElement(), (boolean)false)) {
                return true;
            }
            if (element instanceof PsiReferenceExpression) {
                PsiNewExpression newExpr;
                PsiJavaCodeReferenceElement classRef;
                PsiExpression qualifier = ((PsiReferenceExpression)element).getQualifierExpression();
                while (qualifier instanceof PsiParenthesizedExpression) {
                    qualifier = ((PsiParenthesizedExpression)qualifier).getExpression();
                }
                if (qualifier instanceof PsiNewExpression && (classRef = (newExpr = (PsiNewExpression)qualifier).getClassReference()) != null && this.myPsiElement.isEquivalentTo(classRef.resolve())) {
                    return true;
                }
            }
            return false;
        }
    }
}

