/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduce;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.IntroduceTarget;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntroduceHandler<Target extends IntroduceTarget, Scope extends PsiElement>
implements RefactoringActionHandler {
    public void invoke(final @NotNull Project project2, final Editor editor, final PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduce/IntroduceHandler", "invoke"));
        }
        if (editor == null || file2 == null) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)file2)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        int caretCount = editor.getCaretModel().getCaretCount();
        if (caretCount != 1) {
            this.cannotPerformRefactoring(project2, editor);
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            this.invokeOnSelection(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd(), project2, editor, file2);
        } else {
            int offset = editor.getCaretModel().getOffset();
            Pair<List<Target>, Integer> targetInfo = this.collectTargets(offset, file2, editor, project2);
            List list2 = (List)targetInfo.getFirst();
            if (list2.isEmpty()) {
                this.cannotPerformRefactoring(project2, editor);
            } else if (list2.size() == 1) {
                this.invokeOnTarget((IntroduceTarget)list2.get(0), file2, editor, project2);
            } else {
                IntroduceTargetChooser.showIntroduceTargetChooser(editor, list2, new Pass<Target>(){

                    public void pass(Target target2) {
                        IntroduceHandler.this.invokeOnTarget(target2, file2, editor, project2);
                    }
                }, "Expressions", (Integer)targetInfo.getSecond());
            }
        }
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduce/IntroduceHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/introduce/IntroduceHandler", "invoke"));
        }
    }

    private void invokeOnTarget(@NotNull Target target2, @NotNull PsiFile file2, @NotNull Editor editor, @NotNull Project project2) {
        if (target2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeOnTarget"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeOnTarget"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeOnTarget"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeOnTarget"));
        }
        String message2 = this.checkSelectedTarget(target2, file2, editor, project2);
        if (message2 != null) {
            this.showErrorHint(message2, editor, project2);
            return;
        }
        this.invokeScopeStep(target2, file2, editor, project2);
    }

    private void invokeOnSelection(int start, int end, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeOnSelection"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeOnSelection"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeOnSelection"));
        }
        Target target2 = this.findSelectionTarget(start, end, file2, editor, project2);
        if (target2 != null) {
            this.invokeScopeStep(target2, file2, editor, project2);
        } else {
            this.cannotPerformRefactoring(project2, editor);
        }
    }

    private void invokeScopeStep(@NotNull Target target2, @NotNull PsiFile file2, @NotNull Editor editor, @NotNull Project project2) {
        if (target2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeScopeStep"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeScopeStep"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeScopeStep"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeScopeStep"));
        }
        List<Scope> scopes = this.collectTargetScopes(target2, editor, file2, project2);
        if (scopes.isEmpty()) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)this.getEmptyScopeErrorMessage());
            this.showErrorHint(message2, editor, project2);
            return;
        }
        if (scopes.size() == 1) {
            this.invokeFindUsageStep(target2, (PsiElement)scopes.get(0), file2, editor, project2);
        } else {
            PsiElement[] scopeArray = PsiUtilCore.toPsiElementArray(scopes);
            NavigationUtil.getPsiElementPopup((PsiElement[])scopeArray, this.getScopeRenderer(), (String)this.getChooseScopeTitle(), scope -> {
                if (target2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/refactoring/introduce/IntroduceHandler", "lambda$invokeScopeStep$0"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/introduce/IntroduceHandler", "lambda$invokeScopeStep$0"));
                }
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/introduce/IntroduceHandler", "lambda$invokeScopeStep$0"));
                }
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduce/IntroduceHandler", "lambda$invokeScopeStep$0"));
                }
                this.invokeFindUsageStep(target2, scope, file2, editor, project2);
                return false;
            }).showInBestPositionFor(editor);
        }
    }

    private void invokeFindUsageStep(@NotNull Target target2, @NotNull Scope scope, @NotNull PsiFile file2, @NotNull Editor editor, @NotNull Project project2) {
        if (target2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeFindUsageStep"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeFindUsageStep"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeFindUsageStep"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeFindUsageStep"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeFindUsageStep"));
        }
        List<UsageInfo> usages = this.collectUsages(target2, scope);
        String message2 = this.checkUsages(usages);
        if (message2 != null) {
            this.showErrorHint(message2, editor, project2);
            return;
        }
        this.invokeDialogStep(target2, scope, usages, file2, editor, project2);
    }

    private void invokeDialogStep(final @NotNull Target target2, final @NotNull Scope scope, final @NotNull List<UsageInfo> usages, final @NotNull PsiFile file2, final @NotNull Editor editor, final @NotNull Project project2) {
        if (target2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeDialogStep"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeDialogStep"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeDialogStep"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeDialogStep"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeDialogStep"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduce/IntroduceHandler", "invokeDialogStep"));
        }
        Map occurrencesMap = this.getOccurrenceOptions(target2, usages);
        OccurrencesChooser<Object> chooser = new OccurrencesChooser<Object>(editor){

            @Override
            protected TextRange getOccurrenceRange(Object occurrence) {
                return IntroduceHandler.this.getOccurrenceRange(occurrence);
            }
        };
        chooser.showChooser(new Pass<OccurrencesChooser.ReplaceChoice>(){

            public void pass(OccurrencesChooser.ReplaceChoice choice) {
                AbstractInplaceIntroducer<?, ?> introducer = IntroduceHandler.this.getIntroducer(target2, scope, usages, choice, file2, editor, project2);
                introducer.startInplaceIntroduceTemplate();
            }
        }, occurrencesMap);
    }

    @NotNull
    private TextRange getOccurrenceRange(@NotNull Object occurrence) {
        if (occurrence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "occurrence", "com/intellij/refactoring/introduce/IntroduceHandler", "getOccurrenceRange"));
        }
        if (occurrence instanceof PsiElement) {
            TextRange textRange = ((PsiElement)occurrence).getTextRange();
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduce/IntroduceHandler", "getOccurrenceRange"));
            }
            return textRange;
        }
        if (occurrence instanceof UsageInfo) {
            Segment segment = ((UsageInfo)occurrence).getSegment();
            assert (segment != null);
            TextRange textRange = TextRange.create((Segment)segment);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduce/IntroduceHandler", "getOccurrenceRange"));
            }
            return textRange;
        }
        TextRange textRange = ((IntroduceTarget)occurrence).getTextRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduce/IntroduceHandler", "getOccurrenceRange"));
        }
        return textRange;
    }

    @NotNull
    private Map<OccurrencesChooser.ReplaceChoice, List<Object>> getOccurrenceOptions(@NotNull Target target2, @NotNull List<UsageInfo> usages) {
        if (target2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/refactoring/introduce/IntroduceHandler", "getOccurrenceOptions"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/introduce/IntroduceHandler", "getOccurrenceOptions"));
        }
        LinkedHashMap map2 = ContainerUtil.newLinkedHashMap();
        map2.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList(target2));
        if (usages.size() > 1) {
            map2.put(OccurrencesChooser.ReplaceChoice.ALL, ContainerUtil.newArrayList(usages));
        }
        LinkedHashMap linkedHashMap = map2;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduce/IntroduceHandler", "getOccurrenceOptions"));
        }
        return linkedHashMap;
    }

    @NotNull
    protected abstract List<UsageInfo> collectUsages(@NotNull Target var1, @NotNull Scope var2);

    @Nullable
    protected abstract String checkUsages(@NotNull List<UsageInfo> var1);

    @NotNull
    protected abstract List<Scope> collectTargetScopes(@NotNull Target var1, @NotNull Editor var2, @NotNull PsiFile var3, @NotNull Project var4);

    @NotNull
    protected abstract Pair<List<Target>, Integer> collectTargets(int var1, @NotNull PsiFile var2, @NotNull Editor var3, @NotNull Project var4);

    @Nullable
    protected abstract Target findSelectionTarget(int var1, int var2, @NotNull PsiFile var3, @NotNull Editor var4, @NotNull Project var5);

    @Nullable
    protected abstract String checkSelectedTarget(@NotNull Target var1, @NotNull PsiFile var2, @NotNull Editor var3, @NotNull Project var4);

    @NotNull
    protected abstract String getRefactoringName();

    @Nullable
    protected abstract String getHelpID();

    @NotNull
    protected abstract String getChooseScopeTitle();

    @NotNull
    protected abstract PsiElementListCellRenderer<Scope> getScopeRenderer();

    @NotNull
    protected abstract AbstractInplaceIntroducer<?, ?> getIntroducer(@NotNull Target var1, @NotNull Scope var2, @NotNull List<UsageInfo> var3, @NotNull OccurrencesChooser.ReplaceChoice var4, @NotNull PsiFile var5, @NotNull Editor var6, @NotNull Project var7);

    @NotNull
    protected String getEmptyScopeErrorMessage() {
        String string = this.getRefactoringName() + " is not available in the current scope";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduce/IntroduceHandler", "getEmptyScopeErrorMessage"));
        }
        return string;
    }

    protected void showErrorHint(@NotNull String errorMessage, @NotNull Editor editor, @NotNull Project project2) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/refactoring/introduce/IntroduceHandler", "showErrorHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/introduce/IntroduceHandler", "showErrorHint"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduce/IntroduceHandler", "showErrorHint"));
        }
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)errorMessage, (String)this.getRefactoringName(), (String)this.getHelpID());
    }

    private void cannotPerformRefactoring(@NotNull Project project2, @NotNull Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduce/IntroduceHandler", "cannotPerformRefactoring"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/introduce/IntroduceHandler", "cannotPerformRefactoring"));
        }
        this.showErrorHint(RefactoringBundle.message((String)"cannot.perform.refactoring"), editor, project2);
    }
}

