/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject.usageInfo;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class ReplaceParameterIncrementDecrement
extends FixableUsageInfo {
    private final PsiExpression expression;
    private final String newParameterName;
    private final String parameterSetterName;
    private final String parameterGetterName;

    public ReplaceParameterIncrementDecrement(PsiExpression element, String newParameterName, String parameterSetterName, String parameterGetterName) {
        super((PsiElement)element);
        this.parameterSetterName = parameterSetterName;
        this.parameterGetterName = parameterGetterName;
        this.newParameterName = newParameterName;
        PsiPrefixExpression prefixExpr = (PsiPrefixExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiPrefixExpression.class);
        this.expression = prefixExpr != null ? prefixExpr : (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiPostfixExpression.class);
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        PsiJavaToken sign = this.expression instanceof PsiPrefixExpression ? ((PsiPrefixExpression)this.expression).getOperationSign() : ((PsiPostfixExpression)this.expression).getOperationSign();
        String operator2 = sign.getText();
        String strippedOperator = operator2.substring(0, operator2.length() - 1);
        String newExpression = this.newParameterName + '.' + this.parameterSetterName + '(' + this.newParameterName + '.' + this.parameterGetterName + "()" + strippedOperator + "1)";
        if (this.expression.getParent() instanceof PsiBinaryExpression) {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.expression.getProject()).getElementFactory();
            PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiStatement.class);
            statement2.getParent().addBefore((PsiElement)factory.createStatementFromText(newExpression + ";", (PsiElement)this.expression), (PsiElement)statement2);
            this.expression.replace((PsiElement)factory.createExpressionFromText(this.newParameterName + "." + this.parameterGetterName + "()", (PsiElement)this.expression));
        } else {
            MutationUtils.replaceExpression(newExpression, this.expression);
        }
    }
}

