/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPullUp;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.memberPullUp.PullUpData;
import com.intellij.refactoring.memberPullUp.PullUpHelper;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.ClassMemberReferencesVisitor;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class JavaPullUpHelper
implements PullUpHelper<MemberInfo> {
    private static final Logger LOG = Logger.getInstance(JavaPullUpHelper.class);
    private static final Key<Boolean> PRESERVE_QUALIFIER = Key.create((String)"PRESERVE_QUALIFIER");
    private final PsiClass mySourceClass;
    private final PsiClass myTargetSuperClass;
    private final boolean myIsTargetInterface;
    private final DocCommentPolicy myJavaDocPolicy;
    private Set<PsiMember> myMembersAfterMove;
    private final Set<PsiMember> myMembersToMove;
    private final Project myProject;
    private final QualifiedThisSuperAdjuster myThisSuperAdjuster;
    private final ExplicitSuperDeleter myExplicitSuperDeleter;

    public JavaPullUpHelper(PullUpData data) {
        this.myProject = data.getProject();
        this.myMembersToMove = data.getMembersToMove();
        this.myMembersAfterMove = data.getMovedMembers();
        this.myTargetSuperClass = data.getTargetClass();
        this.mySourceClass = data.getSourceClass();
        this.myJavaDocPolicy = data.getDocCommentPolicy();
        this.myIsTargetInterface = this.myTargetSuperClass.isInterface();
        this.myThisSuperAdjuster = new QualifiedThisSuperAdjuster();
        this.myExplicitSuperDeleter = new ExplicitSuperDeleter();
    }

    public void encodeContextInfo(MemberInfo info) {
        ChangeContextUtil.encodeContextInfo(info.getMember(), true);
    }

    public void move(MemberInfo info, PsiSubstitutor substitutor) {
        if (info.getMember() instanceof PsiMethod) {
            this.doMoveMethod(substitutor, info);
        } else if (info.getMember() instanceof PsiField) {
            this.doMoveField(substitutor, info);
        } else if (info.getMember() instanceof PsiClass) {
            this.doMoveClass(substitutor, info);
        }
    }

    public void postProcessMember(PsiMember member) {
        member.accept((PsiElementVisitor)this.myExplicitSuperDeleter);
        member.accept((PsiElementVisitor)this.myThisSuperAdjuster);
        ChangeContextUtil.decodeContextInfo((PsiElement)member, null, null);
        member.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                Boolean preserveQualifier;
                PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
                if (qualifierExpression2 != null && (preserveQualifier = (Boolean)qualifierExpression2.getCopyableUserData(PRESERVE_QUALIFIER)) != null && !preserveQualifier.booleanValue()) {
                    qualifierExpression2.delete();
                    return;
                }
                super.visitReferenceExpression(expression2);
            }
        });
    }

    public void setCorrectVisibility(MemberInfo info) {
        PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)info.getMember();
        if (this.myIsTargetInterface) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)modifierListOwner, (String)"public", (boolean)true);
        } else if (modifierListOwner.hasModifierProperty("private")) {
            if (info.isToAbstract() || this.willBeUsedInSubclass((PsiElement)modifierListOwner, this.myTargetSuperClass, this.mySourceClass)) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)modifierListOwner, (String)"protected", (boolean)true);
            }
            if (modifierListOwner instanceof PsiClass) {
                modifierListOwner.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitMethod(PsiMethod method) {
                        this.check((PsiMember)method);
                    }

                    public void visitField(PsiField field) {
                        this.check((PsiMember)field);
                    }

                    public void visitClass(PsiClass aClass) {
                        this.check((PsiMember)aClass);
                        super.visitClass(aClass);
                    }

                    private void check(PsiMember member) {
                        if (member.hasModifierProperty("private") && JavaPullUpHelper.this.willBeUsedInSubclass((PsiElement)member, JavaPullUpHelper.this.myTargetSuperClass, JavaPullUpHelper.this.mySourceClass)) {
                            PsiUtil.setModifierProperty((PsiModifierListOwner)member, (String)"protected", (boolean)true);
                        }
                    }
                });
            }
        }
    }

    private void doMoveClass(PsiSubstitutor substitutor, MemberInfo info) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        PsiClass aClass = (PsiClass)info.getMember();
        if (Boolean.FALSE.equals(info.getOverrides())) {
            PsiJavaCodeReferenceElement ref;
            PsiReferenceList sourceReferenceList = info.getSourceReferenceList();
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = sourceReferenceList == null ? null : (ref = this.mySourceClass.equals(sourceReferenceList.getParent()) ? RefactoringUtil.removeFromReferenceList(sourceReferenceList, aClass) : RefactoringUtil.findReferenceToClass(sourceReferenceList, aClass));
            if (ref != null && !this.myTargetSuperClass.isInheritor(aClass, false)) {
                PsiReferenceList referenceList;
                RefactoringUtil.replaceMovedMemberTypeParameters((PsiElement)ref, PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)this.mySourceClass), substitutor, elementFactory);
                PsiReferenceList psiReferenceList = referenceList = this.myIsTargetInterface ? this.myTargetSuperClass.getExtendsList() : this.myTargetSuperClass.getImplementsList();
                assert (referenceList != null);
                referenceList.add((PsiElement)ref);
            }
        } else {
            RefactoringUtil.replaceMovedMemberTypeParameters((PsiElement)aClass, PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)this.mySourceClass), substitutor, elementFactory);
            this.fixReferencesToStatic((PsiElement)aClass);
            PsiMember movedElement = (PsiMember)this.myTargetSuperClass.add((PsiElement)JavaPullUpHelper.convertClassToLanguage(aClass, this.myTargetSuperClass.getLanguage()));
            this.myMembersAfterMove.add(movedElement);
            aClass.delete();
        }
    }

    private void doMoveField(PsiSubstitutor substitutor, MemberInfo info) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        PsiField field = (PsiField)info.getMember();
        field.normalizeDeclaration();
        RefactoringUtil.replaceMovedMemberTypeParameters((PsiElement)field, PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)this.mySourceClass), substitutor, elementFactory);
        this.fixReferencesToStatic((PsiElement)field);
        if (this.myIsTargetInterface) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"public", (boolean)true);
        }
        PsiMember movedElement = (PsiMember)this.myTargetSuperClass.add((PsiElement)JavaPullUpHelper.convertFieldToLanguage(field, this.myTargetSuperClass.getLanguage()));
        this.myMembersAfterMove.add(movedElement);
        field.delete();
    }

    private void doMoveMethod(PsiSubstitutor substitutor, MemberInfo info) {
        PsiMethod method;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        PsiMethod sibling = method = (PsiMethod)info.getMember();
        PsiMethod anchor = null;
        while (sibling != null && ((sibling = (PsiMethod)PsiTreeUtil.getNextSiblingOfType((PsiElement)sibling, PsiMethod.class)) == null || (anchor = MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived((PsiClass)method.getContainingClass(), (PsiClass)this.myTargetSuperClass, (MethodSignature)sibling.getSignature(PsiSubstitutor.EMPTY), (boolean)false)) == null)) {
        }
        PsiMethod methodCopy = (PsiMethod)method.copy();
        RefactoringUtil.replaceMovedMemberTypeParameters((PsiElement)methodCopy, PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)this.mySourceClass), substitutor, elementFactory);
        Language language = this.myTargetSuperClass.getLanguage();
        PsiMethod superClassMethod = MethodSignatureUtil.findMethodBySuperSignature((PsiClass)this.myTargetSuperClass, (MethodSignature)method.getSignature(substitutor), (boolean)false);
        if (superClassMethod != null && superClassMethod.findDeepestSuperMethods().length == 0 || method.findSuperMethods(this.myTargetSuperClass).length == 0) {
            JavaPullUpHelper.deleteOverrideAnnotationIfFound(methodCopy);
        }
        boolean isOriginalMethodAbstract = method.hasModifierProperty("abstract");
        if (this.myIsTargetInterface || info.isToAbstract()) {
            ChangeContextUtil.clearContextInfo((PsiElement)method);
            if (!info.isToAbstract() && !method.hasModifierProperty("abstract") && PsiUtil.isLanguageLevel8OrHigher((PsiElement)this.myTargetSuperClass)) {
                RefactoringUtil.makeMethodDefault(methodCopy);
                isOriginalMethodAbstract = true;
            } else {
                if (info.isToAbstract() && method.hasModifierProperty("default")) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)methodCopy, (String)"default", (boolean)false);
                }
                RefactoringUtil.makeMethodAbstract(this.myTargetSuperClass, methodCopy);
            }
            this.myJavaDocPolicy.processCopiedJavaDoc((PsiComment)methodCopy.getDocComment(), (PsiComment)method.getDocComment(), isOriginalMethodAbstract);
            PsiMethod movedElement = superClassMethod != null && superClassMethod.hasModifierProperty("abstract") ? (PsiMethod)superClassMethod.replace((PsiElement)JavaPullUpHelper.convertMethodToLanguage(methodCopy, language)) : (PsiMethod)(anchor != null ? this.myTargetSuperClass.addBefore((PsiElement)methodCopy, (PsiElement)anchor) : this.myTargetSuperClass.add((PsiElement)methodCopy));
            OverrideImplementUtil.annotateOnOverrideImplement(method, this.mySourceClass, movedElement);
            if (!PsiUtil.isLanguageLevel6OrHigher((PsiElement)this.mySourceClass) && this.myIsTargetInterface) {
                if (isOriginalMethodAbstract) {
                    for (PsiMethod oMethod : OverridingMethodsSearch.search((PsiMethod)method)) {
                        JavaPullUpHelper.deleteOverrideAnnotationIfFound(oMethod);
                    }
                }
                JavaPullUpHelper.deleteOverrideAnnotationIfFound(method);
            }
            this.myMembersAfterMove.add((PsiMember)movedElement);
            if (isOriginalMethodAbstract) {
                method.delete();
            }
        } else {
            if (isOriginalMethodAbstract) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)this.myTargetSuperClass, (String)"abstract", (boolean)true);
            }
            RefactoringUtil.replaceMovedMemberTypeParameters((PsiElement)methodCopy, PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)this.mySourceClass), substitutor, elementFactory);
            this.fixReferencesToStatic((PsiElement)methodCopy);
            if (superClassMethod != null && superClassMethod.hasModifierProperty("abstract")) {
                superClassMethod.replace((PsiElement)JavaPullUpHelper.convertMethodToLanguage(methodCopy, language));
            } else {
                PsiMember movedElement = anchor != null ? (PsiMember)this.myTargetSuperClass.addBefore((PsiElement)JavaPullUpHelper.convertMethodToLanguage(methodCopy, language), (PsiElement)anchor) : (PsiMember)this.myTargetSuperClass.add((PsiElement)JavaPullUpHelper.convertMethodToLanguage(methodCopy, language));
                this.myMembersAfterMove.add(movedElement);
            }
            method.delete();
        }
    }

    private static PsiMethod convertMethodToLanguage(PsiMethod method, Language language) {
        if (method.getLanguage().equals(language)) {
            return method;
        }
        return JVMElementFactories.getFactory((Language)language, (Project)method.getProject()).createMethodFromText(method.getText(), null);
    }

    private static PsiField convertFieldToLanguage(PsiField field, Language language) {
        if (field.getLanguage().equals(language)) {
            return field;
        }
        return JVMElementFactories.getFactory((Language)language, (Project)field.getProject()).createField(field.getName(), field.getType());
    }

    private static PsiClass convertClassToLanguage(PsiClass clazz, Language language) {
        return clazz;
    }

    private static void deleteOverrideAnnotationIfFound(PsiMethod oMethod) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)oMethod, (String[])new String[]{Override.class.getName()});
        if (annotation != null) {
            annotation.delete();
        }
    }

    public void moveFieldInitializations(LinkedHashSet<PsiField> movedFields) {
        PsiMethod[] constructors = this.myTargetSuperClass.getConstructors();
        if (constructors.length == 0) {
            constructors = new PsiMethod[]{null};
        }
        HashMap<PsiMethod, HashSet<PsiMethod>> constructorsToSubConstructors = this.buildConstructorsToSubConstructorsMap(constructors);
        for (PsiMethod constructor : constructors) {
            HashSet subConstructors = (HashSet)constructorsToSubConstructors.get((Object)constructor);
            this.tryToMoveInitializers(constructor, subConstructors, movedFields);
        }
    }

    public void updateUsage(PsiElement element) {
        PsiExpression qualifierExpression2;
        if (element instanceof PsiReferenceExpression && (qualifierExpression2 = ((PsiReferenceExpression)element).getQualifierExpression()) instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression2).resolve() == this.mySourceClass) {
            ((PsiReferenceExpression)qualifierExpression2).bindToElement((PsiElement)this.myTargetSuperClass);
        }
    }

    private void tryToMoveInitializers(PsiMethod constructor, HashSet<PsiMethod> subConstructors, LinkedHashSet<PsiField> movedFields) throws IncorrectOperationException {
        final LinkedHashMap<PsiField, Initializer> fieldsToInitializers = new LinkedHashMap<PsiField, Initializer>();
        boolean anyFound = false;
        for (PsiField field : movedFields) {
            PsiMethod subConstructor;
            PsiStatement commonInitializer = null;
            ArrayList<PsiElement> fieldInitializersToRemove = new ArrayList<PsiElement>();
            Iterator<PsiMethod> iterator = subConstructors.iterator();
            while (iterator.hasNext() && (commonInitializer = this.hasCommonInitializer(commonInitializer, subConstructor = iterator.next(), field, fieldInitializersToRemove)) != null) {
            }
            if (commonInitializer == null) continue;
            ParametersAndMovedFieldsUsedCollector visitor = new ParametersAndMovedFieldsUsedCollector(movedFields);
            commonInitializer.accept((PsiElementVisitor)visitor);
            fieldsToInitializers.put(field, new Initializer(commonInitializer, visitor.getUsedFields(), visitor.getUsedParameters(), fieldInitializersToRemove));
            anyFound = true;
        }
        if (!anyFound) {
            return;
        }
        final Set initializedFields = fieldsToInitializers.keySet();
        Set<PsiField> unmovable = RefactoringUtil.transitiveClosure(new RefactoringUtil.Graph<PsiField>(){

            @Override
            public Set<PsiField> getVertices() {
                return initializedFields;
            }

            @Override
            public Set<PsiField> getTargets(PsiField source) {
                return ((Initializer)fieldsToInitializers.get((Object)source)).movedFieldsUsed;
            }
        }, object -> !initializedFields.contains(object));
        for (PsiField psiField : unmovable) {
            fieldsToInitializers.remove(psiField);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        if (constructor == null) {
            constructor = (PsiMethod)this.myTargetSuperClass.add((PsiElement)factory.createConstructor());
            String visibilityModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)this.myTargetSuperClass.getModifierList());
            PsiUtil.setModifierProperty((PsiModifierListOwner)constructor, (String)visibilityModifier, (boolean)true);
        }
        ArrayList initializedFields2 = new ArrayList(fieldsToInitializers.keySet());
        Collections.sort(initializedFields2, (field1, field2) -> {
            Initializer i1 = (Initializer)fieldsToInitializers.get(field1);
            Initializer i2 = (Initializer)fieldsToInitializers.get(field2);
            if (i1.movedFieldsUsed.contains(field2)) {
                return 1;
            }
            if (i2.movedFieldsUsed.contains(field1)) {
                return -1;
            }
            return 0;
        });
        for (PsiField initializedField : initializedFields2) {
            Initializer initializer = (Initializer)fieldsToInitializers.get(initializedField);
            PsiParameterList parameterList = constructor.getParameterList();
            for (PsiParameter parameter : initializer.usedParameters) {
                parameterList.add((PsiElement)parameter);
            }
            for (PsiMethod subConstructor : subConstructors) {
                JavaPullUpHelper.modifySuperCall(subConstructor, initializer.usedParameters);
            }
            PsiStatement assignmentStatement = (PsiStatement)constructor.getBody().add((PsiElement)initializer.initializer);
            PsiManager manager = PsiManager.getInstance((Project)this.myProject);
            ChangeContextUtil.decodeContextInfo((PsiElement)assignmentStatement, this.myTargetSuperClass, (PsiExpression)RefactoringChangeUtil.createThisExpression(manager, null));
            for (PsiElement psiElement : initializer.statementsToRemove) {
                psiElement.delete();
            }
        }
    }

    private static void modifySuperCall(PsiMethod subConstructor, Set<PsiParameter> parametersToPassToSuper) {
        PsiCodeBlock body2 = subConstructor.getBody();
        if (body2 != null) {
            PsiMethodCallExpression methodCall;
            PsiExpression expression2;
            PsiMethodCallExpression superCall = null;
            PsiStatement[] statements = body2.getStatements();
            if (statements.length > 0 && statements[0] instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression && "super".equals((methodCall = (PsiMethodCallExpression)expression2).getMethodExpression().getText())) {
                superCall = methodCall;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)subConstructor.getProject()).getElementFactory();
            try {
                if (superCall == null) {
                    PsiExpressionStatement statement2 = (PsiExpressionStatement)factory.createStatementFromText("super();", null);
                    statement2 = (PsiExpressionStatement)body2.addAfter((PsiElement)statement2, null);
                    superCall = (PsiMethodCallExpression)statement2.getExpression();
                }
                PsiExpressionList argList = superCall.getArgumentList();
                for (PsiParameter parameter : parametersToPassToSuper) {
                    argList.add((PsiElement)factory.createExpressionFromText(parameter.getName(), null));
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Nullable
    private PsiStatement hasCommonInitializer(PsiStatement commonInitializer, PsiMethod subConstructor, PsiField field, ArrayList<PsiElement> statementsToRemove) {
        PsiCodeBlock body2 = subConstructor.getBody();
        if (body2 == null) {
            return null;
        }
        PsiStatement[] statements = body2.getStatements();
        PsiStatement commonInitializerCandidate = null;
        for (PsiStatement statement2 : statements) {
            HashSet<PsiStatement> collectedStatements = new HashSet<PsiStatement>();
            JavaPullUpHelper.collectPsiStatements((PsiElement)statement2, collectedStatements);
            boolean doLookup = true;
            for (PsiStatement collectedStatement : collectedStatements) {
                PsiElement resolved;
                PsiReferenceExpression lRef;
                PsiAssignmentExpression assignmentExpression;
                PsiExpression lExpression;
                PsiExpression expression2;
                if (!(collectedStatement instanceof PsiExpressionStatement) || !((expression2 = ((PsiExpressionStatement)collectedStatement).getExpression()) instanceof PsiAssignmentExpression) || !((lExpression = (assignmentExpression = (PsiAssignmentExpression)expression2).getLExpression()) instanceof PsiReferenceExpression) || (lRef = (PsiReferenceExpression)lExpression).getQualifierExpression() != null && !(lRef.getQualifierExpression() instanceof PsiThisExpression) || (resolved = lRef.resolve()) != field) continue;
                doLookup = false;
                if (commonInitializerCandidate == null) {
                    PsiExpression initializer = assignmentExpression.getRExpression();
                    if (initializer == null) {
                        return null;
                    }
                    if (commonInitializer == null) {
                        IsMovableInitializerVisitor visitor = new IsMovableInitializerVisitor();
                        statement2.accept((PsiElementVisitor)visitor);
                        if (visitor.isMovable()) {
                            ChangeContextUtil.encodeContextInfo((PsiElement)statement2, true);
                            PsiStatement statementCopy = (PsiStatement)statement2.copy();
                            ChangeContextUtil.clearContextInfo((PsiElement)statement2);
                            statementsToRemove.add((PsiElement)statement2);
                            commonInitializerCandidate = statementCopy;
                            continue;
                        }
                        return null;
                    }
                    if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)commonInitializer, (PsiElement)statement2)) {
                        statementsToRemove.add((PsiElement)statement2);
                        commonInitializerCandidate = commonInitializer;
                        continue;
                    }
                    return null;
                }
                if (PsiEquivalenceUtil.areElementsEquivalent(commonInitializerCandidate, (PsiElement)statement2)) continue;
                return null;
            }
            if (!doLookup) continue;
            PsiReference[] references = (PsiReference[])ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement)statement2), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY);
            if (commonInitializerCandidate == null && references.length > 0) {
                return null;
            }
            for (PsiReference reference : references) {
                if (!RefactoringUtil.isAssignmentLHS(reference.getElement())) continue;
                return null;
            }
        }
        return commonInitializerCandidate;
    }

    private static void collectPsiStatements(PsiElement root, Set<PsiStatement> collected) {
        if (root instanceof PsiStatement) {
            collected.add((PsiStatement)root);
        }
        for (PsiElement element : root.getChildren()) {
            JavaPullUpHelper.collectPsiStatements(element, collected);
        }
    }

    private HashMap<PsiMethod, HashSet<PsiMethod>> buildConstructorsToSubConstructorsMap(PsiMethod[] constructors) {
        HashMap constructorsToSubConstructors = new HashMap();
        for (PsiMethod constructor : constructors) {
            final HashSet<PsiMethod> referencingSubConstructors = new HashSet<PsiMethod>();
            constructorsToSubConstructors.put((Object)constructor, referencingSubConstructors);
            if (constructor != null) {
                for (PsiReference reference : ReferencesSearch.search((PsiElement)constructor, (SearchScope)new LocalSearchScope((PsiElement)this.mySourceClass), (boolean)false)) {
                    PsiMethod parentMethod;
                    PsiElement element = reference.getElement();
                    if (element == null || !"super".equals(element.getText()) || (parentMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) == null || !parentMethod.isConstructor()) continue;
                    referencingSubConstructors.add(parentMethod);
                }
            }
            if (constructor != null && constructor.getParameterList().getParametersCount() != 0) continue;
            RefactoringUtil.visitImplicitSuperConstructorUsages(this.mySourceClass, new RefactoringUtil.ImplicitConstructorUsageVisitor(){

                @Override
                public void visitConstructor(PsiMethod constructor, PsiMethod baseConstructor) {
                    referencingSubConstructors.add(constructor);
                }

                @Override
                public void visitClassWithoutConstructors(PsiClass aClass) {
                }
            }, this.myTargetSuperClass);
        }
        return constructorsToSubConstructors;
    }

    private void fixReferencesToStatic(PsiElement classMember) throws IncorrectOperationException {
        StaticReferencesCollector collector = new StaticReferencesCollector();
        classMember.accept((PsiElementVisitor)collector);
        ArrayList<PsiJavaCodeReferenceElement> refs = collector.getReferences();
        ArrayList<PsiElement> members = collector.getReferees();
        ArrayList<PsiClass> classes2 = collector.getRefereeClasses();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)classMember.getProject()).getElementFactory();
        for (int i2 = 0; i2 < refs.size(); ++i2) {
            PsiJavaCodeReferenceElement ref = refs.get(i2);
            PsiElement namedElement = members.get(i2);
            PsiClass aClass = classes2.get(i2);
            if (!(namedElement instanceof PsiNamedElement)) continue;
            PsiReferenceExpression newRef = (PsiReferenceExpression)factory.createExpressionFromText("a." + ((PsiNamedElement)namedElement).getName(), null);
            PsiExpression qualifierExpression2 = newRef.getQualifierExpression();
            assert (qualifierExpression2 != null);
            qualifierExpression2 = (PsiExpression)qualifierExpression2.replace((PsiElement)factory.createReferenceExpression(aClass));
            qualifierExpression2.putCopyableUserData(PRESERVE_QUALIFIER, (Object)ref.isQualified());
            ref.replace((PsiElement)newRef);
        }
    }

    private boolean willBeUsedInSubclass(PsiElement member, PsiClass superclass, PsiClass subclass) {
        for (PsiReference ref : ReferencesSearch.search((PsiElement)member, (SearchScope)new LocalSearchScope((PsiElement)subclass), (boolean)false)) {
            PsiElement element = ref.getElement();
            if (RefactoringHierarchyUtil.willBeInTargetClass(element, this.myMembersToMove, superclass, false)) continue;
            return true;
        }
        return false;
    }

    private class ExplicitSuperDeleter
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiExpression myThisExpression;

        private ExplicitSuperDeleter() {
            this.myThisExpression = JavaPsiFacade.getElementFactory((Project)JavaPullUpHelper.this.myProject).createExpressionFromText("this", null);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            PsiElement resolved;
            if (expression2.getQualifierExpression() instanceof PsiSuperExpression && ((resolved = expression2.resolve()) == null || resolved instanceof PsiMethod && this.shouldFixSuper((PsiMethod)resolved))) {
                expression2.getQualifierExpression().delete();
            }
        }

        public void visitSuperExpression(PsiSuperExpression expression2) {
            expression2.replace((PsiElement)this.myThisExpression);
        }

        public void visitClass(PsiClass aClass) {
        }

        private boolean shouldFixSuper(PsiMethod method) {
            for (PsiMember element : JavaPullUpHelper.this.myMembersAfterMove) {
                if (!(element instanceof PsiMethod)) continue;
                PsiMethod member = (PsiMethod)element;
                PsiManager manager = method.getManager();
                if (!manager.areElementsEquivalent((PsiElement)member.getContainingClass(), (PsiElement)method.getContainingClass()) || !MethodSignatureUtil.areSignaturesEqual((PsiMethod)member, (PsiMethod)method)) continue;
                return false;
            }
            PsiMethod methodFromSuper = JavaPullUpHelper.this.myTargetSuperClass.findMethodBySignature(method, false);
            return methodFromSuper == null;
        }
    }

    private class QualifiedThisSuperAdjuster
    extends JavaRecursiveElementVisitor {
        private QualifiedThisSuperAdjuster() {
        }

        public void visitThisExpression(PsiThisExpression expression2) {
            super.visitThisExpression(expression2);
            PsiJavaCodeReferenceElement qualifier = expression2.getQualifier();
            if (qualifier != null && qualifier.isReferenceTo((PsiElement)JavaPullUpHelper.this.mySourceClass)) {
                try {
                    qualifier.bindToElement((PsiElement)JavaPullUpHelper.this.myTargetSuperClass);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }

        public void visitSuperExpression(PsiSuperExpression expression2) {
            super.visitSuperExpression(expression2);
            PsiJavaCodeReferenceElement qualifier = expression2.getQualifier();
            if (qualifier != null && qualifier.isReferenceTo((PsiElement)JavaPullUpHelper.this.mySourceClass)) {
                try {
                    expression2.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)JavaPullUpHelper.this.myProject).createExpressionFromText(JavaPullUpHelper.this.myTargetSuperClass.getName() + ".this", null));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    private class StaticReferencesCollector
    extends ClassMemberReferencesVisitor {
        private final ArrayList<PsiJavaCodeReferenceElement> myReferences;
        private final ArrayList<PsiElement> myReferees;
        private final ArrayList<PsiClass> myRefereeClasses;

        private StaticReferencesCollector() {
            super(JavaPullUpHelper.this.mySourceClass);
            this.myReferees = new ArrayList();
            this.myRefereeClasses = new ArrayList();
            this.myReferences = new ArrayList();
        }

        public ArrayList<PsiElement> getReferees() {
            return this.myReferees;
        }

        public ArrayList<PsiClass> getRefereeClasses() {
            return this.myRefereeClasses;
        }

        public ArrayList<PsiJavaCodeReferenceElement> getReferences() {
            return this.myReferences;
        }

        @Override
        protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
            if (classMember.hasModifierProperty("static")) {
                if (!JavaPullUpHelper.this.myMembersToMove.contains(classMember) && RefactoringHierarchyUtil.isMemberBetween(JavaPullUpHelper.this.myTargetSuperClass, JavaPullUpHelper.this.mySourceClass, classMember)) {
                    this.myReferences.add(classMemberReference);
                    this.myReferees.add((PsiElement)classMember);
                    this.myRefereeClasses.add(classMember.getContainingClass());
                } else if (JavaPullUpHelper.this.myMembersToMove.contains(classMember) || JavaPullUpHelper.this.myMembersAfterMove.contains(classMember)) {
                    this.myReferences.add(classMemberReference);
                    this.myReferees.add((PsiElement)classMember);
                    this.myRefereeClasses.add(JavaPullUpHelper.this.myTargetSuperClass);
                }
            }
        }
    }

    private class IsMovableInitializerVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean myIsMovable = true;

        private IsMovableInitializerVisitor() {
        }

        public boolean isMovable() {
            return this.myIsMovable;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression2);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement referenceElement) {
            if (!this.myIsMovable) {
                return;
            }
            PsiExpression qualifier = referenceElement instanceof PsiReferenceExpression ? ((PsiReferenceExpression)referenceElement).getQualifierExpression() : null;
            if (qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
                PsiElement resolved = referenceElement.resolve();
                if (!(resolved instanceof PsiParameter)) {
                    if (resolved instanceof PsiClass && (((PsiClass)resolved).hasModifierProperty("static") || ((PsiClass)resolved).getContainingClass() == null)) {
                        return;
                    }
                    PsiClass containingClass = null;
                    if (resolved instanceof PsiMember && !((PsiMember)resolved).hasModifierProperty("static")) {
                        containingClass = ((PsiMember)resolved).getContainingClass();
                    }
                    this.myIsMovable = containingClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)JavaPullUpHelper.this.myTargetSuperClass, (PsiClass)containingClass, (boolean)true);
                }
            } else {
                qualifier.accept((PsiElementVisitor)this);
            }
        }

        public void visitElement(PsiElement element) {
            if (this.myIsMovable) {
                super.visitElement(element);
            }
        }
    }

    private static class ParametersAndMovedFieldsUsedCollector
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiField> myMovedFields;
        private final Set<PsiField> myUsedFields;
        private final Set<PsiParameter> myUsedParameters = new LinkedHashSet<PsiParameter>();

        private ParametersAndMovedFieldsUsedCollector(HashSet<PsiField> movedFields) {
            this.myMovedFields = movedFields;
            this.myUsedFields = new HashSet<PsiField>();
        }

        public Set<PsiParameter> getUsedParameters() {
            return this.myUsedParameters;
        }

        public Set<PsiField> getUsedFields() {
            return this.myUsedFields;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
            if (qualifierExpression2 != null && !(qualifierExpression2 instanceof PsiThisExpression)) {
                return;
            }
            PsiElement resolved = expression2.resolve();
            if (resolved instanceof PsiParameter) {
                this.myUsedParameters.add((PsiParameter)resolved);
            } else if (this.myMovedFields.contains(resolved)) {
                this.myUsedFields.add((PsiField)resolved);
            }
        }
    }

    private static class Initializer {
        public final PsiStatement initializer;
        public final Set<PsiField> movedFieldsUsed;
        public final Set<PsiParameter> usedParameters;
        public final List<PsiElement> statementsToRemove;

        private Initializer(PsiStatement initializer, Set<PsiField> movedFieldsUsed, Set<PsiParameter> usedParameters, List<PsiElement> statementsToRemove) {
            this.initializer = initializer;
            this.movedFieldsUsed = movedFieldsUsed;
            this.statementsToRemove = statementsToRemove;
            this.usedParameters = usedParameters;
        }
    }
}

