/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPushDown;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.classMembers.ClassMemberReferencesVisitor;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.containers.MultiMap;
import java.util.HashSet;
import java.util.Set;

public class PushDownConflicts {
    private final PsiClass myClass;
    private final Set<PsiMember> myMovedMembers;
    private final Set<PsiMethod> myAbstractMembers;
    private final MultiMap<PsiElement, String> myConflicts;

    public PushDownConflicts(PsiClass aClass, MemberInfo[] memberInfos, MultiMap<PsiElement, String> conflicts) {
        this.myClass = aClass;
        this.myMovedMembers = new HashSet<PsiMember>();
        this.myAbstractMembers = new HashSet<PsiMethod>();
        for (MemberInfo memberInfo : memberInfos) {
            PsiMember member = (PsiMember)memberInfo.getMember();
            if (!memberInfo.isChecked() || memberInfo.getMember() instanceof PsiClass && memberInfo.getOverrides() != null) continue;
            this.myMovedMembers.add(member);
            if (!memberInfo.isToAbstract()) continue;
            this.myAbstractMembers.add((PsiMethod)member);
        }
        this.myConflicts = conflicts;
    }

    public boolean isAnyConflicts() {
        return !this.myConflicts.isEmpty();
    }

    public MultiMap<PsiElement, String> getConflicts() {
        return this.myConflicts;
    }

    public void checkSourceClassConflicts() {
        PsiElement[] children2;
        for (PsiElement child : children2 = this.myClass.getChildren()) {
            if (!(child instanceof PsiMember) || this.myMovedMembers.contains(child)) continue;
            child.accept((PsiElementVisitor)new UsedMovedMembersConflictsCollector(child));
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)this.myClass, (String[])new String[]{"java.lang.FunctionalInterface"});
        if (annotation != null && this.myMovedMembers.contains(LambdaUtil.getFunctionalInterfaceMethod((PsiClass)this.myClass))) {
            this.myConflicts.putValue((Object)annotation, (Object)RefactoringBundle.message((String)"functional.interface.broken"));
        }
    }

    public void checkTargetClassConflicts(PsiElement targetElement, PsiElement context) {
        PsiClass targetClass;
        if (targetElement instanceof PsiFunctionalExpression) {
            this.myConflicts.putValue((Object)targetElement, (Object)RefactoringBundle.message((String)"functional.interface.broken"));
            return;
        }
        PsiClass psiClass = targetClass = targetElement instanceof PsiClass ? (PsiClass)targetElement : null;
        if (targetClass != null) {
            for (PsiMember movedMember : this.myMovedMembers) {
                this.checkMemberPlacementInTargetClassConflict(targetClass, movedMember);
                movedMember.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                        PsiMethod methodBySignature;
                        PsiClass resolvedClass;
                        PsiMethod resolvedMethod;
                        super.visitMethodCallExpression(expression2);
                        if (expression2.getMethodExpression().getQualifierExpression() instanceof PsiSuperExpression && (resolvedMethod = expression2.resolveMethod()) != null && (resolvedClass = resolvedMethod.getContainingClass()) != null && PushDownConflicts.this.myClass.isInheritor(resolvedClass, true) && (methodBySignature = PushDownConflicts.this.myClass.findMethodBySignature(resolvedMethod, false)) != null && !PushDownConflicts.this.myMovedMembers.contains(methodBySignature)) {
                            PushDownConflicts.this.myConflicts.putValue((Object)expression2, (Object)"Super method call will resolve to another method");
                        }
                    }
                });
            }
        }
        block1: for (PsiMember member : this.myMovedMembers) {
            for (PsiReference ref : ReferencesSearch.search((PsiElement)member, (SearchScope)member.getResolveScope(), (boolean)false)) {
                PsiElement resolved;
                PsiReferenceExpression referenceExpression;
                PsiExpression qualifier;
                PsiElement element = ref.getElement();
                if (!(element instanceof PsiReferenceExpression) || (qualifier = (referenceExpression = (PsiReferenceExpression)element).getQualifierExpression()) == null) continue;
                PsiType qualifierType = qualifier.getType();
                PsiClass aClass = null;
                if (qualifierType instanceof PsiClassType) {
                    aClass = ((PsiClassType)qualifierType).resolve();
                } else if (qualifier instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
                    aClass = (PsiClass)resolved;
                }
                if (InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)targetClass, (boolean)true)) continue;
                this.myConflicts.putValue((Object)referenceExpression, (Object)RefactoringBundle.message((String)"pushed.members.will.not.be.visible.from.certain.call.sites"));
                break block1;
            }
        }
        RefactoringConflictsUtil.analyzeAccessibilityConflicts(this.myMovedMembers, targetClass, this.myConflicts, null, context, this.myAbstractMembers);
    }

    public void checkMemberPlacementInTargetClassConflict(PsiClass targetClass, PsiMember movedMember) {
        if (movedMember instanceof PsiField) {
            String name2 = movedMember.getName();
            PsiField field = targetClass.findFieldByName(name2, false);
            if (field != null) {
                String message2 = RefactoringBundle.message((String)"0.already.contains.field.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)targetClass, false), CommonRefactoringUtil.htmlEmphasize((String)name2)});
                this.myConflicts.putValue((Object)field, (Object)CommonRefactoringUtil.capitalize((String)message2));
            }
        } else if (movedMember instanceof PsiMethod) {
            PsiMethod method;
            PsiMethod overrider;
            PsiModifierList modifierList = movedMember.getModifierList();
            assert (modifierList != null);
            if (!modifierList.hasModifierProperty("abstract") && (overrider = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)targetClass, (PsiMethod)(method = (PsiMethod)movedMember), (boolean)false)) != null) {
                String message3 = RefactoringBundle.message((String)"0.is.already.overridden.in.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)method, true), RefactoringUIUtil.getDescription((PsiElement)targetClass, false)});
                this.myConflicts.putValue((Object)overrider, (Object)CommonRefactoringUtil.capitalize((String)message3));
            }
        } else if (movedMember instanceof PsiClass) {
            PsiClass[] allInnerClasses;
            PsiClass aClass = (PsiClass)movedMember;
            String name3 = aClass.getName();
            for (PsiClass innerClass : allInnerClasses = targetClass.getAllInnerClasses()) {
                if (innerClass.equals(movedMember) || !name3.equals(innerClass.getName())) continue;
                String message4 = RefactoringBundle.message((String)"0.already.contains.inner.class.named.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)targetClass, false), CommonRefactoringUtil.htmlEmphasize((String)name3)});
                this.myConflicts.putValue((Object)innerClass, (Object)message4);
            }
        }
    }

    private class UsedMovedMembersConflictsCollector
    extends ClassMemberReferencesVisitor {
        private final PsiElement mySource;

        public UsedMovedMembersConflictsCollector(PsiElement source) {
            super(PushDownConflicts.this.myClass);
            this.mySource = source;
        }

        @Override
        protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
            if (PushDownConflicts.this.myMovedMembers.contains(classMember) && !PushDownConflicts.this.myAbstractMembers.contains(classMember)) {
                String message2 = RefactoringBundle.message((String)"0.uses.1.which.is.pushed.down", (Object[])new Object[]{RefactoringUIUtil.getDescription(this.mySource, false), RefactoringUIUtil.getDescription((PsiElement)classMember, false)});
                message2 = CommonRefactoringUtil.capitalize((String)message2);
                PushDownConflicts.this.myConflicts.putValue((Object)this.mySource, (Object)message2);
            }
        }
    }
}

