/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.openapi.project.Project;
import com.intellij.refactoring.migration.MigrationDialog;
import com.intellij.refactoring.migration.MigrationMap;
import com.intellij.refactoring.migration.MigrationMapSet;
import com.intellij.refactoring.migration.MigrationProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigrationManager {
    private final Project myProject;
    private final MigrationMapSet myMigrationMapSet = new MigrationMapSet();

    public MigrationManager(Project project2) {
        this.myProject = project2;
    }

    public void showMigrationDialog() {
        MigrationDialog migrationDialog = new MigrationDialog(this.myProject, this.myMigrationMapSet);
        if (!migrationDialog.showAndGet()) {
            return;
        }
        MigrationMap migrationMap = migrationDialog.getMigrationMap();
        if (migrationMap == null) {
            return;
        }
        new MigrationProcessor(this.myProject, migrationMap).run();
    }

    @Nullable
    public MigrationMap findMigrationMap(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/refactoring/migration/MigrationManager", "findMigrationMap"));
        }
        return this.myMigrationMapSet.findMigrationMap(name2);
    }
}

