/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.impl.file.JavaDirectoryServiceImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesImpl;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesToNewDirectoryDialog;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesProcessor;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.rename.JavaVetoRenameCondition;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMoveClassesOrPackagesHandler
extends MoveHandlerDelegate {
    private static final Logger LOG = Logger.getInstance(JavaMoveClassesOrPackagesHandler.class);
    private static final JavaVetoRenameCondition VETO_RENAME_CONDITION = new JavaVetoRenameCondition();

    public static boolean isPackageOrDirectory(PsiElement element) {
        if (element instanceof PsiPackage) {
            return true;
        }
        return element instanceof PsiDirectory && JavaDirectoryService.getInstance().getPackage((PsiDirectory)element) != null;
    }

    public static boolean isReferenceInAnonymousClass(@Nullable PsiReference reference) {
        return reference instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)reference).getParent() instanceof PsiAnonymousClass;
    }

    @Override
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        for (PsiElement element : elements) {
            if (JavaMoveClassesOrPackagesHandler.isPackageOrDirectory(element) || !JavaMoveClassesOrPackagesHandler.invalid4Move(element)) continue;
            return false;
        }
        return super.canMove(elements, targetContainer);
    }

    public static boolean invalid4Move(PsiElement element) {
        PsiFile parentFile;
        if (element instanceof PsiClassOwner) {
            PsiClass[] classes2 = ((PsiClassOwner)element).getClasses();
            if (classes2.length == 0) {
                return true;
            }
            for (PsiClass aClass : classes2) {
                if (!(aClass instanceof PsiSyntheticClass)) continue;
                return true;
            }
            parentFile = (PsiFile)element;
        } else {
            if (element instanceof PsiSyntheticClass) {
                return true;
            }
            if (!(element instanceof PsiClass)) {
                return true;
            }
            if (element instanceof PsiAnonymousClass) {
                return true;
            }
            if (((PsiClass)element).getContainingClass() != null) {
                return true;
            }
            parentFile = element.getContainingFile();
        }
        return parentFile instanceof PsiJavaFile && JavaProjectRootsUtil.isOutsideJavaSourceRoot(parentFile);
    }

    @Override
    public boolean isValidTarget(PsiElement psiElement, PsiElement[] sources) {
        if (JavaMoveClassesOrPackagesHandler.isPackageOrDirectory(psiElement)) {
            return true;
        }
        boolean areAllClasses = true;
        for (PsiElement source : sources) {
            areAllClasses &= !JavaMoveClassesOrPackagesHandler.isPackageOrDirectory(source) && !JavaMoveClassesOrPackagesHandler.invalid4Move(source);
        }
        return areAllClasses && psiElement instanceof PsiClass;
    }

    @Override
    public PsiElement[] adjustForMove(Project project2, PsiElement[] sourceElements, PsiElement targetElement) {
        return MoveClassesOrPackagesImpl.adjustForMove(project2, sourceElements, targetElement);
    }

    @Override
    public void doMove(Project project2, PsiElement[] elements, PsiElement targetContainer, MoveCallback callback) {
        PsiElement[] adjustedElements;
        PsiDirectory[] directories = new PsiDirectory[elements.length];
        String prompt = JavaMoveClassesOrPackagesHandler.getPromptToMoveDirectoryLibrariesSafe(elements);
        if (prompt != null) {
            System.arraycopy(elements, 0, directories, 0, directories.length);
            JavaMoveClassesOrPackagesHandler.moveDirectoriesLibrariesSafe(project2, targetContainer, callback, directories, prompt);
            return;
        }
        if (JavaMoveClassesOrPackagesHandler.canMoveOrRearrangePackages(elements)) {
            System.arraycopy(elements, 0, directories, 0, directories.length);
            SelectMoveOrRearrangePackageDialog dialog2 = new SelectMoveOrRearrangePackageDialog(project2, directories, targetContainer == null);
            if (!dialog2.showAndGet()) {
                return;
            }
            if (dialog2.isPackageRearrageSelected()) {
                MoveClassesOrPackagesImpl.doRearrangePackage(project2, directories);
                return;
            }
            if (dialog2.isMoveDirectory()) {
                JavaMoveClassesOrPackagesHandler.moveAsDirectory(project2, targetContainer, callback, directories);
                return;
            }
        }
        if ((adjustedElements = MoveClassesOrPackagesImpl.adjustForMove(project2, elements, targetContainer)) == null) {
            return;
        }
        if (targetContainer instanceof PsiDirectory && CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project2, Arrays.asList(adjustedElements), (boolean)true) && !JavaMoveClassesOrPackagesHandler.packageHasMultipleDirectoriesInModule(project2, (PsiDirectory)targetContainer)) {
            this.createMoveClassesOrPackagesToNewDirectoryDialog((PsiDirectory)targetContainer, adjustedElements, callback).show();
            return;
        }
        this.doMoveWithMoveClassesDialog(project2, adjustedElements, targetContainer, callback);
    }

    protected void doMoveWithMoveClassesDialog(Project project2, PsiElement[] adjustedElements, PsiElement initialTargetElement, MoveCallback moveCallback) {
        MoveClassesOrPackagesImpl.doMove(project2, adjustedElements, initialTargetElement, moveCallback);
    }

    private static void moveDirectoriesLibrariesSafe(Project project2, PsiElement targetContainer, MoveCallback callback, PsiDirectory[] directories, String prompt) {
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directories[0]);
        LOG.assertTrue(aPackage != null);
        PsiDirectory[] projectDirectories = aPackage.getDirectories(GlobalSearchScope.projectScope((Project)project2));
        if (projectDirectories.length > 1) {
            int ret = Messages.showYesNoCancelDialog((Project)project2, (String)(prompt + " or all directories in project?"), (String)RefactoringBundle.message((String)"warning.title"), (String)RefactoringBundle.message((String)"move.current.directory"), (String)RefactoringBundle.message((String)"move.directories"), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
            if (ret == 0) {
                JavaMoveClassesOrPackagesHandler.moveAsDirectory(project2, targetContainer, callback, directories);
            } else if (ret == 1) {
                JavaMoveClassesOrPackagesHandler.moveAsDirectory(project2, targetContainer, callback, projectDirectories);
            }
        } else if (Messages.showOkCancelDialog((Project)project2, (String)(prompt + "?"), (String)RefactoringBundle.message((String)"warning.title"), (Icon)Messages.getWarningIcon()) == 0) {
            JavaMoveClassesOrPackagesHandler.moveAsDirectory(project2, targetContainer, callback, directories);
        }
    }

    @NotNull
    protected DialogWrapper createMoveClassesOrPackagesToNewDirectoryDialog(@NotNull PsiDirectory directory, PsiElement[] elementsToMove, MoveCallback moveCallback) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/refactoring/move/moveClassesOrPackages/JavaMoveClassesOrPackagesHandler", "createMoveClassesOrPackagesToNewDirectoryDialog"));
        }
        MoveClassesOrPackagesToNewDirectoryDialog moveClassesOrPackagesToNewDirectoryDialog = new MoveClassesOrPackagesToNewDirectoryDialog(directory, elementsToMove, moveCallback);
        if (moveClassesOrPackagesToNewDirectoryDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/move/moveClassesOrPackages/JavaMoveClassesOrPackagesHandler", "createMoveClassesOrPackagesToNewDirectoryDialog"));
        }
        return moveClassesOrPackagesToNewDirectoryDialog;
    }

    private static void moveAsDirectory(Project project2, PsiElement targetContainer, final MoveCallback callback, final PsiDirectory[] directories) {
        if (targetContainer instanceof PsiDirectory) {
            JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
            MoveDirectoryWithClassesProcessor processor2 = new MoveDirectoryWithClassesProcessor(project2, directories, (PsiDirectory)targetContainer, refactoringSettings.RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE, refactoringSettings.RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE, true, callback);
            processor2.setPrepareSuccessfulSwingThreadCallback(() -> {});
            processor2.run();
        } else {
            boolean containsJava = JavaMoveClassesOrPackagesHandler.hasJavaFiles(directories[0]);
            if (!containsJava) {
                MoveFilesOrDirectoriesUtil.doMove(project2, (PsiElement[])directories, new PsiElement[]{targetContainer}, callback);
                return;
            }
            MoveClassesOrPackagesToNewDirectoryDialog dlg = new MoveClassesOrPackagesToNewDirectoryDialog(directories[0], PsiElement.EMPTY_ARRAY, false, callback){

                @Override
                protected BaseRefactoringProcessor createRefactoringProcessor(Project project2, final PsiDirectory targetDirectory, PsiPackage aPackage, boolean searchInComments, boolean searchForTextOccurences) {
                    final MoveDestination destination = this.createDestination(aPackage, targetDirectory);
                    try {
                        for (PsiDirectory dir : directories) {
                            MoveFilesOrDirectoriesUtil.checkIfMoveIntoSelf((PsiElement)dir, (PsiElement)WriteAction.compute(() -> destination.getTargetDirectory(dir)));
                        }
                    }
                    catch (IncorrectOperationException e) {
                        Messages.showErrorDialog((Project)project2, (String)e.getMessage(), (String)RefactoringBundle.message((String)"cannot.move"));
                        return null;
                    }
                    return new MoveDirectoryWithClassesProcessor(project2, directories, null, searchInComments, searchForTextOccurences, true, callback){

                        @Override
                        public MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper getTargetDirectory(PsiDirectory dir) {
                            PsiDirectory targetDirectory2 = destination.getTargetDirectory(dir);
                            return new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(targetDirectory2);
                        }

                        @Override
                        protected String getTargetName() {
                            return targetDirectory.getName();
                        }
                    };
                }
            };
            dlg.show();
        }
    }

    public static boolean hasJavaFiles(PsiDirectory directory) {
        final boolean[] containsJava = new boolean[]{false};
        directory.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (containsJava[0]) {
                    return;
                }
                if (element instanceof PsiDirectory) {
                    super.visitElement(element);
                }
            }

            public void visitFile(PsiFile file2) {
                containsJava[0] = file2 instanceof PsiJavaFile;
            }
        });
        return containsJava[0];
    }

    @Override
    public PsiElement adjustTargetForMove(DataContext dataContext, PsiElement targetContainer) {
        PsiDirectory[] directories;
        Module module2;
        if (targetContainer instanceof PsiPackage && (module2 = (Module)LangDataKeys.TARGET_MODULE.getData(dataContext)) != null && (directories = ((PsiPackage)targetContainer).getDirectories(GlobalSearchScope.moduleScope((Module)module2))).length == 1) {
            return directories[0];
        }
        return super.adjustTargetForMove(dataContext, targetContainer);
    }

    public static boolean packageHasMultipleDirectoriesInModule(Project project2, PsiDirectory targetElement) {
        Module module2;
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(targetElement);
        return psiPackage != null && (module2 = ModuleUtilCore.findModuleForFile((VirtualFile)targetElement.getVirtualFile(), (Project)project2)) != null && psiPackage.getDirectories(GlobalSearchScope.moduleScope((Module)module2)).length > 1;
    }

    @Nullable
    private static String getPromptToMoveDirectoryLibrariesSafe(PsiElement[] elements) {
        if (elements.length == 0 || elements.length > 1) {
            return null;
        }
        Project project2 = elements[0].getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        if (!(elements[0] instanceof PsiDirectory)) {
            return null;
        }
        PsiDirectory directory = (PsiDirectory)elements[0];
        if (RefactoringUtil.isSourceRoot(directory)) {
            return null;
        }
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (aPackage == null) {
            return null;
        }
        if ("".equals(aPackage.getQualifiedName())) {
            return null;
        }
        PsiDirectory[] directories = aPackage.getDirectories();
        boolean inLib = false;
        for (PsiDirectory psiDirectory : directories) {
            inLib |= !fileIndex.isInContent(psiDirectory.getVirtualFile());
        }
        return inLib ? "Package '" + aPackage.getName() + "' contains directories in libraries which cannot be moved. Do you want to move current directory" : null;
    }

    private static boolean canMoveOrRearrangePackages(PsiElement[] elements) {
        if (elements.length == 0) {
            return false;
        }
        Project project2 = elements[0].getProject();
        if (JavaProjectRootsUtil.getSuitableDestinationSourceRoots(project2).size() == 1) {
            return false;
        }
        for (PsiElement element : elements) {
            if (!(element instanceof PsiDirectory)) {
                return false;
            }
            PsiDirectory directory = (PsiDirectory)element;
            if (RefactoringUtil.isSourceRoot(directory)) {
                return false;
            }
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage == null) {
                return false;
            }
            if (aPackage.getQualifiedName().isEmpty()) {
                return false;
            }
            VirtualFile sourceRootForFile = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().getSourceRootForFile(directory.getVirtualFile());
            if (sourceRootForFile != null) continue;
            return false;
        }
        return true;
    }

    public static boolean hasPackages(PsiDirectory directory) {
        return JavaDirectoryService.getInstance().getPackage(directory) != null;
    }

    @Override
    public boolean tryToMove(PsiElement element, Project project2, DataContext dataContext, PsiReference reference, Editor editor) {
        if (JavaMoveClassesOrPackagesHandler.isPackageOrDirectory(element)) {
            return false;
        }
        if (JavaMoveClassesOrPackagesHandler.isReferenceInAnonymousClass(reference)) {
            return false;
        }
        if (!JavaMoveClassesOrPackagesHandler.invalid4Move(element)) {
            PsiElement initialTargetElement = (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext);
            PsiElement[] adjustedElements = this.adjustForMove(project2, new PsiElement[]{element}, initialTargetElement);
            if (adjustedElements == null) {
                return true;
            }
            this.doMoveWithMoveClassesDialog(project2, adjustedElements, initialTargetElement, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean isMoveRedundant(PsiElement source, PsiElement target2) {
        PsiPackage aPackage;
        if (target2 instanceof PsiDirectory && source instanceof PsiClass) {
            try {
                JavaDirectoryServiceImpl.checkCreateClassOrInterface((PsiDirectory)target2, ((PsiClass)source).getName());
            }
            catch (IncorrectOperationException e) {
                return true;
            }
        }
        if (target2 instanceof PsiPackage && source instanceof PsiClass) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)source.getProject());
            return ((PsiPackage)target2).findClassByShortName(((PsiClass)source).getName(), globalSearchScope).length > 0;
        }
        if (target2 instanceof PsiDirectory && source instanceof PsiDirectory && (aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)source)) != null && !MoveClassesOrPackagesImpl.checkNesting(target2.getProject(), aPackage, target2, false)) {
            return true;
        }
        return super.isMoveRedundant(source, target2);
    }

    private static class SelectMoveOrRearrangePackageDialog
    extends DialogWrapper {
        private JRadioButton myRbMovePackage;
        private JRadioButton myRbRearrangePackage;
        private JRadioButton myRbMoveDirectory;
        private final PsiDirectory[] myDirectories;
        private final boolean myRearrangePackagesEnabled;

        public SelectMoveOrRearrangePackageDialog(Project project2, PsiDirectory[] directories) {
            this(project2, directories, true);
        }

        public SelectMoveOrRearrangePackageDialog(Project project2, PsiDirectory[] directories, boolean rearrangePackagesEnabled) {
            super(project2, true);
            this.myDirectories = directories;
            this.myRearrangePackagesEnabled = rearrangePackagesEnabled;
            this.setTitle(RefactoringBundle.message((String)"select.refactoring.title"));
            this.init();
        }

        protected JComponent createNorthPanel() {
            return new JLabel(RefactoringBundle.message((String)"what.would.you.like.to.do"));
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myRbMovePackage;
        }

        protected String getDimensionServiceKey() {
            return "#com.intellij.refactoring.move.MoveHandler.SelectRefactoringDialog";
        }

        protected JComponent createCenterPanel() {
            String moveDescription;
            JPanel panel2 = new JPanel(new BorderLayout());
            HashSet packages = new HashSet();
            for (PsiDirectory directory : this.myDirectories) {
                packages.add((Object)JavaDirectoryService.getInstance().getPackage(directory).getQualifiedName());
            }
            LOG.assertTrue(this.myDirectories.length > 0);
            LOG.assertTrue(packages.size() > 0);
            if (packages.size() > 1) {
                moveDescription = RefactoringBundle.message((String)"move.packages.to.another.package", (Object[])new Object[]{packages.size()});
            } else {
                String qName = (String)packages.iterator().next();
                moveDescription = RefactoringBundle.message((String)"move.package.to.another.package", (Object[])new Object[]{qName});
            }
            this.myRbMovePackage = new JRadioButton();
            this.myRbMovePackage.setText(moveDescription);
            this.myRbMovePackage.setSelected(true);
            String rearrangeDescription = this.myDirectories.length > 1 ? RefactoringBundle.message((String)"move.directories.to.another.source.root", (Object[])new Object[]{this.myDirectories.length}) : RefactoringBundle.message((String)"move.directory.to.another.source.root", (Object[])new Object[]{this.myDirectories[0].getVirtualFile().getPresentableUrl()});
            this.myRbRearrangePackage = new JRadioButton();
            this.myRbRearrangePackage.setText(rearrangeDescription);
            this.myRbRearrangePackage.setVisible(this.myRearrangePackagesEnabled);
            String moveDirectoryDescription = this.myDirectories.length > 1 ? "Move everything from " + this.myDirectories.length + " directories to another directory" : "Move everything from " + this.myDirectories[0].getVirtualFile().getPresentableUrl() + " to another directory";
            this.myRbMoveDirectory = new JRadioButton();
            this.myRbMoveDirectory.setMnemonic('e');
            this.myRbMoveDirectory.setText(moveDirectoryDescription);
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.myRbMovePackage);
            gr.add(this.myRbRearrangePackage);
            gr.add(this.myRbMoveDirectory);
            if (this.myRearrangePackagesEnabled) {
                new RadioUpDownListener(this.myRbMovePackage, this.myRbRearrangePackage, this.myRbMoveDirectory);
            } else {
                new RadioUpDownListener(this.myRbMovePackage, this.myRbMoveDirectory);
            }
            Box box = Box.createVerticalBox();
            box.add(Box.createVerticalStrut(5));
            box.add(this.myRbMovePackage);
            box.add(this.myRbRearrangePackage);
            box.add(this.myRbMoveDirectory);
            panel2.add((Component)box, "Center");
            return panel2;
        }

        public boolean isPackageRearrageSelected() {
            return this.myRbRearrangePackage.isSelected();
        }

        public boolean isMoveDirectory() {
            return this.myRbMoveDirectory.isSelected();
        }
    }
}

