/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.projectView.impl.NestingTreeStructureProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesHandler;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveRelatedFilesHandler
extends MoveFilesOrDirectoriesHandler {
    @Override
    public boolean canMove(PsiElement[] elements, PsiElement targetContainer) {
        if (!super.canMove(elements, targetContainer)) {
            return false;
        }
        for (PsiElement element : elements) {
            if (!(element instanceof PsiFile) || ((PsiFile)element).getVirtualFile() == null || NestingTreeStructureProvider.getFilesShownAsChildrenInProjectView(element.getProject(), ((PsiFile)element).getVirtualFile()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public PsiElement[] adjustForMove(@NotNull Project project2, @NotNull PsiElement[] sourceElements, @Nullable PsiElement targetElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/move/moveFilesOrDirectories/MoveRelatedFilesHandler", "adjustForMove"));
        }
        if (sourceElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElements", "com/intellij/refactoring/move/moveFilesOrDirectories/MoveRelatedFilesHandler", "adjustForMove"));
        }
        if ((sourceElements = super.adjustForMove(project2, sourceElements, targetElement)) == null) {
            return null;
        }
        THashSet relatedFilesToMove = new THashSet();
        for (PsiElement element : sourceElements) {
            VirtualFile file2;
            if (!(element instanceof PsiFile) || (file2 = ((PsiFile)element).getVirtualFile()) == null) continue;
            Collection<NestingTreeStructureProvider.ChildFileInfo> relatedFileInfos = NestingTreeStructureProvider.getFilesShownAsChildrenInProjectView(element.getProject(), file2);
            for (NestingTreeStructureProvider.ChildFileInfo info : relatedFileInfos) {
                PsiFile psiFile = element.getManager().findFile(info.file);
                if (psiFile == null || ArrayUtil.contains((Object)psiFile, (Object[])sourceElements)) continue;
                relatedFilesToMove.add(psiFile);
            }
        }
        if (!relatedFilesToMove.isEmpty()) {
            int ok;
            String message2 = relatedFilesToMove.size() == 1 ? RefactoringBundle.message((String)"ask.to.move.related.file", (Object[])new Object[]{((PsiFile)relatedFilesToMove.iterator().next()).getName()}) : RefactoringBundle.message((String)"ask.to.move.related.files", (Object[])new Object[]{StringUtil.join((Collection)relatedFilesToMove, PsiFileSystemItem::getName, (String)", ")});
            int n = ok = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoDialog((Project)project2, (String)message2, (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon());
            if (ok == 0) {
                PsiElement[] result2 = new PsiElement[sourceElements.length + relatedFilesToMove.size()];
                System.arraycopy(sourceElements, 0, result2, 0, sourceElements.length);
                Iterator iterator = relatedFilesToMove.iterator();
                for (int i2 = sourceElements.length; i2 < result2.length; ++i2) {
                    result2[i2] = (PsiElement)iterator.next();
                }
                return result2;
            }
        }
        return sourceElements;
    }
}

