/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.removemiddleman;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.util.ArrayUtil;
import java.util.HashSet;
import java.util.Set;

public class DelegationUtils {
    private DelegationUtils() {
    }

    public static Set<PsiMethod> getDelegatingMethodsForField(PsiField field) {
        PsiMethod[] methods;
        HashSet<PsiMethod> out = new HashSet<PsiMethod>();
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return out;
        }
        for (PsiMethod method : methods = containingClass.getMethods()) {
            if (!DelegationUtils.isDelegation(field, method)) continue;
            out.add(method);
        }
        return out;
    }

    private static boolean isDelegation(PsiField field, PsiMethod method) {
        if (method.isConstructor()) {
            return false;
        }
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null) {
            return false;
        }
        PsiStatement[] statements = body2.getStatements();
        if (statements.length != 1) {
            return false;
        }
        PsiStatement statement2 = statements[0];
        if (statement2 instanceof PsiReturnStatement) {
            PsiExpression returnValue = ((PsiReturnStatement)statement2).getReturnValue();
            if (!DelegationUtils.isDelegationCall(returnValue, field, method)) {
                return false;
            }
        } else if (statement2 instanceof PsiExpressionStatement) {
            PsiExpression value2 = ((PsiExpressionStatement)statement2).getExpression();
            if (!DelegationUtils.isDelegationCall(value2, field, method)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean isAbstract(PsiMethod method) {
        if (method.hasModifierProperty("abstract")) {
            return true;
        }
        return method.getContainingClass().isInterface();
    }

    private static boolean isDelegationCall(PsiExpression expression2, PsiField field, PsiMethod method) {
        PsiExpression[] args;
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiElement referent = ((PsiReference)qualifier).resolve();
        if (referent == null || !referent.equals(field)) {
            return false;
        }
        PsiExpressionList argumentList = call.getArgumentList();
        for (PsiExpression arg : args = argumentList.getExpressions()) {
            if (DelegationUtils.isParameterReference(arg, method)) continue;
            return false;
        }
        return true;
    }

    private static boolean isParameterReference(PsiExpression arg, PsiMethod method) {
        if (!(arg instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiElement referent = ((PsiReference)arg).resolve();
        if (!(referent instanceof PsiParameter)) {
            return false;
        }
        PsiElement declarationScope = ((PsiParameter)referent).getDeclarationScope();
        return method.equals(declarationScope);
    }

    public static int[] getParameterPermutation(PsiMethod method) {
        PsiCodeBlock body2 = method.getBody();
        assert (body2 != null);
        PsiStatement[] statements = body2.getStatements();
        PsiStatement statement2 = statements[0];
        PsiParameterList parameterList = method.getParameterList();
        if (statement2 instanceof PsiReturnStatement) {
            PsiExpression returnValue = ((PsiReturnStatement)statement2).getReturnValue();
            PsiMethodCallExpression call = (PsiMethodCallExpression)returnValue;
            return DelegationUtils.calculatePermutation(call, parameterList);
        }
        PsiExpression value2 = ((PsiExpressionStatement)statement2).getExpression();
        PsiMethodCallExpression call = (PsiMethodCallExpression)value2;
        return DelegationUtils.calculatePermutation(call, parameterList);
    }

    private static int[] calculatePermutation(PsiMethodCallExpression call, PsiParameterList parameterList) {
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] args = argumentList.getExpressions();
        int[] out = ArrayUtil.newIntArray((int)args.length);
        for (int i2 = 0; i2 < args.length; ++i2) {
            PsiExpression arg = args[i2];
            PsiParameter parameter = (PsiParameter)((PsiReference)arg).resolve();
            out[i2] = parameterList.getParameterIndex(parameter);
        }
        return out;
    }

    public static PsiMethod getDelegatedMethod(PsiMethod method) {
        PsiCodeBlock body2 = method.getBody();
        assert (body2 != null);
        PsiStatement[] statements = body2.getStatements();
        PsiStatement statement2 = statements[0];
        if (statement2 instanceof PsiReturnStatement) {
            PsiExpression returnValue = ((PsiReturnStatement)statement2).getReturnValue();
            PsiMethodCallExpression call = (PsiMethodCallExpression)returnValue;
            assert (call != null);
            return call.resolveMethod();
        }
        PsiExpression value2 = ((PsiExpressionStatement)statement2).getExpression();
        PsiMethodCallExpression call = (PsiMethodCallExpression)value2;
        return call.resolveMethod();
    }
}

