/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.removemiddleman;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.removemiddleman.DelegationUtils;
import com.intellij.refactoring.removemiddleman.RemoveMiddlemanUsageViewDescriptor;
import com.intellij.refactoring.removemiddleman.usageInfo.DeleteMethod;
import com.intellij.refactoring.removemiddleman.usageInfo.InlineDelegatingCall;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.FixableUsagesRefactoringProcessor;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RemoveMiddlemanProcessor
extends FixableUsagesRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(RemoveMiddlemanProcessor.class);
    private final PsiField field;
    private final PsiClass containingClass;
    private final List<MemberInfo> myDelegateMethodInfos;
    private PsiMethod getter;

    public RemoveMiddlemanProcessor(PsiField field, List<MemberInfo> memberInfos) {
        super(field.getProject());
        this.field = field;
        this.containingClass = field.getContainingClass();
        String propertyName = PropertyUtil.suggestPropertyName((PsiField)field);
        boolean isStatic = field.hasModifierProperty("static");
        this.getter = PropertyUtil.findPropertyGetter((PsiClass)this.containingClass, (String)propertyName, (boolean)isStatic, (boolean)false);
        this.myDelegateMethodInfos = memberInfos;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/intellij/refactoring/removemiddleman/RemoveMiddlemanProcessor", "createUsageViewDescriptor"));
        }
        RemoveMiddlemanUsageViewDescriptor removeMiddlemanUsageViewDescriptor = new RemoveMiddlemanUsageViewDescriptor(this.field);
        if (removeMiddlemanUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/removemiddleman/RemoveMiddlemanProcessor", "createUsageViewDescriptor"));
        }
        return removeMiddlemanUsageViewDescriptor;
    }

    @Override
    public void findUsages(@NotNull List<FixableUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/removemiddleman/RemoveMiddlemanProcessor", "findUsages"));
        }
        for (MemberInfo memberInfo : this.myDelegateMethodInfos) {
            if (!memberInfo.isChecked()) continue;
            PsiMethod method = (PsiMethod)memberInfo.getMember();
            String getterName = GenerateMembersUtil.suggestGetterName(this.field);
            int[] paramPermutation = DelegationUtils.getParameterPermutation(method);
            PsiMethod delegatedMethod = DelegationUtils.getDelegatedMethod(method);
            LOG.assertTrue(!DelegationUtils.isAbstract(method));
            this.processUsagesForMethod(memberInfo.isToAbstract(), method, paramPermutation, getterName, delegatedMethod, usages);
        }
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/refactoring/removemiddleman/RemoveMiddlemanProcessor", "preprocessUsages"));
        }
        MultiMap conflicts = new MultiMap();
        for (MemberInfo memberInfo : this.myDelegateMethodInfos) {
            PsiMember psiMember;
            if (!memberInfo.isChecked() || !memberInfo.isToAbstract() || !((psiMember = (PsiMember)memberInfo.getMember()) instanceof PsiMethod) || ((PsiMethod)psiMember).findDeepestSuperMethods().length <= 0) continue;
            conflicts.putValue((Object)psiMember, (Object)(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiMember) + " will be deleted. Hierarchy will be broken"));
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, (UsageInfo[])refUsages.get());
    }

    private void processUsagesForMethod(boolean deleteMethodHierarchy, PsiMethod method, int[] paramPermutation, String getterName, PsiMethod delegatedMethod, List<FixableUsageInfo> usages) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)method)) {
            String access;
            PsiElement referenceElement = reference.getElement();
            PsiMethodCallExpression call = (PsiMethodCallExpression)referenceElement.getParent();
            if (call.getMethodExpression().getQualifierExpression() == null) {
                access = this.field.getName();
            } else {
                access = getterName + "()";
                if (this.getter == null) {
                    this.getter = GenerateMembersUtil.generateGetterPrototype(this.field);
                }
            }
            usages.add(new InlineDelegatingCall(call, paramPermutation, access, delegatedMethod.getName()));
        }
        if (deleteMethodHierarchy) {
            usages.add(new DeleteMethod(method));
        }
    }

    @Override
    protected void performRefactoring(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/intellij/refactoring/removemiddleman/RemoveMiddlemanProcessor", "performRefactoring"));
        }
        if (this.getter != null) {
            try {
                if (this.containingClass.findMethodBySignature(this.getter, false) == null) {
                    this.containingClass.add((PsiElement)this.getter);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        super.performRefactoring(usageInfos);
    }

    @Override
    protected String getCommandName() {
        return RefactorJBundle.message("exposed.delegation.command.name", this.containingClass.getName(), Character.valueOf('.'), this.field.getName());
    }
}

