/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameXmlAttributeProcessor
extends RenamePsiElementProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.RenameXmlAttributeProcessor");

    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RenameXmlAttributeProcessor", "canProcessElement"));
        }
        return element instanceof XmlAttribute || element instanceof XmlAttributeValue;
    }

    @Override
    public void renameElement(PsiElement element, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        if (element instanceof XmlAttribute) {
            RenameXmlAttributeProcessor.doRenameXmlAttribute((XmlAttribute)element, newName, listener2);
        } else if (element instanceof XmlAttributeValue) {
            RenameXmlAttributeProcessor.doRenameXmlAttributeValue((XmlAttributeValue)element, newName, usages, listener2);
        }
    }

    private static void doRenameXmlAttribute(XmlAttribute attribute, String newName, @Nullable RefactoringElementListener listener2) {
        try {
            PsiElement element = attribute.setName(newName);
            if (listener2 != null) {
                listener2.elementRenamed(element);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void doRenameXmlAttributeValue(@NotNull XmlAttributeValue value2, String newName, UsageInfo[] infos, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/refactoring/rename/RenameXmlAttributeProcessor", "doRenameXmlAttributeValue"));
        }
        LOG.assertTrue(value2.isValid());
        RenameXmlAttributeProcessor.renameAll((PsiElement)value2, infos, newName, value2.getValue());
        PsiManager psiManager = value2.getManager();
        LOG.assertTrue(psiManager != null);
        XmlFile file2 = (XmlFile)PsiFileFactory.getInstance((Project)psiManager.getProject()).createFileFromText("dummy.xml", (Language)XMLLanguage.INSTANCE, (CharSequence)("<a attr=\"" + newName + "\"/>"));
        PsiElement element = value2.replace((PsiElement)file2.getRootTag().getAttributes()[0].getValueElement());
        if (listener2 != null) {
            listener2.elementRenamed(element);
        }
    }

    private static void renameAll(PsiElement originalElement, UsageInfo[] infos, String newName, String originalName) throws IncorrectOperationException {
        if (newName.equals(originalName)) {
            return;
        }
        Queue queue = new Queue(infos.length);
        for (UsageInfo info : infos) {
            PsiReference ref;
            if (info.getElement() == null || (ref = info.getReference()) == null) continue;
            queue.addLast((Object)ref);
        }
        while (!queue.isEmpty()) {
            PsiReference reference = (PsiReference)queue.pullFirst();
            PsiElement oldElement = reference.getElement();
            if (!oldElement.isValid() || oldElement == originalElement) continue;
            PsiElement newElement = reference.handleElementRename(newName);
            if (oldElement.isValid()) continue;
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)originalElement, (SearchScope)new LocalSearchScope(newElement), (boolean)false)) {
                queue.addLast((Object)psiReference);
            }
        }
    }
}

