/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.util.containers.hash.HashSet;
import org.jetbrains.annotations.NonNls;

public class ConstructorParameterOnFieldRenameRenamer
extends AutomaticRenamer {
    @Override
    @NonNls
    protected String canonicalNameToName(@NonNls String canonicalName, PsiNamedElement element) {
        return JavaCodeStyleManager.getInstance((Project)element.getProject()).propertyNameToVariableName(canonicalName, VariableKind.PARAMETER);
    }

    @Override
    protected String nameToCanonicalName(@NonNls String name2, PsiNamedElement element) {
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)element.getProject());
        VariableKind variableKind = element instanceof PsiVariable ? javaCodeStyleManager.getVariableKind((PsiVariable)element) : VariableKind.FIELD;
        return javaCodeStyleManager.variableNameToPropertyName(name2, variableKind);
    }

    public ConstructorParameterOnFieldRenameRenamer(PsiField aField, String newFieldName) {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)aField.getProject());
        String propertyName = styleManager.variableNameToPropertyName(aField.getName(), VariableKind.FIELD);
        if (!Comparing.strEqual((String)propertyName, (String)styleManager.variableNameToPropertyName(newFieldName, VariableKind.FIELD))) {
            String paramName = styleManager.propertyNameToVariableName(propertyName, VariableKind.PARAMETER);
            PsiClass aClass = aField.getContainingClass();
            if (aClass == null) {
                return;
            }
            HashSet toRename = new HashSet();
            for (PsiMethod constructor : aClass.getConstructors()) {
                PsiParameter[] parameters2;
                if (constructor instanceof PsiMirrorElement) {
                    PsiElement prototype = ((PsiMirrorElement)constructor).getPrototype();
                    if (!(prototype instanceof PsiMethod) || !((PsiMethod)prototype).isConstructor()) continue;
                    constructor = (PsiMethod)prototype;
                }
                if (constructor instanceof LightElement) continue;
                for (PsiParameter parameter : parameters2 = constructor.getParameterList().getParameters()) {
                    String parameterName = parameter.getName();
                    if (!paramName.equals(parameterName) && !propertyName.equals(styleManager.variableNameToPropertyName(parameterName, VariableKind.PARAMETER))) continue;
                    toRename.add(parameter);
                }
            }
            this.myElements.addAll(toRename);
            this.suggestAllNames(aField.getName(), newFieldName);
        }
    }

    @Override
    public String getDialogTitle() {
        return RefactoringBundle.message((String)"rename.constructor.parameters.title");
    }

    @Override
    public String getDialogDescription() {
        return RefactoringBundle.message((String)"rename.constructor.parameters.with.the.following.names.to");
    }

    @Override
    public String entityName() {
        return RefactoringBundle.message((String)"entity.name.constructor.parameter");
    }
}

