/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.replaceConstructorWithBuilder;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.replaceConstructorWithBuilder.ReplaceConstructorWithBuilderDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceConstructorWithBuilderHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/replaceConstructorWithBuilder/ReplaceConstructorWithBuilderHandler", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file2.findElementAt(offset);
        PsiClass psiClass = ReplaceConstructorWithBuilderHandler.getParentNamedClass(element);
        if (psiClass == null) {
            ReplaceConstructorWithBuilderHandler.showErrorMessage("The caret should be positioned inside a class which constructors are to be replaced with builder.", project2, editor);
            return;
        }
        PsiMethod[] constructors = psiClass.getConstructors();
        if (constructors.length == 0) {
            ReplaceConstructorWithBuilderHandler.showErrorMessage("Current class doesn't have constructors to replace with builder.", project2, editor);
            return;
        }
        new ReplaceConstructorWithBuilderDialog(project2, constructors).show();
    }

    @Nullable
    public static PsiClass getParentNamedClass(PsiElement element) {
        PsiElement resolve2;
        PsiElement parent;
        if (element != null && (parent = element.getParent()) instanceof PsiJavaCodeReferenceElement && (resolve2 = ((PsiJavaCodeReferenceElement)parent).resolve()) instanceof PsiClass) {
            return (PsiClass)resolve2;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (psiClass instanceof PsiAnonymousClass) {
            return ReplaceConstructorWithBuilderHandler.getParentNamedClass((PsiElement)psiClass);
        }
        return psiClass;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/replaceConstructorWithBuilder/ReplaceConstructorWithBuilderHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/replaceConstructorWithBuilder/ReplaceConstructorWithBuilderHandler", "invoke"));
        }
        throw new UnsupportedOperationException();
    }

    private static void showErrorMessage(String message2, Project project2, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message2, (String)"Replace Constructor with Builder", (String)"refactoring.replaceConstructorWithBuilder");
    }
}

