/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeCook.deductive.builder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVariable;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeCook.Settings;
import com.intellij.refactoring.typeCook.Util;
import com.intellij.refactoring.typeCook.deductive.PsiTypeVariableFactory;
import com.intellij.refactoring.typeCook.deductive.builder.ReductionSystem;
import com.intellij.refactoring.typeCook.deductive.util.VictimCollector;
import com.intellij.util.containers.HashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SystemBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.typeCook.deductive.builder.SystemBuilder");
    private final PsiManager myManager;
    private final Map<PsiElement, Boolean> myMethodCache;
    private final Map<PsiParameter, PsiParameter> myParameters;
    private final Map<PsiMethod, PsiMethod> myMethods;
    private final Map<PsiElement, PsiType> myTypes;
    private final Set<PsiAnchor> myVisitedConstructions;
    private final Settings mySettings;
    private final PsiTypeVariableFactory myTypeVariableFactory;
    private final Project myProject;

    public SystemBuilder(Project project2, Settings settings) {
        this.myProject = project2;
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.mySettings = settings;
        this.myMethodCache = new HashMap();
        this.myParameters = new HashMap();
        this.myMethods = new HashMap();
        this.myTypes = new HashMap();
        this.myVisitedConstructions = new HashSet<PsiAnchor>();
        this.myTypeVariableFactory = new PsiTypeVariableFactory();
    }

    private Set<PsiElement> collect(PsiElement[] scopes) {
        return new VictimCollector(scopes, this.mySettings).getVictims();
    }

    private boolean verifyMethod(PsiElement element, Set<PsiElement> victims, PsiSearchHelper helper) {
        PsiMethod e;
        PsiMethod[] overriders;
        PsiMethod keyMethod;
        Boolean good;
        PsiMethod method;
        PsiParameter parameter = null;
        int index = 0;
        if (element instanceof PsiMethod) {
            method = (PsiMethod)element;
        } else if (element instanceof PsiParameter) {
            parameter = (PsiParameter)element;
            method = (PsiMethod)parameter.getDeclarationScope();
            index = method.getParameterList().getParameterIndex(parameter);
        } else {
            LOG.error("Parameter or method expected, but found " + (element == null ? "null" : element.getClass().getName()));
            return false;
        }
        PsiMethod superMethod = method.findDeepestSuperMethod();
        PsiParameter keyParameter = null;
        if (superMethod != null) {
            PsiMethod e2;
            good = this.myMethodCache.get(superMethod);
            if (good != null && !good.booleanValue()) {
                return false;
            }
            Object object = e2 = parameter == null ? superMethod : superMethod.getParameterList().getParameters()[index];
            if (!victims.contains(e2)) {
                this.myMethodCache.put((PsiElement)superMethod, Boolean.FALSE);
                return false;
            }
            keyMethod = superMethod;
            this.myMethods.put(method, keyMethod);
            if (parameter != null) {
                keyParameter = (PsiParameter)e2;
            }
        } else {
            good = this.myMethodCache.get(method);
            if (good != null && good.booleanValue()) {
                this.myMethods.putIfAbsent(method, method);
                if (parameter != null && this.myParameters.get(parameter) == null) {
                    this.myParameters.put(parameter, parameter);
                }
                return true;
            }
            keyMethod = method;
            keyParameter = parameter;
        }
        for (PsiMethod overrider : overriders = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)keyMethod).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
            Object object = e = parameter != null ? overrider.getParameterList().getParameters()[index] : overrider;
            if (victims.contains(e)) continue;
            this.myMethodCache.put((PsiElement)keyMethod, Boolean.FALSE);
            return false;
        }
        for (PsiMethod overrider : overriders) {
            e = parameter != null ? overrider.getParameterList().getParameters()[index] : overrider;
            this.myMethods.put(overrider, keyMethod);
            if (parameter == null) continue;
            this.myParameters.put((PsiParameter)e, keyParameter);
        }
        this.myMethods.put(method, keyMethod);
        if (parameter != null) {
            this.myParameters.put(parameter, keyParameter);
        }
        this.myMethodCache.put((PsiElement)keyMethod, Boolean.TRUE);
        return true;
    }

    private void setType(PsiElement e, PsiType t) {
        this.myTypes.put(e, t);
    }

    private PsiType defineType(PsiElement e) {
        PsiType t = this.myTypes.get(e);
        if (t != null) {
            return t;
        }
        t = Util.getType(e);
        PsiType parameterizedType = Util.createParameterizedType(t, this.myTypeVariableFactory, e);
        this.myTypes.put(e, parameterizedType);
        return parameterizedType;
    }

    private PsiType getType(PsiElement e) {
        PsiType t = this.myTypes.get(e);
        if (t != null) {
            return t;
        }
        return Util.banalize(Util.getType(e));
    }

    private boolean isCooked(PsiElement element) {
        return this.myTypes.get(element) != null;
    }

    public PsiType inferTypeForMethodTypeParameter(PsiTypeParameter typeParameter, PsiParameter[] parameters2, PsiExpression[] arguments, PsiSubstitutor partialSubstitutor, PsiElement parent, ReductionSystem system) {
        PsiPrimitiveType substitution = PsiType.NULL;
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)typeParameter.getProject()).getResolveHelper();
        if (parameters2.length > 0) {
            for (int j = 0; j < arguments.length; ++j) {
                PsiType currentSubstitution;
                PsiExpression argument = arguments[j];
                PsiParameter parameter = parameters2[Math.min(j, parameters2.length - 1)];
                if (j >= parameters2.length && !parameter.isVarArgs()) break;
                PsiType parameterType = parameter.getType();
                PsiType argumentType = this.evaluateType(argument, system);
                if (parameterType instanceof PsiEllipsisType) {
                    parameterType = ((PsiEllipsisType)parameterType).getComponentType();
                    if (arguments.length == parameters2.length && argumentType instanceof PsiArrayType && !(((PsiArrayType)argumentType).getComponentType() instanceof PsiPrimitiveType)) {
                        argumentType = ((PsiArrayType)argumentType).getComponentType();
                    }
                }
                if ((currentSubstitution = helper.getSubstitutionForTypeParameter(typeParameter, parameterType, argumentType, true, PsiUtil.getLanguageLevel((PsiElement)parent))) == null) {
                    substitution = null;
                    break;
                }
                if (currentSubstitution instanceof PsiWildcardType) {
                    if (substitution instanceof PsiWildcardType) {
                        return PsiType.NULL;
                    }
                } else if (PsiType.NULL.equals((Object)currentSubstitution)) continue;
                if (PsiType.NULL.equals((Object)substitution)) {
                    substitution = currentSubstitution;
                    continue;
                }
                if (!substitution.equals(currentSubstitution) && (substitution instanceof PsiTypeVariable || currentSubstitution instanceof PsiTypeVariable) && (substitution = GenericsUtil.getLeastUpperBound((PsiType)substitution, (PsiType)currentSubstitution, (PsiManager)typeParameter.getManager())) == null) break;
            }
        }
        if (PsiType.NULL.equals((Object)substitution)) {
            substitution = this.inferMethodTypeParameterFromParent(typeParameter, partialSubstitutor, parent, system);
        }
        return substitution;
    }

    private PsiType inferMethodTypeParameterFromParent(PsiTypeParameter typeParameter, PsiSubstitutor substitutor, PsiElement parent, ReductionSystem system) {
        PsiTypeParameterListOwner owner2 = typeParameter.getOwner();
        PsiPrimitiveType substitution = PsiType.NULL;
        if (owner2 instanceof PsiMethod && parent instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent;
            substitution = this.inferMethodTypeParameterFromParent(methodCall.getParent(), methodCall, typeParameter, substitutor, system);
        }
        return substitution;
    }

    private PsiType inferMethodTypeParameterFromParent(PsiElement parent, PsiMethodCallExpression methodCall, PsiTypeParameter typeParameter, PsiSubstitutor substitutor, ReductionSystem system) {
        PsiMethod method;
        PsiType type2 = null;
        if (parent instanceof PsiVariable && methodCall.equals(((PsiVariable)parent).getInitializer())) {
            type2 = this.getType(parent);
        } else if (parent instanceof PsiAssignmentExpression && methodCall.equals(((PsiAssignmentExpression)parent).getRExpression())) {
            type2 = this.evaluateType(((PsiAssignmentExpression)parent).getLExpression(), system);
        } else if (parent instanceof PsiTypeCastExpression && methodCall.equals(((PsiTypeCastExpression)parent).getOperand())) {
            type2 = this.evaluateType((PsiExpression)parent, system);
        } else if (parent instanceof PsiReturnStatement && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class)) != null) {
            type2 = this.getType((PsiElement)method);
        }
        if (type2 == null) {
            type2 = PsiType.getJavaLangObject((PsiManager)methodCall.getManager(), (GlobalSearchScope)methodCall.getResolveScope());
        }
        PsiType returnType = ((PsiMethod)typeParameter.getOwner()).getReturnType();
        PsiType guess = JavaPsiFacade.getInstance((Project)parent.getProject()).getResolveHelper().getSubstitutionForTypeParameter(typeParameter, returnType, type2, false, PsiUtil.getLanguageLevel((PsiElement)parent));
        if (PsiType.NULL.equals((Object)guess)) {
            PsiType superType = substitutor.substitute((PsiType)typeParameter.getSuperTypes()[0]);
            return superType == null ? PsiType.getJavaLangObject((PsiManager)methodCall.getManager(), (GlobalSearchScope)methodCall.getResolveScope()) : superType;
        }
        if (returnType instanceof PsiClassType && typeParameter.equals(((PsiClassType)returnType).resolve())) {
            PsiClassType[] extendsTypes = typeParameter.getExtendsListTypes();
            PsiSubstitutor newSubstitutor = substitutor.put(typeParameter, guess);
            for (PsiClassType t : extendsTypes) {
                PsiType extendsType = newSubstitutor.substitute((PsiType)t);
                if (extendsType.isAssignableFrom(guess)) continue;
                if (!guess.isAssignableFrom(extendsType)) break;
                guess = extendsType;
                newSubstitutor = substitutor.put(typeParameter, guess);
            }
        }
        return guess;
    }

    PsiType evaluateType(PsiExpression expr, ReductionSystem system) {
        if (expr instanceof PsiArrayAccessExpression && !this.mySettings.preserveRawArrays()) {
            PsiType at = this.evaluateType(((PsiArrayAccessExpression)expr).getArrayExpression(), system);
            if (at instanceof PsiArrayType) {
                return ((PsiArrayType)at).getComponentType();
            }
        } else {
            if (expr instanceof PsiAssignmentExpression) {
                return this.evaluateType(((PsiAssignmentExpression)expr).getLExpression(), system);
            }
            if (expr instanceof PsiCallExpression) {
                PsiCallExpression call = (PsiCallExpression)expr;
                PsiMethod method = call.resolveMethod();
                if (method != null) {
                    PsiClass qualifierClass;
                    PsiType qualifierType;
                    PsiClassType.ClassResolveResult result2;
                    PsiType aType;
                    PsiClass aClass = method.getContainingClass();
                    PsiTypeParameter[] methodTypeParameters = method.getTypeParameters();
                    PsiParameter[] parameters2 = method.getParameterList().getParameters();
                    PsiExpression[] arguments = call.getArgumentList().getExpressions();
                    PsiExpression qualifier = expr instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expr).getMethodExpression().getQualifierExpression() : null;
                    HashSet<PsiTypeParameter> typeParameters = new HashSet<PsiTypeParameter>(Arrays.asList(methodTypeParameters));
                    PsiSubstitutor qualifierSubstitutor = PsiSubstitutor.EMPTY;
                    PsiSubstitutor supertypeSubstitutor = PsiSubstitutor.EMPTY;
                    if (method.isConstructor()) {
                        if (expr instanceof PsiNewExpression) {
                            aType = this.isCooked((PsiElement)expr) ? this.getType((PsiElement)expr) : expr.getType();
                            qualifierSubstitutor = Util.resolveType(aType).getSubstitutor();
                        } else {
                            LOG.assertTrue(expr instanceof PsiMethodCallExpression);
                            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)expr).getMethodExpression();
                            if ("this".equals(methodExpression.getText())) {
                                aType = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory().createType(aClass);
                            } else {
                                LOG.assertTrue("super".equals(methodExpression.getText()));
                                PsiClass placeClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiClass.class);
                                qualifierSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)aClass, (PsiClass)placeClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                                aType = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getElementFactory().createType(aClass, qualifierSubstitutor);
                            }
                        }
                    } else {
                        aType = this.getType((PsiElement)method);
                    }
                    if (qualifier != null && (result2 = Util.resolveType(qualifierType = this.evaluateType(qualifier, system))).getElement() != null && (qualifierSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)aClass, (PsiClass)(qualifierClass = result2.getElement()), (PsiSubstitutor)result2.getSubstitutor())) != null) {
                        aType = qualifierSubstitutor.substitute(aType);
                    }
                    HashMap mapping = new HashMap();
                    for (int i2 = 0; i2 < Math.min(parameters2.length, arguments.length); ++i2) {
                        PsiType parmType;
                        PsiType argumentType = this.evaluateType(arguments[i2], system);
                        if (this.isCooked((PsiElement)parameters2[i2])) {
                            parmType = this.getType((PsiElement)parameters2[i2]);
                            system.addSubtypeConstraint(argumentType, parmType);
                            continue;
                        }
                        parmType = parameters2[i2].getType();
                        if (qualifierSubstitutor != null) {
                            parmType = qualifierSubstitutor.substitute(parmType);
                        }
                        if (!Util.bindsTypeVariables(parmType) && !Util.bindsTypeParameters(parmType, typeParameters)) {
                            parmType = Util.banalize(parmType);
                        }
                        PsiType theType = new Object((Map)mapping, system, typeParameters, methodTypeParameters){
                            final /* synthetic */ Map val$mapping;
                            final /* synthetic */ ReductionSystem val$system;
                            final /* synthetic */ Set val$typeParameters;
                            final /* synthetic */ PsiTypeParameter[] val$methodTypeParameters;
                            {
                                this.val$mapping = map2;
                                this.val$system = reductionSystem;
                                this.val$typeParameters = set2;
                                this.val$methodTypeParameters = psiTypeParameterArray;
                            }

                            PsiType introduceAdditionalTypeVariables(PsiType type2, PsiSubstitutor qualifier, PsiSubstitutor supertype) {
                                int level = type2.getArrayDimensions();
                                PsiClassType.ClassResolveResult result2 = Util.resolveType(type2);
                                PsiClass aClass = result2.getElement();
                                if (aClass != null) {
                                    if (aClass instanceof PsiTypeParameter) {
                                        PsiTypeParameter tp = (PsiTypeParameter)aClass;
                                        PsiClassType[] extypes = tp.getExtendsListTypes();
                                        PsiType pv = (PsiType)this.val$mapping.get(tp);
                                        if (pv == null) {
                                            pv = SystemBuilder.this.myTypeVariableFactory.create();
                                            this.val$mapping.put(tp, pv);
                                        }
                                        for (PsiClassType ext : extypes) {
                                            PsiType extype = qualifier.substitute(new Object(){

                                                public PsiType substitute(PsiType ext) {
                                                    PsiClassType.ClassResolveResult result2 = Util.resolveType(ext);
                                                    PsiClass aClass = result2.getElement();
                                                    if (aClass != null) {
                                                        if (aClass instanceof PsiTypeParameter) {
                                                            PsiType type2 = (PsiType)val$mapping.get(aClass);
                                                            if (type2 != null) {
                                                                return type2;
                                                            }
                                                            return ext;
                                                        }
                                                        PsiSubstitutor aSubst = result2.getSubstitutor();
                                                        PsiSubstitutor theSubst = PsiSubstitutor.EMPTY;
                                                        for (PsiTypeParameter parm : aSubst.getSubstitutionMap().keySet()) {
                                                            PsiType type3 = aSubst.substitute(parm);
                                                            if (type3 != null) {
                                                                if (type3 instanceof PsiWildcardType) {
                                                                    PsiWildcardType wildcard = (PsiWildcardType)type3;
                                                                    PsiType bound = wildcard.getBound();
                                                                    if (bound != null) {
                                                                        PsiManager manager = parm.getManager();
                                                                        type3 = wildcard.isExtends() ? PsiWildcardType.createExtends((PsiManager)manager, (PsiType)this.substitute(bound)) : PsiWildcardType.createSuper((PsiManager)manager, (PsiType)this.substitute(bound));
                                                                    }
                                                                } else {
                                                                    type3 = this.substitute(type3);
                                                                }
                                                            }
                                                            theSubst = theSubst.put(parm, type3);
                                                        }
                                                        return JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(aClass, theSubst);
                                                    }
                                                    return ext;
                                                }
                                            }.substitute((PsiType)ext));
                                            this.val$system.addSubtypeConstraint(pv, extype);
                                        }
                                        return Util.createArrayType(pv, level);
                                    }
                                    Map substitutionMap = result2.getSubstitutor().getSubstitutionMap();
                                    PsiSubstitutor theSubst = PsiSubstitutor.EMPTY;
                                    for (PsiTypeParameter p : substitutionMap.keySet()) {
                                        PsiType pType = (PsiType)substitutionMap.get(p);
                                        if (pType instanceof PsiWildcardType) {
                                            PsiWildcardType wildcard = (PsiWildcardType)pType;
                                            PsiType theBound = wildcard.getBound();
                                            if (theBound != null) {
                                                PsiTypeVariable var;
                                                PsiType bound = qualifier.substitute(supertype.substitute(theBound));
                                                if (Util.bindsTypeVariables(bound)) {
                                                    var = SystemBuilder.this.myTypeVariableFactory.create();
                                                    if (wildcard.isExtends()) {
                                                        this.val$system.addSubtypeConstraint(var, bound);
                                                    } else {
                                                        this.val$system.addSubtypeConstraint(bound, var);
                                                    }
                                                    theSubst = theSubst.put(p, (PsiType)var);
                                                    continue;
                                                }
                                                if (Util.bindsTypeParameters(bound, this.val$typeParameters)) {
                                                    var = SystemBuilder.this.myTypeVariableFactory.create();
                                                    PsiSubstitutor subst = PsiSubstitutor.EMPTY;
                                                    for (PsiTypeParameter aTypeParm : this.val$methodTypeParameters) {
                                                        PsiType parmVar = (PsiType)this.val$mapping.get(aTypeParm);
                                                        if (parmVar == null) {
                                                            parmVar = SystemBuilder.this.myTypeVariableFactory.create();
                                                            this.val$mapping.put(aTypeParm, parmVar);
                                                        }
                                                        subst = subst.put(aTypeParm, parmVar);
                                                    }
                                                    PsiType bnd = subst.substitute(bound);
                                                    if (wildcard.isExtends()) {
                                                        this.val$system.addSubtypeConstraint(bnd, var);
                                                    } else {
                                                        this.val$system.addSubtypeConstraint(var, bnd);
                                                    }
                                                    theSubst = theSubst.put(p, (PsiType)var);
                                                    continue;
                                                }
                                                theSubst = theSubst.put(p, pType);
                                                continue;
                                            }
                                            theSubst = theSubst.put(p, pType);
                                            continue;
                                        }
                                        if (pType == null) continue;
                                        theSubst = theSubst.put(p, this.introduceAdditionalTypeVariables(pType, qualifier, supertype));
                                    }
                                    return Util.createArrayType((PsiType)JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(aClass, theSubst), level);
                                }
                                return Util.createArrayType(type2, level);
                            }
                        }.introduceAdditionalTypeVariables(parmType, qualifierSubstitutor, supertypeSubstitutor);
                        system.addSubtypeConstraint(argumentType, theType);
                    }
                    PsiSubstitutor theSubst = PsiSubstitutor.EMPTY;
                    for (PsiTypeParameter parm : mapping.keySet()) {
                        PsiType type2 = (PsiType)mapping.get(parm);
                        theSubst = theSubst.put(parm, type2);
                    }
                    for (PsiTypeParameter typeParam : methodTypeParameters) {
                        PsiType inferred = this.inferTypeForMethodTypeParameter(typeParam, parameters2, arguments, theSubst, (PsiElement)expr, system);
                        theSubst = theSubst.put(typeParam, inferred);
                    }
                    return theSubst.substitute(aType);
                }
            } else {
                if (expr instanceof PsiParenthesizedExpression) {
                    return this.evaluateType(((PsiParenthesizedExpression)expr).getExpression(), system);
                }
                if (expr instanceof PsiConditionalExpression) {
                    return this.evaluateType(((PsiConditionalExpression)expr).getThenExpression(), system);
                }
                if (expr instanceof PsiReferenceExpression) {
                    PsiReferenceExpression ref = (PsiReferenceExpression)expr;
                    PsiExpression qualifier = ref.getQualifierExpression();
                    if (qualifier == null) {
                        return this.getType(ref.resolve());
                    }
                    PsiType qualifierType = this.evaluateType(qualifier, system);
                    PsiElement element = ref.resolve();
                    PsiClassType.ClassResolveResult result3 = Util.resolveType(qualifierType);
                    if (result3.getElement() != null) {
                        PsiClass aClass = result3.getElement();
                        PsiSubstitutor aSubst = result3.getSubstitutor();
                        if (element instanceof PsiField) {
                            PsiField field = (PsiField)element;
                            PsiType fieldType = this.getType((PsiElement)field);
                            PsiClass superClass = field.getContainingClass();
                            PsiType aType = fieldType;
                            if (!aClass.equals(superClass) && field.isPhysical()) {
                                aType = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY).substitute(aType);
                            }
                            return aSubst.substitute(aType);
                        }
                    } else if (element != null) {
                        return this.getType(element);
                    }
                }
            }
        }
        return this.getType((PsiElement)expr);
    }

    private void addUsage(final ReductionSystem system, PsiElement element) {
        PsiAnchor anchor;
        if (element instanceof PsiVariable) {
            PsiExpression initializer = ((PsiVariable)element).getInitializer();
            if (initializer != null) {
                PsiExpression core = PsiUtil.deparenthesizeExpression((PsiExpression)initializer);
                if (core instanceof PsiArrayInitializerExpression) {
                    PsiExpression[] inits = ((PsiArrayInitializerExpression)core).getInitializers();
                    PsiType type2 = this.getType(element);
                    for (PsiExpression init : inits) {
                        system.addSubtypeConstraint((PsiType)this.evaluateType(init, system).createArrayType(), type2);
                    }
                } else if (core instanceof PsiNewExpression) {
                    PsiArrayInitializerExpression init = ((PsiNewExpression)core).getArrayInitializer();
                    if (init != null) {
                        PsiExpression[] inits = init.getInitializers();
                        PsiType type3 = this.getType(element);
                        for (PsiExpression init1 : inits) {
                            system.addSubtypeConstraint((PsiType)this.evaluateType(init1, system).createArrayType(), type3);
                        }
                    }
                    system.addSubtypeConstraint(this.evaluateType(core, system), this.getType(element));
                } else {
                    system.addSubtypeConstraint(this.evaluateType(core, system), this.getType(element));
                }
            }
            if (element instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)element;
                PsiElement declarationScope = parameter.getDeclarationScope();
                if (declarationScope instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)declarationScope;
                    PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)this.myManager.getProject());
                    SearchScope scope = SystemBuilder.getScope(helper, (PsiElement)method);
                    for (PsiReference ref : ReferencesSearch.search((PsiElement)method, (SearchScope)scope, (boolean)true)) {
                        PsiExpressionList argList;
                        PsiCallExpression call;
                        PsiElement elt = ref.getElement();
                        if (elt == null || (call = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)elt, PsiCallExpression.class)) == null || (argList = call.getArgumentList()) == null) continue;
                        PsiExpression[] args = argList.getExpressions();
                        int index = method.getParameterList().getParameterIndex(parameter);
                        if (index >= args.length) continue;
                        system.addSubtypeConstraint(this.evaluateType(args[index], system), this.myTypes.get(element));
                    }
                } else if (declarationScope instanceof PsiForeachStatement) {
                    this.addForEachConstraint(system, (PsiForeachStatement)declarationScope);
                }
            }
            return;
        }
        if (element instanceof PsiMethod) {
            final PsiType reType = this.getType(element);
            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReturnStatement(PsiReturnStatement statement2) {
                    super.visitReturnStatement(statement2);
                    PsiExpression retExpr = statement2.getReturnValue();
                    if (retExpr != null) {
                        system.addSubtypeConstraint(SystemBuilder.this.evaluateType(retExpr, system), reType);
                    }
                }

                public void visitClass(PsiClass aClass) {
                }

                public void visitLambdaExpression(PsiLambdaExpression expression2) {
                }
            });
            return;
        }
        PsiElement root = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiStatement.class, PsiField.class});
        if (root != null && !this.myVisitedConstructions.contains(anchor = PsiAnchor.create(root))) {
            root.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
                    super.visitAssignmentExpression(expression2);
                    system.addSubtypeConstraint(SystemBuilder.this.evaluateType(expression2.getRExpression(), system), SystemBuilder.this.evaluateType(expression2.getLExpression(), system));
                }

                public void visitConditionalExpression(PsiConditionalExpression expression2) {
                    super.visitConditionalExpression(expression2);
                    system.addSubtypeConstraint(SystemBuilder.this.evaluateType(expression2.getThenExpression(), system), SystemBuilder.this.evaluateType(expression2.getElseExpression(), system));
                    system.addSubtypeConstraint(SystemBuilder.this.evaluateType(expression2.getElseExpression(), system), SystemBuilder.this.evaluateType(expression2.getThenExpression(), system));
                }

                public void visitCallExpression(PsiCallExpression expression2) {
                    super.visitCallExpression(expression2);
                    SystemBuilder.this.evaluateType((PsiExpression)expression2, system);
                }

                public void visitReturnStatement(PsiReturnStatement statement2) {
                    super.visitReturnStatement(statement2);
                    PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
                    if (method != null) {
                        system.addSubtypeConstraint(SystemBuilder.this.evaluateType(statement2.getReturnValue(), system), SystemBuilder.this.getType((PsiElement)method));
                    }
                }

                public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
                    super.visitTypeCastExpression(expression2);
                    PsiType operandType = SystemBuilder.this.evaluateType(expression2.getOperand(), system);
                    PsiType castType = SystemBuilder.this.evaluateType((PsiExpression)expression2, system);
                    if (operandType == null || castType == null) {
                        return;
                    }
                    if (Util.bindsTypeVariables(operandType)) {
                        system.addCast(expression2, operandType);
                    }
                    if (operandType.getDeepComponentType() instanceof PsiTypeVariable || castType.getDeepComponentType() instanceof PsiTypeVariable) {
                        system.addSubtypeConstraint(operandType, castType);
                    } else {
                        PsiClassType.ClassResolveResult operandResult = Util.resolveType(operandType);
                        PsiClassType.ClassResolveResult castResult = Util.resolveType(castType);
                        PsiClass operandClass = operandResult.getElement();
                        PsiClass castClass = castResult.getElement();
                        if (operandClass != null && castClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)operandClass, (PsiClass)castClass, (boolean)true)) {
                            system.addSubtypeConstraint(operandType, castType);
                        }
                    }
                }

                public void visitVariable(PsiVariable variable) {
                    super.visitVariable(variable);
                    PsiExpression init = variable.getInitializer();
                    if (init != null) {
                        system.addSubtypeConstraint(SystemBuilder.this.evaluateType(init, system), SystemBuilder.this.getType((PsiElement)variable));
                    }
                }

                public void visitNewExpression(PsiNewExpression expression2) {
                    super.visitNewExpression(expression2);
                    PsiArrayInitializerExpression init = expression2.getArrayInitializer();
                    if (init != null) {
                        PsiExpression[] inits = init.getInitializers();
                        PsiType type2 = SystemBuilder.this.getType((PsiElement)expression2);
                        for (PsiExpression init1 : inits) {
                            system.addSubtypeConstraint((PsiType)SystemBuilder.this.evaluateType(init1, system).createArrayType(), type2);
                        }
                    }
                }

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
                    if (qualifierExpression2 != null) {
                        qualifierExpression2.accept((PsiElementVisitor)this);
                    }
                }
            });
            this.myVisitedConstructions.add(anchor);
        }
    }

    private static SearchScope getScope(PsiSearchHelper helper, PsiElement element) {
        SearchScope scope = helper.getUseScope(element);
        if (scope instanceof GlobalSearchScope) {
            scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)scope), (FileType[])new FileType[]{StdFileTypes.JAVA, StdFileTypes.JSP, StdFileTypes.JSPX});
        }
        return scope;
    }

    PsiType replaceWildCards(PsiType type2, ReductionSystem system, PsiSubstitutor definedSubst) {
        if (type2 instanceof PsiWildcardType) {
            PsiWildcardType wildcard = (PsiWildcardType)type2;
            PsiTypeVariable var = this.myTypeVariableFactory.create();
            PsiType bound = wildcard.getBound();
            if (bound != null) {
                if (wildcard.isExtends()) {
                    system.addSubtypeConstraint(Util.banalize(definedSubst.substitute(this.replaceWildCards(bound, system, definedSubst))), var);
                } else {
                    system.addSubtypeConstraint(var, Util.banalize(definedSubst.substitute(this.replaceWildCards(bound, system, definedSubst))));
                }
            }
            return var;
        }
        if (type2 instanceof PsiClassType) {
            PsiClassType.ClassResolveResult result2 = Util.resolveType(type2);
            PsiClass aClass = result2.getElement();
            PsiSubstitutor aSubst = result2.getSubstitutor();
            if (aClass != null) {
                PsiSubstitutor theSubst = PsiSubstitutor.EMPTY;
                for (PsiTypeParameter p : aSubst.getSubstitutionMap().keySet()) {
                    theSubst = theSubst.put(p, this.replaceWildCards(aSubst.substitute(p), system, definedSubst));
                }
                return JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createType(aClass, theSubst);
            }
        }
        return type2;
    }

    private void addBoundConstraintsImpl(PsiType defined, PsiType type2, ReductionSystem system) {
        PsiClassType.ClassResolveResult resultDefined = Util.resolveType(defined);
        PsiClassType.ClassResolveResult resultType = Util.resolveType(type2);
        PsiClass definedClass = resultDefined.getElement();
        if (definedClass == null || !definedClass.equals(resultType.getElement())) {
            return;
        }
        PsiSubstitutor definedSubst = resultDefined.getSubstitutor();
        PsiSubstitutor typeSubst = resultType.getSubstitutor();
        for (PsiTypeParameter parameter : definedSubst.getSubstitutionMap().keySet()) {
            PsiClassType[] extendsList = parameter.getExtendsList().getReferencedTypes();
            PsiType definedType = definedSubst.substitute(parameter);
            if (definedType instanceof PsiTypeVariable) {
                for (PsiClassType extendsType : extendsList) {
                    extendsType = this.replaceWildCards((PsiType)extendsType, system, definedSubst);
                    system.addSubtypeConstraint(definedType, Util.banalize(definedSubst.substitute((PsiType)extendsType)));
                }
                continue;
            }
            this.addBoundConstraintsImpl(definedType, typeSubst.substitute(parameter), system);
        }
    }

    private void addBoundConstraints(ReductionSystem system, PsiType definedType, PsiElement element) {
        PsiType elemenType = Util.getType(element);
        if (elemenType != null) {
            this.addBoundConstraintsImpl(definedType, elemenType, system);
            if (this.mySettings.cookObjects() && elemenType.getCanonicalText().equals("java.lang.Object")) {
                system.addSubtypeConstraint(definedType, elemenType);
            }
        }
    }

    public ReductionSystem build(PsiElement ... scopes) {
        return this.build(this.collect(scopes));
    }

    public ReductionSystem build(Set<PsiElement> victims) {
        PsiMethod m;
        PsiParameter p;
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)this.myManager.getProject());
        ReductionSystem system = new ReductionSystem(this.myProject, victims, this.myTypes, this.myTypeVariableFactory, this.mySettings);
        for (PsiElement element : victims) {
            if (element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiMethod) {
                if (this.verifyMethod(element, victims, helper)) continue;
                continue;
            }
            if (element instanceof PsiMethod && this.verifyMethod(element, victims, helper)) continue;
        }
        for (PsiElement element : victims) {
            PsiType definedType;
            if (element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiMethod) {
                p = this.myParameters.get(element);
                if (p == null) continue;
                definedType = this.defineType((PsiElement)p);
                this.setType(element, definedType);
            } else if (element instanceof PsiMethod) {
                m = this.myMethods.get(element);
                if (m == null) continue;
                definedType = this.defineType((PsiElement)m);
                system.addSubtypeConstraint(this.defineType(element), definedType);
            } else {
                definedType = this.defineType(element);
            }
            this.addBoundConstraints(system, definedType, element);
        }
        for (PsiElement element : victims) {
            PsiMethod m2;
            PsiElement scope;
            if (element instanceof PsiParameter ? ((scope = ((PsiParameter)element).getDeclarationScope()) instanceof PsiMethod ? (p = this.myParameters.get(element)) == null : element instanceof PsiMethod && (m = this.myMethods.get(element)) == null) : element instanceof PsiMethod && (m2 = this.myMethods.get(element)) == null) continue;
            this.addUsage(system, element);
            if (element instanceof PsiExpression) continue;
            for (PsiReference ref : ReferencesSearch.search((PsiElement)element, (SearchScope)SystemBuilder.getScope(helper, element), (boolean)true)) {
                PsiElement elt = ref.getElement();
                if (elt == null) continue;
                this.addUsage(system, elt);
            }
        }
        return system;
    }

    private void addForEachConstraint(ReductionSystem system, PsiForeachStatement statement2) {
        PsiType paramType = this.getType((PsiElement)statement2.getIterationParameter());
        PsiExpression value2 = statement2.getIteratedValue();
        if (value2 != null) {
            PsiType type2 = this.evaluateType(value2, system);
            if (type2 instanceof PsiClassType) {
                PsiSubstitutor substitutor;
                PsiTypeParameter[] typeParameters;
                PsiClass iterableClass;
                PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)type2).resolveGenerics();
                PsiClass clazz = resolveResult.getElement();
                if (clazz != null && (iterableClass = JavaPsiFacade.getInstance((Project)clazz.getProject()).findClass("java.lang.Iterable", clazz.getResolveScope())) != null && (typeParameters = iterableClass.getTypeParameters()).length == 1 && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)iterableClass, (PsiClass)clazz, (PsiSubstitutor)resolveResult.getSubstitutor())) != null) {
                    PsiType componentType = substitutor.substitute(typeParameters[0]);
                    system.addSubtypeConstraint(componentType, paramType);
                }
            } else if (type2 instanceof PsiArrayType) {
                system.addSubtypeConstraint(((PsiArrayType)type2).getComponentType(), paramType);
            }
        }
    }
}

