/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeCook.deductive.util;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.refactoring.typeCook.Settings;
import com.intellij.refactoring.typeCook.Util;
import com.intellij.refactoring.typeCook.deductive.util.Visitor;
import java.util.LinkedHashSet;
import java.util.Set;

public class VictimCollector
extends Visitor {
    final Set<PsiElement> myVictims = new LinkedHashSet<PsiElement>();
    final PsiElement[] myElements;
    final Settings mySettings;

    public VictimCollector(PsiElement[] elements, Settings settings) {
        this.myElements = elements;
        this.mySettings = settings;
    }

    private void testNAdd(PsiElement element, PsiType t) {
        if (Util.isRaw(t, this.mySettings)) {
            if (element instanceof PsiNewExpression && t.getCanonicalText().equals("java.lang.Object")) {
                return;
            }
            this.myVictims.add(element);
        }
    }

    public void visitLocalVariable(PsiLocalVariable variable) {
        this.testNAdd((PsiElement)variable, variable.getType());
        super.visitLocalVariable(variable);
    }

    public void visitForeachStatement(PsiForeachStatement statement2) {
        super.visitForeachStatement(statement2);
        PsiParameter parameter = statement2.getIterationParameter();
        this.testNAdd((PsiElement)parameter, parameter.getType());
    }

    public void visitField(PsiField field) {
        this.testNAdd((PsiElement)field, field.getType());
        super.visitField(field);
    }

    public void visitMethod(PsiMethod method) {
        PsiCodeBlock body2;
        PsiParameter[] parms;
        for (PsiParameter parm : parms = method.getParameterList().getParameters()) {
            this.testNAdd((PsiElement)parm, parm.getType());
        }
        if (Util.isRaw(method.getReturnType(), this.mySettings)) {
            this.myVictims.add((PsiElement)method);
        }
        if ((body2 = method.getBody()) != null) {
            body2.accept((PsiElementVisitor)this);
        }
    }

    public void visitNewExpression(PsiNewExpression expression2) {
        if (expression2.getClassReference() != null) {
            this.testNAdd((PsiElement)expression2, expression2.getType());
        }
        super.visitNewExpression(expression2);
    }

    public void visitTypeCastExpression(PsiTypeCastExpression cast) {
        PsiTypeElement typeElement = cast.getCastType();
        if (typeElement != null) {
            this.testNAdd((PsiElement)cast, typeElement.getType());
        }
        super.visitTypeCastExpression(cast);
    }

    public void visitReferenceExpression(PsiReferenceExpression expression2) {
    }

    public void visitFile(PsiFile file2) {
        if (file2 instanceof PsiJavaFile) {
            super.visitFile(file2);
        }
    }

    public Set<PsiElement> getVictims() {
        for (PsiElement element : this.myElements) {
            element.accept((PsiElementVisitor)this);
        }
        return this.myVictims;
    }
}

