/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeConversionDescriptor
extends TypeConversionDescriptorBase {
    private static final Logger LOG = Logger.getInstance(TypeConversionDescriptor.class);
    private String myStringToReplace = null;
    private String myReplaceByString = "$";
    private PsiExpression myExpression;
    private PsiType myConversionType;

    public TypeConversionDescriptor(@NonNls String stringToReplace, @NonNls String replaceByString) {
        this(stringToReplace, replaceByString, (PsiExpression)null);
    }

    public TypeConversionDescriptor(@NonNls String stringToReplace, @NonNls String replaceByString, PsiExpression expression2) {
        this.myStringToReplace = stringToReplace;
        this.myReplaceByString = replaceByString;
        this.myExpression = expression2;
    }

    public TypeConversionDescriptor(@NonNls String stringToReplace, @NonNls String replaceByString, PsiType conversionType) {
        this(stringToReplace, replaceByString);
        this.myConversionType = conversionType;
    }

    public TypeConversionDescriptor withConversionType(PsiType conversionType) {
        this.myConversionType = conversionType;
        return this;
    }

    public void setStringToReplace(String stringToReplace) {
        this.myStringToReplace = stringToReplace;
    }

    public void setReplaceByString(String replaceByString) {
        this.myReplaceByString = replaceByString;
    }

    public String getStringToReplace() {
        return this.myStringToReplace;
    }

    public String getReplaceByString() {
        return this.myReplaceByString;
    }

    public PsiExpression getExpression() {
        return this.myExpression;
    }

    public void setExpression(PsiExpression expression2) {
        this.myExpression = expression2;
    }

    @Override
    @Nullable
    public PsiType conversionType() {
        return this.myConversionType;
    }

    @Override
    public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/TypeConversionDescriptor", "replace"));
        }
        if (this.getExpression() != null) {
            expression2 = this.getExpression();
        }
        return TypeConversionDescriptor.replaceExpression(expression2, this.getStringToReplace(), this.getReplaceByString());
    }

    @NotNull
    public static PsiExpression replaceExpression(@NotNull PsiExpression expression2, String stringToReplace, String replaceByString) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/typeMigration/TypeConversionDescriptor", "replaceExpression"));
        }
        Project project2 = expression2.getProject();
        ReplaceOptions options = new ReplaceOptions();
        MatchOptions matchOptions = options.getMatchOptions();
        matchOptions.setFileType((FileType)StdFileTypes.JAVA);
        Replacer replacer = new Replacer(project2, null);
        String replacement = replacer.testReplace(expression2.getText(), stringToReplace, replaceByString, options);
        PsiExpression psiExpression = (PsiExpression)JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(expression2.replace((PsiElement)JavaPsiFacade.getInstance((Project)project2).getElementFactory().createExpressionFromText(replacement, (PsiElement)expression2)));
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/TypeConversionDescriptor", "replaceExpression"));
        }
        return psiExpression;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.myReplaceByString != null) {
            buf.append(this.myReplaceByString);
        }
        if (this.myStringToReplace != null) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(this.myStringToReplace);
        }
        if (this.myExpression != null) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(this.myExpression.getText());
        }
        return buf.toString();
    }
}

