/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationVariableTypeFixProvider;
import com.intellij.refactoring.typeMigration.rules.LongAdderConversionRule;
import com.intellij.util.IncorrectOperationException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConvertAtomicToLongAdderIntention
extends PsiElementBaseIntentionAction {
    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/typeMigration/intentions/ConvertAtomicToLongAdderIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/typeMigration/intentions/ConvertAtomicToLongAdderIntention", "invoke"));
        }
        PsiVariable variable = ConvertAtomicToLongAdderIntention.getVariable(element);
        if (variable != null) {
            PsiType longAdder = JavaPsiFacade.getElementFactory((Project)project2).createTypeFromText("java.util.concurrent.atomic.LongAdder", element);
            TypeMigrationVariableTypeFixProvider.runTypeMigrationOnVariable(variable, longAdder, null, false);
        }
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/typeMigration/intentions/ConvertAtomicToLongAdderIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/typeMigration/intentions/ConvertAtomicToLongAdderIntention", "isAvailable"));
        }
        if (!element.isValid() || !PsiUtil.isLanguageLevel8OrHigher((PsiElement)element)) {
            return false;
        }
        PsiVariable variable = ConvertAtomicToLongAdderIntention.getVariable(element);
        return variable != null;
    }

    private static PsiVariable getVariable(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiLocalVariable) && !(parent instanceof PsiField)) {
            return null;
        }
        PsiVariable var = (PsiVariable)element.getParent();
        PsiType type2 = var.getType();
        if (!type2.isValid()) {
            return null;
        }
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type2);
        if (aClass == null || !AtomicLong.class.getName().equals(aClass.getQualifiedName()) && !AtomicInteger.class.getName().equals(aClass.getQualifiedName())) {
            return null;
        }
        PsiExpression initializer = var.getInitializer();
        if (initializer != null) {
            if (initializer instanceof PsiNewExpression) {
                return LongAdderConversionRule.getParametersCount((PsiCallExpression)initializer) == -1 ? null : var;
            }
            return null;
        }
        return var;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/intentions/ConvertAtomicToLongAdderIntention", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Convert to LongAdder" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/intentions/ConvertAtomicToLongAdderIntention", "getFamilyName"));
        }
        return "Convert to LongAdder";
    }
}

