/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;

public abstract class RefactoringDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.ui.RefactoringDialog");
    private Action myRefactorAction;
    private Action myPreviewAction;
    private boolean myCbPreviewResults;
    protected final Project myProject;

    protected RefactoringDialog(@NotNull Project project2, boolean canBeParent) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/ui/RefactoringDialog", "<init>"));
        }
        super(project2, canBeParent);
        this.myCbPreviewResults = true;
        this.myProject = project2;
    }

    public final boolean isPreviewUsages() {
        return this.myCbPreviewResults;
    }

    public void setPreviewResults(boolean previewResults) {
        this.myCbPreviewResults = previewResults;
    }

    public void show() {
        LOG.assertTrue(TransactionGuard.getInstance().getContextTransaction() != null, (Object)"Refactorings should be invoked inside transaction");
        super.show();
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myRefactorAction = new RefactorAction();
        this.myPreviewAction = new PreviewAction();
    }

    protected final Action getRefactorAction() {
        return this.myRefactorAction;
    }

    protected final Action getPreviewAction() {
        return this.myPreviewAction;
    }

    protected abstract void doAction();

    private void doPreviewAction() {
        this.myCbPreviewResults = true;
        this.doAction();
    }

    protected void doRefactorAction() {
        this.myCbPreviewResults = false;
        this.doAction();
    }

    protected final void closeOKAction() {
        super.doOKAction();
    }

    protected final void doOKAction() {
        if (DumbService.isDumb((Project)this.myProject)) {
            Messages.showMessageDialog((Project)this.myProject, (String)"Refactoring is not available while indexing is in progress", (String)"Indexing", null);
            return;
        }
        this.doAction();
    }

    protected boolean areButtonsValid() {
        return true;
    }

    protected void canRun() throws ConfigurationException {
        if (!this.areButtonsValid()) {
            throw new ConfigurationException(null);
        }
    }

    protected void validateButtons() {
        boolean enabled = true;
        try {
            this.setErrorText(null);
            this.canRun();
        }
        catch (ConfigurationException e) {
            enabled = false;
            this.setErrorText(e.getMessage());
        }
        this.getPreviewAction().setEnabled(enabled);
        this.getRefactorAction().setEnabled(enabled);
    }

    protected boolean hasHelpAction() {
        return true;
    }

    protected boolean hasPreviewButton() {
        return true;
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getRefactorAction());
        if (this.hasPreviewButton()) {
            actions.add(this.getPreviewAction());
        }
        actions.add(this.getCancelAction());
        if (this.hasHelpAction()) {
            actions.add(this.getHelpAction());
        }
        if (SystemInfo.isMac) {
            Collections.reverse(actions);
        }
        Action[] actionArray = actions.toArray(new Action[actions.size()]);
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/RefactoringDialog", "createActions"));
        }
        return actionArray;
    }

    protected Project getProject() {
        return this.myProject;
    }

    protected void invokeRefactoring(BaseRefactoringProcessor processor2) {
        Runnable prepareSuccessfulCallback = () -> this.close(0);
        processor2.setPrepareSuccessfulSwingThreadCallback(prepareSuccessfulCallback);
        processor2.setPreviewUsages(this.isPreviewUsages());
        processor2.run();
    }

    private class PreviewAction
    extends AbstractAction {
        public PreviewAction() {
            this.putValue("Name", RefactoringBundle.message((String)"preview.button"));
            if (SystemInfo.isMac) {
                this.putValue("FocusedAction", Boolean.TRUE);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RefactoringDialog.this.doPreviewAction();
        }
    }

    private class RefactorAction
    extends AbstractAction {
        public RefactorAction() {
            this.putValue("Name", RefactoringBundle.message((String)"refactor.button"));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RefactoringDialog.this.doRefactorAction();
        }
    }
}

