/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.configuration.RemoteServerListConfigurable;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class RemoteServerListConfigurableProvider
extends ConfigurableProvider {
    public boolean canCreateConfigurable() {
        List<ServerType<?>> serverTypes = RemoteServerListConfigurableProvider.getServerTypesInCloudsList();
        return !serverTypes.isEmpty();
    }

    public Configurable createConfigurable() {
        return new RemoteServerListConfigurable(RemoteServersManager.getInstance(), RemoteServerListConfigurableProvider.getServerTypesInCloudsList(), null);
    }

    @NotNull
    private static List<ServerType<?>> getServerTypesInCloudsList() {
        Application application = ApplicationManager.getApplication();
        List excludedTypes = Arrays.stream(application.getExtensions(Configurable.APPLICATION_CONFIGURABLE)).filter(RemoteServerListConfigurableProvider::isRemoteServerListConfigurable).filter(ConfigurableEP::canCreateConfigurable).map(ConfigurableEP::createConfigurable).map(RemoteServerListConfigurable.class::cast).map(RemoteServerListConfigurable::getDisplayedServerTypes).flatMap(Collection::stream).collect(Collectors.toList());
        Object[] allServerTypes = (ServerType[])ServerType.EP_NAME.getExtensions();
        List list2 = ContainerUtil.filter((Object[])allServerTypes, t -> !excludedTypes.contains(t));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurableProvider", "getServerTypesInCloudsList"));
        }
        return list2;
    }

    private static boolean isRemoteServerListConfigurable(@NotNull ConfigurableEP<Configurable> ep) {
        if (ep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ep", "com/intellij/remoteServer/impl/configuration/RemoteServerListConfigurableProvider", "isRemoteServerListConfigurable"));
        }
        Class type2 = ep.getConfigurableType();
        return type2 != null && RemoteServerListConfigurable.class.isAssignableFrom(type2);
    }
}

