/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.clientLibrary;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryDescription;
import com.intellij.remoteServer.runtime.clientLibrary.ClientLibraryManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="RemoteServerClientLibraries", storages={@Storage(value="remote-server-client-libraries.xml")})
public class ClientLibraryManagerImpl
extends ClientLibraryManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(ClientLibraryManagerImpl.class);
    private Map<String, List<File>> myFiles = new LinkedHashMap<String, List<File>>();
    private EventDispatcher<ClientLibraryManager.CloudClientLibraryManagerListener> myEventDispatcher = EventDispatcher.create(ClientLibraryManager.CloudClientLibraryManagerListener.class);

    public void addListener(@NotNull ClientLibraryManager.CloudClientLibraryManagerListener listener2, @NotNull Disposable disposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl", "addListener"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl", "addListener"));
        }
        this.myEventDispatcher.addListener((EventListener)listener2, disposable);
    }

    public State getState() {
        State result2 = new State();
        for (Map.Entry<String, List<File>> entry : this.myFiles.entrySet()) {
            DownloadedLibraryState libraryState = new DownloadedLibraryState();
            libraryState.myId = entry.getKey();
            for (File file2 : entry.getValue()) {
                libraryState.myPaths.add(FileUtil.toSystemIndependentName((String)file2.getAbsolutePath()));
            }
            result2.myLibraries.add(libraryState);
        }
        return result2;
    }

    public void loadState(State state) {
        this.myFiles = new HashMap<String, List<File>>();
        for (DownloadedLibraryState libraryState : state.myLibraries) {
            ArrayList<File> files = new ArrayList<File>();
            for (String path : libraryState.myPaths) {
                files.add(new File(path));
            }
            this.myFiles.put(libraryState.myId, files);
        }
    }

    public boolean isDownloaded(@NotNull ClientLibraryDescription description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl", "isDownloaded"));
        }
        return !this.getExistentFiles(description).isEmpty();
    }

    @NotNull
    private List<File> getExistentFiles(ClientLibraryDescription description) {
        List<File> files = this.myFiles.get(description.getId());
        if (files == null) {
            List<File> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl", "getExistentFiles"));
            }
            return list2;
        }
        ArrayList<File> existentFiles = new ArrayList<File>();
        for (File file2 : files) {
            if (!file2.exists()) continue;
            existentFiles.add(file2);
        }
        ArrayList<File> arrayList = existentFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl", "getExistentFiles"));
        }
        return arrayList;
    }

    public void checkConfiguration(@NotNull ClientLibraryDescription description, @Nullable Project project2, @Nullable JComponent component) throws RuntimeConfigurationError {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl", "checkConfiguration"));
        }
        if (!this.isDownloaded(description)) {
            throw new RuntimeConfigurationError("Client libraries were not downloaded", () -> {
                if (description == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl", "lambda$checkConfiguration$0"));
                }
                this.download(description, project2, component);
            });
        }
    }

    private static File getStoreDirectory(ClientLibraryDescription description) {
        return new File(PathManager.getSystemPath(), "remote-server-libraries/" + description.getId());
    }

    @NotNull
    public List<File> getLibraries(@NotNull ClientLibraryDescription description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl", "getLibraries"));
        }
        File[] files = ClientLibraryManagerImpl.getStoreDirectory(description).listFiles();
        List<Object> list2 = files == null ? Collections.emptyList() : Arrays.asList(files);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl", "getLibraries"));
        }
        return list2;
    }

    public void download(@NotNull ClientLibraryDescription libraryDescription, @Nullable Project project2, @Nullable JComponent component) {
        if (libraryDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDescription", "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl", "download"));
        }
        Ref exc = Ref.create(null);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (libraryDescription == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDescription", "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl", "lambda$download$1"));
            }
            try {
                this.download(libraryDescription);
            }
            catch (IOException e) {
                exc.set((Object)e);
            }
        }, "Downloading Client Libraries", false, project2, component);
        if (exc.isNull()) {
            ((ClientLibraryManager.CloudClientLibraryManagerListener)this.myEventDispatcher.getMulticaster()).downloaded();
        } else {
            LOG.info((Throwable)exc.get());
        }
    }

    @NotNull
    public List<File> download(@NotNull ClientLibraryDescription libraryDescription) throws IOException {
        if (libraryDescription == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDescription", "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl", "download"));
        }
        List<File> existentFiles = this.getExistentFiles(libraryDescription);
        if (!existentFiles.isEmpty()) {
            List<File> list2 = existentFiles;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl", "download"));
            }
            return list2;
        }
        DownloadableFileService downloadService = DownloadableFileService.getInstance();
        URL versionsUrl = libraryDescription.getDescriptionUrl();
        DownloadableFileSetVersions versions = downloadService.createFileSetVersions(null, new URL[]{versionsUrl});
        List descriptions = versions.fetchVersions();
        if (descriptions.isEmpty()) {
            throw new IOException("No client library versions loaded");
        }
        FileDownloader downloader = downloadService.createDownloader((DownloadableFileSetDescription)descriptions.get(0));
        List downloaded = downloader.download(ClientLibraryManagerImpl.getStoreDirectory(libraryDescription));
        List<File> files = this.myFiles.get(libraryDescription.getId());
        if (files == null) {
            files = new ArrayList<File>();
            this.myFiles.put(libraryDescription.getId(), files);
        }
        for (Pair pair2 : downloaded) {
            files.add((File)pair2.getFirst());
        }
        ((ClientLibraryManager.CloudClientLibraryManagerListener)this.myEventDispatcher.getMulticaster()).downloaded();
        List<File> list3 = files;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/clientLibrary/ClientLibraryManagerImpl", "download"));
        }
        return list3;
    }

    public static class State {
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false)
        public List<DownloadedLibraryState> myLibraries = new ArrayList<DownloadedLibraryState>();
    }

    @Tag(value="client-library")
    public static class DownloadedLibraryState {
        @Attribute(value="id")
        public String myId;
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false, elementTag="file", elementValueAttribute="path")
        public List<String> myPaths = new ArrayList<String>();
    }
}

