/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.deployment;

import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.impl.runtime.ServerConnectionImpl;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentImpl<D extends DeploymentConfiguration>
implements Deployment {
    private final ServerConnectionImpl<D> myConnection;
    private final String myName;
    private final DeploymentTask<D> myDeploymentTask;
    private volatile DeploymentState myState;
    private String myPresentableName;

    public DeploymentImpl(@NotNull ServerConnectionImpl<D> connection, @NotNull String name2, @NotNull DeploymentStatus status, @Nullable String statusText, @Nullable DeploymentRuntime runtime, @Nullable DeploymentTask<D> deploymentTask) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "<init>"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "<init>"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "<init>"));
        }
        this.myConnection = connection;
        this.myName = name2;
        this.myDeploymentTask = deploymentTask;
        this.myState = new DeploymentState(status, statusText, runtime);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public DeploymentStatus getStatus() {
        DeploymentStatus deploymentStatus = this.myState.getStatus();
        if (deploymentStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "getStatus"));
        }
        return deploymentStatus;
    }

    @NotNull
    public String getStatusText() {
        String statusText = this.myState.getStatusText();
        String string = statusText != null ? statusText : this.myState.getStatus().getPresentableText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "getStatusText"));
        }
        return string;
    }

    public DeploymentRuntime getRuntime() {
        return this.myState.getRuntime();
    }

    @Nullable
    public DeploymentTask<D> getDeploymentTask() {
        return this.myDeploymentTask;
    }

    @NotNull
    public DeploymentLogManager getOrCreateLogManager(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "getOrCreateLogManager"));
        }
        DeploymentLogManager deploymentLogManager = this.myConnection.getOrCreateLogManager(project2, this);
        if (deploymentLogManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "getOrCreateLogManager"));
        }
        return deploymentLogManager;
    }

    public void setStatus(@NotNull DeploymentStatus status, @Nullable String statusText) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "setStatus"));
        }
        this.myConnection.changeDeploymentState(() -> {
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "lambda$setStatus$0"));
            }
            this.changeState(this.myState.getStatus(), status, statusText, this.getRuntime());
        });
    }

    @NotNull
    public ServerConnection<?> getConnection() {
        ServerConnectionImpl<D> serverConnectionImpl = this.myConnection;
        if (serverConnectionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "getConnection"));
        }
        return serverConnectionImpl;
    }

    @Nullable
    public DeploymentRuntime getParentRuntime() {
        DeploymentRuntime runtime = this.getRuntime();
        return runtime == null ? null : runtime.getParent();
    }

    public boolean changeState(@NotNull DeploymentStatus oldStatus, @NotNull DeploymentStatus newStatus, @Nullable String statusText, @Nullable DeploymentRuntime runtime) {
        if (oldStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldStatus", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "changeState"));
        }
        if (newStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStatus", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "changeState"));
        }
        if (this.myState.getStatus() == oldStatus) {
            this.myState = new DeploymentState(newStatus, statusText, runtime);
            return true;
        }
        return false;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myPresentableName == null ? this.getName() : this.myPresentableName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "getPresentableName"));
        }
        return string;
    }

    public void setPresentableName(String presentableName) {
        this.myPresentableName = presentableName;
    }

    protected static class DeploymentState {
        private final DeploymentStatus myStatus;
        private final String myStatusText;
        private final DeploymentRuntime myRuntime;

        private DeploymentState(@NotNull DeploymentStatus status, @Nullable String statusText, @Nullable DeploymentRuntime runtime) {
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl$DeploymentState", "<init>"));
            }
            this.myStatus = status;
            this.myStatusText = statusText;
            this.myRuntime = runtime;
        }

        @NotNull
        public DeploymentStatus getStatus() {
            DeploymentStatus deploymentStatus = this.myStatus;
            if (deploymentStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl$DeploymentState", "getStatus"));
            }
            return deploymentStatus;
        }

        @Nullable
        public String getStatusText() {
            return this.myStatusText;
        }

        @Nullable
        public DeploymentRuntime getRuntime() {
            return this.myRuntime;
        }
    }
}

