/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.MyColoredTreeCellRenderer;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceTooComplexDFAUsage;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.ui.DuplicateNodeRenderer;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliceNode
extends AbstractTreeNode<SliceUsage>
implements DuplicateNodeRenderer.DuplicatableNode<SliceNode>,
MyColoredTreeCellRenderer {
    protected List<SliceNode> myCachedChildren;
    boolean dupNodeCalculated;
    protected SliceNode duplicate;
    final DuplicateMap targetEqualUsages;
    protected boolean changed;
    private int index;

    protected SliceNode(@NotNull Project project2, SliceUsage sliceUsage, @NotNull DuplicateMap targetEqualUsages) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/slicer/SliceNode", "<init>"));
        }
        if (targetEqualUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetEqualUsages", "com/intellij/slicer/SliceNode", "<init>"));
        }
        super(project2, (Object)sliceUsage);
        this.targetEqualUsages = targetEqualUsages;
    }

    @NotNull
    SliceNode copy() {
        SliceUsage newUsage = ((SliceUsage)((Object)this.getValue())).copy();
        SliceNode newNode = new SliceNode(this.getProject(), newUsage, this.targetEqualUsages);
        newNode.dupNodeCalculated = this.dupNodeCalculated;
        newNode.duplicate = this.duplicate;
        SliceNode sliceNode = newNode;
        if (sliceNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNode", "copy"));
        }
        return sliceNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<SliceNode> getChildren() {
        List list2;
        if (this.isUpToDate()) {
            List<Object> list3 = this.myCachedChildren == null ? Collections.emptyList() : this.myCachedChildren;
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNode", "getChildren"));
            }
            return list3;
        }
        try {
            List nodes;
            ProgressIndicator current = ProgressManager.getInstance().getProgressIndicator();
            if (current == null) {
                ProgressIndicatorBase indicator = new ProgressIndicatorBase();
                indicator.start();
                Ref nodesRef = Ref.create();
                try {
                    ProgressManager.getInstance().executeProcessUnderProgress(() -> nodesRef.set(this.doGetChildren()), (ProgressIndicator)indicator);
                }
                finally {
                    indicator.stop();
                }
                nodes = (List)nodesRef.get();
            } else {
                nodes = this.doGetChildren();
            }
            List list4 = nodes;
            synchronized (list4) {
                this.myCachedChildren = nodes;
            }
            list2 = nodes;
        }
        catch (ProcessCanceledException pce) {
            this.changed = true;
            throw pce;
        }
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNode", "getChildren"));
        }
        return list2;
    }

    private List<SliceNode> doGetChildren() {
        return (List)AbstractTreeUi.calculateYieldingToWriteAction(() -> {
            ArrayList children2 = new ArrayList();
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            Processor processor2 = sliceUsage -> {
                progress.checkCanceled();
                SliceNode node = new SliceNode(this.myProject, (SliceUsage)((Object)((Object)sliceUsage)), this.targetEqualUsages);
                List list2 = children2;
                synchronized (list2) {
                    node.index = children2.size();
                    children2.add(node);
                }
                return true;
            };
            ((SliceUsage)((Object)((Object)this.getValue()))).processChildren((Processor<SliceUsage>)processor2);
            return children2;
        });
    }

    SliceNode getNext(List parentChildren) {
        return this.index == parentChildren.size() - 1 ? null : (SliceNode)parentChildren.get(this.index + 1);
    }

    SliceNode getPrev(List parentChildren) {
        return this.index == 0 ? null : (SliceNode)parentChildren.get(this.index - 1);
    }

    public List<SliceNode> getCachedChildren() {
        return this.myCachedChildren;
    }

    private boolean isUpToDate() {
        return this.myCachedChildren != null || !this.isValid();
    }

    @NotNull
    protected PresentationData createPresentation() {
        PresentationData presentationData = new PresentationData(){

            @NotNull
            public Object[] getEqualityObjects() {
                Object[] objectArray = ArrayUtil.append((Object[])super.getEqualityObjects(), (Object)SliceNode.this.changed);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNode$1", "getEqualityObjects"));
                }
                return objectArray;
            }
        };
        if (presentationData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceNode", "createPresentation"));
        }
        return presentationData;
    }

    protected void update(PresentationData presentation) {
        if (presentation != null) {
            presentation.setChanged(presentation.isChanged() || this.changed);
            this.changed = false;
        }
    }

    public void calculateDupNode() {
        if (!this.dupNodeCalculated) {
            if (!(this.getValue() instanceof SliceTooComplexDFAUsage)) {
                this.duplicate = this.targetEqualUsages.putNodeCheckDupe(this);
            }
            this.dupNodeCalculated = true;
        }
    }

    @Override
    public SliceNode getDuplicate() {
        return this.duplicate;
    }

    public void navigate(boolean requestFocus) {
        SliceUsage sliceUsage = (SliceUsage)((Object)this.getValue());
        sliceUsage.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return ((SliceUsage)((Object)this.getValue())).canNavigate();
    }

    public boolean canNavigateToSource() {
        return ((SliceUsage)((Object)this.getValue())).canNavigateToSource();
    }

    public boolean isValid() {
        return (Boolean)ReadAction.compute(() -> ((SliceUsage)((Object)((Object)this.getValue()))).isValid());
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    @Override
    public void customizeCellRenderer(@NotNull SliceUsageCellRendererBase renderer, @NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/slicer/SliceNode", "customizeCellRenderer"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/slicer/SliceNode", "customizeCellRenderer"));
        }
        renderer.setIcon(this.getPresentation().getIcon(expanded));
        if (this.isValid()) {
            SliceUsage sliceUsage = (SliceUsage)((Object)this.getValue());
            renderer.customizeCellRendererFor(sliceUsage);
            renderer.setToolTipText(sliceUsage.getPresentation().getTooltipText());
        } else {
            renderer.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]) + " ", SliceUsageCellRendererBase.ourInvalidAttributes);
        }
    }

    public void setChanged() {
        this.changed = true;
    }

    @Nullable
    public SliceLanguageSupportProvider getProvider() {
        AbstractTreeNode element = this.getElement();
        if (element == null) {
            return null;
        }
        SliceUsage usage = (SliceUsage)((Object)element.getValue());
        if (usage == null) {
            return null;
        }
        PsiElement psiElement = usage.getElement();
        if (psiElement == null) {
            return null;
        }
        return LanguageSlicing.getProvider(psiElement);
    }

    public String getNodeText() {
        return ((SliceUsage)((Object)this.getValue())).getPresentation().getPlainText().trim();
    }

    public String toString() {
        return (String)ReadAction.compute(() -> this.getValue() == null ? "<null>" : ((SliceUsage)((Object)((Object)this.getValue()))).toString());
    }
}

