/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.slicer.JavaSliceDereferenceUsage;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.util.BitUtil;
import com.intellij.util.FontUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

class SliceUsageCellRenderer
extends SliceUsageCellRendererBase {
    SliceUsageCellRenderer() {
    }

    @Override
    public void customizeCellRendererFor(@NotNull SliceUsage sliceUsage) {
        SliceLanguageSupportProvider foreignSlicing;
        JavaLanguage language;
        String location;
        PsiMethod method;
        PsiClass aClass;
        if (sliceUsage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sliceUsage", "com/intellij/slicer/SliceUsageCellRenderer", "customizeCellRendererFor"));
        }
        boolean isForcedLeaf = sliceUsage instanceof JavaSliceDereferenceUsage;
        JavaSliceUsage javaSliceUsage = sliceUsage instanceof JavaSliceUsage ? (JavaSliceUsage)sliceUsage : null;
        TextChunk[] text2 = sliceUsage.getText();
        boolean isInsideContainer = javaSliceUsage != null && javaSliceUsage.indexNesting != 0;
        int length = text2.length;
        for (int i2 = 0; i2 < length; ++i2) {
            TextChunk textChunk = text2[i2];
            SimpleTextAttributes attributes = textChunk.getSimpleAttributesIgnoreBackground();
            if (isForcedLeaf) {
                attributes = attributes.derive(attributes.getStyle(), (Color)JBColor.LIGHT_GRAY, attributes.getBgColor(), attributes.getWaveColor());
            }
            boolean inUsage = BitUtil.isSet((int)attributes.getFontStyle(), (int)1);
            if (!isInsideContainer || inUsage) {
                // empty if block
            }
            this.append(textChunk.getText(), attributes);
            if (i2 != 0) continue;
            this.append(FontUtil.spaceAndThinSpace());
        }
        if (javaSliceUsage != null && javaSliceUsage.indexNesting != 0) {
            this.append(" (Tracking container '" + SliceUsageCellRenderer.getContainerName(javaSliceUsage) + (javaSliceUsage.syntheticField.isEmpty() ? "" : "." + javaSliceUsage.syntheticField) + "' contents)", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        PsiElement element = sliceUsage.getElement();
        while (true) {
            PsiClass psiClass = aClass = (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) == null ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) : method.getContainingClass();
            if (!(aClass instanceof PsiAnonymousClass)) break;
            element = aClass;
        }
        int methodOptions = 4353;
        String string = method != null ? PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)methodOptions, (int)2, (int)2) : (location = aClass != null ? PsiFormatUtil.formatClass((PsiClass)aClass, (int)1) : null);
        if (location != null) {
            SimpleTextAttributes attributes = SimpleTextAttributes.GRAY_ATTRIBUTES;
            this.append(" in " + location, attributes);
        }
        Object object = language = element == null ? JavaLanguage.INSTANCE : element.getLanguage();
        if (language != JavaLanguage.INSTANCE && (foreignSlicing = LanguageSlicing.getProvider(element)) == null) {
            this.append(" (in " + language.getDisplayName() + " file - stopped here)", SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
        }
    }

    @NotNull
    private static String getContainerName(@NotNull JavaSliceUsage usage) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/slicer/SliceUsageCellRenderer", "getContainerName"));
        }
        String result2 = "";
        JavaSliceUsage prev = usage;
        String name2 = "";
        while (usage != null) {
            PsiElement element;
            if (usage.indexNesting != prev.indexNesting) {
                result2 = name2 + (result2.isEmpty() ? "" : ".") + result2;
                if (usage.indexNesting == 0) break;
            }
            if ((element = usage.getElement()) instanceof PsiNamedElement) {
                name2 = ((PsiNamedElement)element).getName();
            } else if (element instanceof PsiReference) {
                name2 = ((PsiReference)element).getCanonicalText();
            }
            prev = usage;
            usage = (JavaSliceUsage)usage.getParent();
        }
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceUsageCellRenderer", "getContainerName"));
        }
        return string;
    }
}

