/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.util.Consumer;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class StreamLoader
implements Loader {
    private final InputStream stream;
    private final String name;

    public StreamLoader(InputStream stream, String name2) {
        this.stream = stream;
        this.name = name2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void load(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spellchecker/StreamLoader", "load"));
        }
        StreamLoader.doLoad(this.stream, consumer);
    }

    static void doLoad(@NotNull InputStream stream, @NotNull Consumer<String> consumer) {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/spellchecker/StreamLoader", "doLoad"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spellchecker/StreamLoader", "doLoad"));
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                consumer.consume((Object)line);
            }
        }
        catch (Exception e) {
            Logger.getInstance(StreamLoader.class).error((Throwable)e);
        }
    }
}

