/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.dupLocator.AbstractMatchingVisitor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptorProvider;
import com.intellij.dupLocator.equivalence.MultiChildDescriptor;
import com.intellij.dupLocator.equivalence.SingleChildDescriptor;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.structuralsearch.DocumentBasedReplaceHandler;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.impl.matcher.handlers.DelegatingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.LightTopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SkippingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementContext;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StructuralSearchProfileBase
extends StructuralSearchProfile {
    private static final String DELIMETER_CHARS = ",;.[]{}():";
    protected static final String PATTERN_PLACEHOLDER = "$$PATTERN_PLACEHOLDER$$";

    @Override
    public void compile(PsiElement[] elements, final @NotNull GlobalCompilingVisitor globalVisitor) {
        if (globalVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalVisitor", "com/intellij/structuralsearch/StructuralSearchProfileBase", "compile"));
        }
        PsiElement topElement = elements[0].getParent();
        PsiElement element = elements.length > 1 ? topElement : elements[0];
        element.accept((PsiElementVisitor)new MyCompilingVisitor(globalVisitor, topElement));
        element.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                MatchingHandler delegate;
                super.visitElement(element);
                if (DuplocatorUtil.isIgnoredNode(element)) {
                    return;
                }
                CompiledPattern pattern = globalVisitor.getContext().getPattern();
                MatchingHandler handler2 = pattern.getHandler(element);
                if (!(handler2 instanceof SubstitutionHandler || handler2 instanceof TopLevelMatchingHandler || handler2 instanceof LightTopLevelMatchingHandler)) {
                    pattern.setHandler(element, new SkippingHandler(handler2));
                }
                if (handler2 instanceof LightTopLevelMatchingHandler && !((delegate = ((LightTopLevelMatchingHandler)handler2).getDelegate()) instanceof SubstitutionHandler)) {
                    pattern.setHandler(element, new LightTopLevelMatchingHandler(new SkippingHandler(delegate)));
                }
            }
        });
        final Language baseLanguage = element.getContainingFile().getLanguage();
        globalVisitor.getContext().getPattern().setStrategy(new MatchingStrategy(){

            @Override
            public boolean continueMatching(PsiElement start) {
                Language fileLanguage;
                Language language = start.getLanguage();
                PsiFile file2 = start.getContainingFile();
                if (file2 != null && (fileLanguage = file2.getLanguage()).isKindOf(language)) {
                    language = fileLanguage;
                }
                return language == baseLanguage;
            }

            @Override
            public boolean shouldSkip(PsiElement element, PsiElement elementToMatchWith) {
                return DuplocatorUtil.shouldSkip(element, elementToMatchWith);
            }
        });
    }

    @Override
    @NotNull
    public PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor globalVisitor) {
        if (globalVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalVisitor", "com/intellij/structuralsearch/StructuralSearchProfileBase", "createMatchingVisitor"));
        }
        MyMatchingVisitor myMatchingVisitor = new MyMatchingVisitor(globalVisitor);
        if (myMatchingVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchProfileBase", "createMatchingVisitor"));
        }
        return myMatchingVisitor;
    }

    @Override
    @NotNull
    public NodeFilter getLexicalNodesFilter() {
        NodeFilter nodeFilter = element -> DuplocatorUtil.isIgnoredNode(element);
        if (nodeFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchProfileBase", "getLexicalNodesFilter"));
        }
        return nodeFilter;
    }

    public static boolean containsOnlyDelimeters(String s) {
        int n = s.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if (DELIMETER_CHARS.indexOf(s.charAt(i2)) >= 0) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected abstract String[] getVarPrefixes();

    @Override
    @NotNull
    public CompiledPattern createCompiledPattern() {
        CompiledPattern compiledPattern = new CompiledPattern(){

            @Override
            protected SubstitutionHandler doCreateSubstitutionHandler(String name2, boolean target2, int minOccurs, int maxOccurs, boolean greedy) {
                return new MySubstitutionHandler(name2, target2, minOccurs, maxOccurs, greedy);
            }

            @Override
            public String[] getTypedVarPrefixes() {
                return StructuralSearchProfileBase.this.getVarPrefixes();
            }

            @Override
            public boolean isTypedVar(String str) {
                for (String prefix : StructuralSearchProfileBase.this.getVarPrefixes()) {
                    if (!str.startsWith(prefix)) continue;
                    return true;
                }
                return false;
            }

            @Override
            @NotNull
            public String getTypedVarString(PsiElement element) {
                PsiElement initialElement = element;
                PsiElement child = SkippingHandler.getOnlyNonWhitespaceChild(element);
                while (child != element && child != null && !(child instanceof LeafElement)) {
                    element = child;
                    child = SkippingHandler.getOnlyNonWhitespaceChild(element);
                }
                String string = child instanceof LeafElement ? element.getText() : initialElement.getText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchProfileBase$3", "getTypedVarString"));
                }
                return string;
            }
        };
        if (compiledPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchProfileBase", "createCompiledPattern"));
        }
        return compiledPattern;
    }

    @Override
    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/structuralsearch/StructuralSearchProfileBase", "isMyLanguage"));
        }
        return language.isKindOf(this.getFileType().getLanguage());
    }

    @NotNull
    protected abstract LanguageFileType getFileType();

    @Override
    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text2, @NotNull PatternTreeContext context, @NotNull FileType fileType, @Nullable Language language, @Nullable String contextName, @Nullable String extension, @NotNull Project project2, boolean physical) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/structuralsearch/StructuralSearchProfileBase", "createPatternTree"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/structuralsearch/StructuralSearchProfileBase", "createPatternTree"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/structuralsearch/StructuralSearchProfileBase", "createPatternTree"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/StructuralSearchProfileBase", "createPatternTree"));
        }
        if (context == PatternTreeContext.Block) {
            String strContext = this.getContext(text2, language, contextName);
            PsiElement[] psiElementArray = strContext != null ? StructuralSearchProfileBase.parsePattern(project2, strContext, text2, fileType, language, extension, physical) : PsiElement.EMPTY_ARRAY;
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchProfileBase", "createPatternTree"));
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = super.createPatternTree(text2, context, fileType, language, contextName, extension, project2, physical);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchProfileBase", "createPatternTree"));
        }
        return psiElementArray;
    }

    @Override
    public void checkReplacementPattern(Project project2, ReplaceOptions options) {
        CompiledPattern compiledPattern = PatternCompiler.compilePattern(project2, options.getMatchOptions());
        if (compiledPattern == null) {
            return;
        }
        NodeIterator it = compiledPattern.getNodes();
        if (!it.hasNext()) {
            return;
        }
        PsiElement root = it.current().getParent();
        if (!StructuralSearchProfileBase.checkOptionalChildren(root) || !StructuralSearchProfileBase.checkErrorElements(root)) {
            throw new UnsupportedPatternException(": Partial and expression patterns are not supported");
        }
    }

    private static boolean checkErrorElements(PsiElement element) {
        final boolean[] result2 = new boolean[]{true};
        final int endOffset = element.getTextRange().getEndOffset();
        element.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                if (element instanceof PsiErrorElement && element.getTextRange().getEndOffset() == endOffset) {
                    result2[0] = false;
                }
            }
        });
        return result2[0];
    }

    private static boolean checkOptionalChildren(PsiElement root) {
        final boolean[] result2 = new boolean[]{true};
        root.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                if (element instanceof LeafElement) {
                    return;
                }
                EquivalenceDescriptorProvider provider = EquivalenceDescriptorProvider.getInstance(element);
                if (provider == null) {
                    return;
                }
                EquivalenceDescriptor descriptor = provider.buildDescriptor(element);
                if (descriptor == null) {
                    return;
                }
                for (SingleChildDescriptor singleChildDescriptor : descriptor.getSingleChildDescriptors()) {
                    if (singleChildDescriptor.getType() != SingleChildDescriptor.MyType.OPTIONALLY_IN_PATTERN || singleChildDescriptor.getElement() != null) continue;
                    result2[0] = false;
                }
                for (MultiChildDescriptor multiChildDescriptor : descriptor.getMultiChildDescriptors()) {
                    PsiElement[] elements;
                    if (multiChildDescriptor.getType() != MultiChildDescriptor.MyType.OPTIONALLY_IN_PATTERN || (elements = multiChildDescriptor.getElements()) != null && elements.length != 0) continue;
                    result2[0] = false;
                }
            }
        });
        return result2[0];
    }

    @Override
    public StructuralReplaceHandler getReplaceHandler(@NotNull ReplacementContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/structuralsearch/StructuralSearchProfileBase", "getReplaceHandler"));
        }
        return new DocumentBasedReplaceHandler(context.getProject());
    }

    @NotNull
    public String[] getContextNames() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/StructuralSearchProfileBase", "getContextNames"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Nullable
    protected String getContext(@NotNull String pattern, @Nullable Language language, @Nullable String contextName) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/structuralsearch/StructuralSearchProfileBase", "getContext"));
        }
        return PATTERN_PLACEHOLDER;
    }

    private static boolean canBePatternVariable(PsiElement element) {
        if (element instanceof LeafElement) {
            return true;
        }
        while (!(element instanceof LeafElement) && element != null) {
            element = SkippingHandler.getOnlyNonWhitespaceChild(element);
        }
        return element != null;
    }

    protected boolean isStringLiteral(PsiElement element) {
        if (element == null) {
            return false;
        }
        ASTNode astNode = element.getNode();
        if (astNode == null) {
            return false;
        }
        IElementType elementType = astNode.getElementType();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage());
        if (parserDefinition != null) {
            TokenSet literals = parserDefinition.getStringLiteralElements();
            return literals.contains(elementType);
        }
        return false;
    }

    private static boolean canBePatternVariableValue(PsiElement element) {
        return !StructuralSearchProfileBase.containsOnlyDelimeters(element.getText());
    }

    @Override
    public boolean canBeVarDelimeter(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/StructuralSearchProfileBase", "canBeVarDelimeter"));
        }
        ASTNode node = element.getNode();
        return node != null && this.getVariableDelimiters().contains(node.getElementType());
    }

    protected TokenSet getVariableDelimiters() {
        return TokenSet.EMPTY;
    }

    public static PsiElement[] parsePattern(Project project2, String context, String pattern, FileType fileType, Language language, String extension, boolean physical) {
        PsiFile file2;
        int offset = context.indexOf(PATTERN_PLACEHOLDER);
        int patternLength = pattern.length();
        String patternInContext = context.replace(PATTERN_PLACEHOLDER, pattern);
        String ext = extension != null ? extension : fileType.getDefaultExtension();
        String name2 = "__dummy." + ext;
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project2);
        PsiFile psiFile = file2 = language == null ? factory.createFileFromText(name2, fileType, (CharSequence)patternInContext, LocalTimeCounter.currentTime(), physical, true) : factory.createFileFromText(name2, language, (CharSequence)patternInContext, physical, true);
        if (file2 == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement topElement = element;
        for (element = element.getParent(); element != null; element = element.getParent()) {
            if (element.getTextRange().getStartOffset() != offset || element.getTextLength() > patternLength) continue;
            topElement = element;
        }
        if (topElement instanceof PsiFile) {
            return topElement.getChildren();
        }
        int endOffset = offset + patternLength;
        result2.add(topElement);
        for (topElement = topElement.getNextSibling(); topElement != null && topElement.getTextRange().getEndOffset() <= endOffset; topElement = topElement.getNextSibling()) {
            result2.add(topElement);
        }
        return result2.toArray(new PsiElement[result2.size()]);
    }

    private static class MySubstitutionHandler
    extends SubstitutionHandler {
        final Set<PsiElement> myExceptedNodes = new HashSet();

        public MySubstitutionHandler(String name2, boolean target2, int minOccurs, int maxOccurs, boolean greedy) {
            super(name2, target2, minOccurs, maxOccurs, greedy);
        }

        @Override
        public boolean matchSequentially(NodeIterator nodes, NodeIterator nodes2, MatchContext context) {
            if (this.doMatchSequentially(nodes, nodes2, context)) {
                return true;
            }
            PsiElement current = nodes.current();
            if (current != null) {
                this.myExceptedNodes.add(current);
            }
            boolean result2 = this.doMatchSequentiallyBySimpleHandler(nodes, nodes2, context);
            this.myExceptedNodes.remove(current);
            return result2;
        }
    }

    private class MyMatchingVisitor
    extends PsiElementVisitor {
        private final GlobalMatchingVisitor myGlobalVisitor;

        private MyMatchingVisitor(GlobalMatchingVisitor globalVisitor) {
            this.myGlobalVisitor = globalVisitor;
        }

        private boolean shouldIgnoreVarNode(PsiElement element) {
            MatchingHandler handler2 = this.myGlobalVisitor.getMatchContext().getPattern().getHandlerSimple(element);
            if (handler2 instanceof DelegatingHandler) {
                handler2 = ((DelegatingHandler)((Object)handler2)).getDelegate();
            }
            return handler2 instanceof MySubstitutionHandler && ((MySubstitutionHandler)handler2).myExceptedNodes.contains(element);
        }

        public void visitElement(PsiElement element) {
            super.visitElement(element);
            EquivalenceDescriptorProvider descriptorProvider = EquivalenceDescriptorProvider.getInstance(element);
            if (descriptorProvider != null) {
                EquivalenceDescriptor descriptor1 = descriptorProvider.buildDescriptor(element);
                EquivalenceDescriptor descriptor2 = descriptorProvider.buildDescriptor(this.myGlobalVisitor.getElement());
                if (descriptor1 != null && descriptor2 != null) {
                    boolean result2 = DuplocatorUtil.match(descriptor1, descriptor2, (AbstractMatchingVisitor)this.myGlobalVisitor, Collections.emptySet(), null);
                    this.myGlobalVisitor.setResult(result2);
                    return;
                }
            }
            if (StructuralSearchProfileBase.this.isStringLiteral(element)) {
                this.visitLiteral(element);
                return;
            }
            if (StructuralSearchProfileBase.canBePatternVariable(element) && this.myGlobalVisitor.getMatchContext().getPattern().isRealTypedVar(element) && !this.shouldIgnoreVarNode(element)) {
                PsiElement matchedElement = this.myGlobalVisitor.getElement();
                PsiElement newElement = SkippingHandler.skipNodeIfNeccessary(matchedElement);
                while (newElement != matchedElement) {
                    matchedElement = newElement;
                    newElement = SkippingHandler.skipNodeIfNeccessary(matchedElement);
                }
                this.myGlobalVisitor.setResult(this.myGlobalVisitor.handleTypedElement(element, matchedElement));
            } else if (element instanceof LeafElement) {
                this.myGlobalVisitor.setResult(element.getText().equals(this.myGlobalVisitor.getElement().getText()));
            } else if (element.getFirstChild() == null && element.getTextLength() == 0) {
                this.myGlobalVisitor.setResult(true);
            } else {
                PsiElement patternChild = element.getFirstChild();
                PsiElement matchedChild = this.myGlobalVisitor.getElement().getFirstChild();
                SsrFilteringNodeIterator patternIterator = new SsrFilteringNodeIterator(patternChild);
                SsrFilteringNodeIterator matchedIterator = new SsrFilteringNodeIterator(matchedChild);
                boolean matched = this.myGlobalVisitor.matchSequentially(patternIterator, matchedIterator);
                this.myGlobalVisitor.setResult(matched);
            }
        }

        private void visitLiteral(PsiElement literal) {
            PsiElement l2 = this.myGlobalVisitor.getElement();
            MatchingHandler handler2 = (MatchingHandler)literal.getUserData(CompiledPattern.HANDLER_KEY);
            if (handler2 instanceof SubstitutionHandler) {
                char c;
                int offset = 0;
                int length = l2.getTextLength();
                String text2 = l2.getText();
                if (length > 2 && ((c = text2.charAt(0)) == '\"' || c == '\'') && text2.charAt(length - 1) == c) {
                    boolean looseMatching = this.myGlobalVisitor.getMatchContext().getOptions().isLooseMatching();
                    if (!looseMatching && c != literal.getText().charAt(0)) {
                        this.myGlobalVisitor.setResult(false);
                        return;
                    }
                    --length;
                    ++offset;
                }
                this.myGlobalVisitor.setResult(((SubstitutionHandler)handler2).handle(l2, offset, length, this.myGlobalVisitor.getMatchContext()));
            } else if (handler2 != null) {
                this.myGlobalVisitor.setResult(handler2.match(literal, l2, this.myGlobalVisitor.getMatchContext()));
            } else {
                this.myGlobalVisitor.setResult(literal.textMatches(l2));
            }
        }
    }

    private class MyCompilingVisitor
    extends PsiRecursiveElementVisitor {
        private final GlobalCompilingVisitor myGlobalVisitor;
        private final PsiElement myTopElement;
        private Pattern[] mySubstitutionPatterns;

        private MyCompilingVisitor(GlobalCompilingVisitor globalVisitor, PsiElement topElement) {
            this.myGlobalVisitor = globalVisitor;
            this.myTopElement = topElement;
        }

        public void visitElement(PsiElement element) {
            this.doVisitElement(element);
            if (StructuralSearchProfileBase.this.isStringLiteral(element)) {
                this.visitLiteral(element);
            }
        }

        private void doVisitElement(PsiElement element) {
            ParserDefinition parserDefinition;
            CompiledPattern pattern = this.myGlobalVisitor.getContext().getPattern();
            if (this.myGlobalVisitor.getCodeBlockLevel() == 0) {
                this.initTopLevelElement(element);
                return;
            }
            if (StructuralSearchProfileBase.canBePatternVariable(element) && pattern.isRealTypedVar(element)) {
                this.myGlobalVisitor.handle(element);
                MatchingHandler handler2 = pattern.getHandler(element);
                handler2.setFilter(new NodeFilter(){

                    @Override
                    public boolean accepts(PsiElement other) {
                        return StructuralSearchProfileBase.canBePatternVariableValue(other);
                    }
                });
                super.visitElement(element);
                return;
            }
            super.visitElement(element);
            if (this.myGlobalVisitor.getContext().getSearchHelper().doOptimizing() && element instanceof LeafElement && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage())) != null) {
                String text2 = element.getText();
                boolean flag = true;
                if (StringUtil.isJavaIdentifier((String)text2) && flag) {
                    this.myGlobalVisitor.processTokenizedName(text2, true, GlobalCompilingVisitor.OccurenceKind.CODE);
                }
            }
        }

        private void visitLiteral(PsiElement literal) {
            String value2 = literal.getText();
            if (StringUtil.isQuotedString((String)value2)) {
                if (this.mySubstitutionPatterns == null) {
                    String[] prefixes = this.myGlobalVisitor.getContext().getPattern().getTypedVarPrefixes();
                    this.mySubstitutionPatterns = this.createPatterns(prefixes);
                }
                for (Pattern substitutionPattern : this.mySubstitutionPatterns) {
                    MatchingHandler handler2 = this.myGlobalVisitor.processPatternStringWithFragments(value2, GlobalCompilingVisitor.OccurenceKind.LITERAL, substitutionPattern);
                    if (handler2 == null) continue;
                    literal.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler2);
                    break;
                }
            }
        }

        private Pattern[] createPatterns(String[] prefixes) {
            Pattern[] patterns = new Pattern[prefixes.length];
            for (int i2 = 0; i2 < prefixes.length; ++i2) {
                String s = StructuralSearchUtil.shieldRegExpMetaChars(prefixes[i2]);
                patterns[i2] = Pattern.compile("\\b(" + s + "\\w+)\\b");
            }
            return patterns;
        }

        private void initTopLevelElement(PsiElement element) {
            CompiledPattern pattern = this.myGlobalVisitor.getContext().getPattern();
            PsiElement newElement = SkippingHandler.skipNodeIfNeccessary(element);
            if (element != newElement && newElement != null) {
                newElement.accept((PsiElementVisitor)this);
                pattern.setHandler(element, new LightTopLevelMatchingHandler(pattern.getHandler(element)));
            } else {
                this.myGlobalVisitor.setCodeBlockLevel(this.myGlobalVisitor.getCodeBlockLevel() + 1);
                for (PsiElement el = element.getFirstChild(); el != null; el = el.getNextSibling()) {
                    if (GlobalCompilingVisitor.getFilter().accepts(el)) {
                        if (!(el instanceof PsiWhiteSpace)) continue;
                        this.myGlobalVisitor.addLexicalNode(el);
                        continue;
                    }
                    el.accept((PsiElementVisitor)this);
                    MatchingHandler matchingHandler = pattern.getHandler(el);
                    pattern.setHandler(el, element == this.myTopElement ? new TopLevelMatchingHandler(matchingHandler) : new LightTopLevelMatchingHandler(matchingHandler));
                }
                this.myGlobalVisitor.setCodeBlockLevel(this.myGlobalVisitor.getCodeBlockLevel() - 1);
                pattern.setHandler(element, new TopLevelMatchingHandler(pattern.getHandler(element)));
            }
        }
    }
}

