/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.strategies.ExprMatchingStrategy;
import org.jetbrains.annotations.Nullable;

public class JavaCompiledPattern
extends CompiledPattern {
    private static final String TYPED_VAR_PREFIX = "__$_";
    private boolean requestsSuperFields;
    private boolean requestsSuperMethods;
    private boolean requestsSuperInners;

    public JavaCompiledPattern() {
        this.setStrategy(ExprMatchingStrategy.getInstance());
    }

    @Override
    public String[] getTypedVarPrefixes() {
        return new String[]{TYPED_VAR_PREFIX};
    }

    @Override
    public boolean isTypedVar(String str) {
        if (str.isEmpty()) {
            return false;
        }
        if (str.charAt(0) == '@') {
            return str.regionMatches(1, TYPED_VAR_PREFIX, 0, TYPED_VAR_PREFIX.length());
        }
        return str.startsWith(TYPED_VAR_PREFIX);
    }

    @Override
    public boolean isToResetHandler(PsiElement element) {
        return !(element instanceof PsiJavaToken) && (!(element instanceof PsiJavaCodeReferenceElement) || !(element.getParent() instanceof PsiAnnotation));
    }

    @Override
    @Nullable
    public String getAlternativeTextToMatch(PsiElement node, String previousText) {
        if (node instanceof PsiJavaCodeReferenceElement || node instanceof PsiClass) {
            PsiElement element;
            PsiElement psiElement = element = node instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)node).resolve() : node;
            if (element instanceof PsiClass) {
                String text2 = ((PsiClass)element).getQualifiedName();
                if (text2 != null && text2.equals(previousText)) {
                    text2 = ((PsiClass)element).getName();
                }
                if (text2 != null) {
                    return text2;
                }
            }
        } else if (node instanceof PsiLiteralExpression) {
            return node.getText();
        }
        return null;
    }

    public boolean isRequestsSuperFields() {
        return this.requestsSuperFields;
    }

    public void setRequestsSuperFields(boolean requestsSuperFields) {
        this.requestsSuperFields = requestsSuperFields;
    }

    public boolean isRequestsSuperInners() {
        return this.requestsSuperInners;
    }

    public void setRequestsSuperInners(boolean requestsSuperInners) {
        this.requestsSuperInners = requestsSuperInners;
    }

    public boolean isRequestsSuperMethods() {
        return this.requestsSuperMethods;
    }

    public void setRequestsSuperMethods(boolean requestsSuperMethods) {
        this.requestsSuperMethods = requestsSuperMethods;
    }
}

