/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.tasks.CommitPlaceholderProvider;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.util.Function;
import com.intellij.util.JdomKt;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskUtil {
    private static Pattern ISO8601_DATE_PATTERN = Pattern.compile("(\\d{4}[/-]\\d{2}[/-]\\d{2})(?:[ T](\\d{2}:\\d{2}:\\d{2})(.\\d{3,})?(?:\\s?([+-]\\d{2}:\\d{2}|[+-]\\d{4}|[+-]\\d{2}|Z))?)?");

    private TaskUtil() {
    }

    public static String formatTask(@NotNull Task task, String format, boolean forCommit) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/tasks/impl/TaskUtil", "formatTask"));
        }
        if (forCommit && task instanceof LocalTask) {
            format = TaskUtil.formatFromExtensions((LocalTask)task, format);
        }
        return format.replace("{id}", task.getPresentableId()).replace("{number}", task.getNumber()).replace("{project}", StringUtil.notNullize((String)task.getProject())).replace("{summary}", task.getSummary());
    }

    private static String formatFromExtensions(@NotNull LocalTask task, String format) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/tasks/impl/TaskUtil", "formatFromExtensions"));
        }
        for (CommitPlaceholderProvider extension : (CommitPlaceholderProvider[])Extensions.getExtensions((ExtensionPointName)CommitPlaceholderProvider.EXTENSION_POINT_NAME)) {
            String[] placeholders;
            for (String placeholder : placeholders = extension.getPlaceholders(task.getRepository())) {
                String value2 = extension.getPlaceholderValue(task, placeholder);
                if (value2 == null) continue;
                format = format.replace("{" + placeholder + "}", value2);
            }
        }
        return format;
    }

    public static String getChangeListComment(Task task) {
        return TaskUtil.getChangeListComment(task, false);
    }

    @Nullable
    public static String getChangeListComment(Task task, boolean forCommit) {
        TaskRepository repository = task.getRepository();
        if (repository == null || !repository.isShouldFormatCommitMessage()) {
            return null;
        }
        return TaskUtil.formatTask(task, repository.getCommitMessageFormat(), forCommit);
    }

    public static String getTrimmedSummary(Task task) {
        String text2 = task.isIssue() ? task.getPresentableId() + ": " + task.getSummary() : task.getSummary();
        return StringUtil.first((String)text2, (int)60, (boolean)true);
    }

    @Nullable
    public static Date parseDate(@NotNull String s) {
        String milliseconds;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/tasks/impl/TaskUtil", "parseDate"));
        }
        Matcher m = ISO8601_DATE_PATTERN.matcher(s);
        if (!m.matches()) {
            return null;
        }
        String datePart = m.group(1).replace('/', '-');
        String timePart = m.group(2);
        if (timePart == null) {
            timePart = "00:00:00";
        }
        milliseconds = (milliseconds = m.group(3)) == null ? "000" : milliseconds.substring(1, 4);
        String timezone = m.group(4);
        if (timezone == null || timezone.equals("Z")) {
            timezone = "+0000";
        } else if (timezone.length() == 3) {
            timezone = timezone + "00";
        } else if (timezone.length() == 6) {
            timezone = timezone.substring(0, 3) + timezone.substring(4, 6);
        }
        String canonicalForm = String.format("%sT%s.%s%s", datePart, timePart, milliseconds, timezone);
        try {
            return DateFormatUtil.getIso8601Format().parse(canonicalForm);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatDate(@NotNull Date date) {
        if (date == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "date", "com/intellij/tasks/impl/TaskUtil", "formatDate"));
        }
        return DateFormatUtil.getIso8601Format().format(date);
    }

    public static boolean tasksEqual(@NotNull Task t1, @NotNull Task t2) {
        if (t1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t1", "com/intellij/tasks/impl/TaskUtil", "tasksEqual"));
        }
        if (t2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t2", "com/intellij/tasks/impl/TaskUtil", "tasksEqual"));
        }
        if (!t1.getId().equals(t2.getId())) {
            return false;
        }
        if (!t1.getSummary().equals(t2.getSummary())) {
            return false;
        }
        if (t1.isClosed() != t2.isClosed()) {
            return false;
        }
        if (t1.isIssue() != t2.isIssue()) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getState(), (Object)t2.getState())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getType(), (Object)t2.getType())) {
            return false;
        }
        if (!Comparing.equal((String)t1.getDescription(), (String)t2.getDescription())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getCreated(), (Object)t2.getCreated())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getUpdated(), (Object)t2.getUpdated())) {
            return false;
        }
        if (!Comparing.equal((String)t1.getIssueUrl(), (String)t2.getIssueUrl())) {
            return false;
        }
        if (!Comparing.equal((Object[])t1.getComments(), (Object[])t2.getComments())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getIcon(), (Object)t2.getIcon())) {
            return false;
        }
        if (!Comparing.equal((String)t1.getCustomIcon(), (String)t2.getCustomIcon())) {
            return false;
        }
        return Comparing.equal((Object)t1.getRepository(), (Object)t2.getRepository());
    }

    public static boolean tasksEqual(@NotNull List<? extends Task> tasks1, @NotNull List<? extends Task> tasks2) {
        if (tasks1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks1", "com/intellij/tasks/impl/TaskUtil", "tasksEqual"));
        }
        if (tasks2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks2", "com/intellij/tasks/impl/TaskUtil", "tasksEqual"));
        }
        if (tasks1.size() != tasks2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < tasks1.size(); ++i2) {
            if (TaskUtil.tasksEqual(tasks1.get(i2), tasks2.get(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean tasksEqual(@NotNull Task[] task1, @NotNull Task[] task2) {
        if (task1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task1", "com/intellij/tasks/impl/TaskUtil", "tasksEqual"));
        }
        if (task2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task2", "com/intellij/tasks/impl/TaskUtil", "tasksEqual"));
        }
        return TaskUtil.tasksEqual(Arrays.asList(task1), Arrays.asList(task2));
    }

    public static void prettyFormatXmlToLog(@NotNull Logger logger, @NotNull Element element) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/tasks/impl/TaskUtil", "prettyFormatXmlToLog"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/tasks/impl/TaskUtil", "prettyFormatXmlToLog"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\n" + JDOMUtil.createOutputter((String)"\n").outputString(element));
        }
    }

    public static void prettyFormatXmlToLog(@NotNull Logger logger, @NotNull InputStream xml) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/tasks/impl/TaskUtil", "prettyFormatXmlToLog"));
        }
        if (xml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xml", "com/intellij/tasks/impl/TaskUtil", "prettyFormatXmlToLog"));
        }
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("\n" + JDOMUtil.createOutputter((String)"\n").outputString(JDOMUtil.loadDocument((InputStream)xml)));
            }
            catch (Exception e) {
                logger.debug((Throwable)e);
            }
        }
    }

    public static void prettyFormatXmlToLog(@NotNull Logger logger, @NotNull String xml) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/tasks/impl/TaskUtil", "prettyFormatXmlToLog"));
        }
        if (xml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xml", "com/intellij/tasks/impl/TaskUtil", "prettyFormatXmlToLog"));
        }
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("\n" + JDOMUtil.createOutputter((String)"\n").outputString(JdomKt.loadElement((CharSequence)xml)));
            }
            catch (Exception e) {
                logger.debug((Throwable)e);
            }
        }
    }

    public static void prettyFormatJsonToLog(@NotNull Logger logger, @NotNull String json) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/tasks/impl/TaskUtil", "prettyFormatJsonToLog"));
        }
        if (json == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "json", "com/intellij/tasks/impl/TaskUtil", "prettyFormatJsonToLog"));
        }
        if (logger.isDebugEnabled()) {
            try {
                Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
                logger.debug("\n" + gson2.toJson((JsonElement)gson2.fromJson(json, JsonElement.class)));
            }
            catch (JsonSyntaxException e) {
                logger.debug("Malformed JSON\n" + json);
            }
        }
    }

    public static void prettyFormatJsonToLog(@NotNull Logger logger, @NotNull JsonElement json) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/tasks/impl/TaskUtil", "prettyFormatJsonToLog"));
        }
        if (json == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "json", "com/intellij/tasks/impl/TaskUtil", "prettyFormatJsonToLog"));
        }
        if (logger.isDebugEnabled()) {
            try {
                Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
                logger.debug("\n" + gson2.toJson(json));
            }
            catch (JsonSyntaxException e) {
                logger.debug("Malformed JSON\n" + json);
            }
        }
    }

    @NotNull
    public static String encodeUrl(@NotNull String s) {
        String string;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/tasks/impl/TaskUtil", "encodeUrl"));
        }
        try {
            string = URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is not supported");
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/impl/TaskUtil", "encodeUrl"));
        }
        return string;
    }

    public static List<Task> filterTasks(String pattern, List<Task> tasks) {
        com.intellij.util.text.Matcher matcher = TaskUtil.getMatcher(pattern);
        return ContainerUtil.mapNotNull(tasks, (Function)((NullableFunction)task -> matcher.matches(task.getPresentableId()) || matcher.matches(task.getSummary()) ? task : null));
    }

    private static com.intellij.util.text.Matcher getMatcher(String pattern) {
        StringTokenizer tokenizer = new StringTokenizer(pattern, " ");
        StringBuilder builder = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            builder.append('*');
            builder.append(word);
            builder.append("* ");
        }
        return NameUtil.buildMatcher((String)builder.toString(), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
    }
}

