/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.terminal.JBTerminalSchemeColorPalette;
import com.intellij.terminal.TerminalSettingsListener;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.messages.MessageBusConnection;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.emulator.ColorPalette;
import com.jediterm.terminal.ui.settings.DefaultTabbedSettingsProvider;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.KeyStroke;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTerminalSystemSettingsProviderBase
extends DefaultTabbedSettingsProvider
implements Disposable {
    protected final MyColorSchemeDelegate myColorScheme;
    private Set<TerminalSettingsListener> myListeners = new HashSet();

    public JBTerminalSystemSettingsProviderBase() {
        this.myColorScheme = JBTerminalSystemSettingsProviderBase.createBoundColorSchemeDelegate(null);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> {
            int size = JBTerminalSystemSettingsProviderBase.consoleFontSize(this.myColorScheme);
            if (this.myColorScheme.getConsoleFontSize() != size) {
                this.myColorScheme.setConsoleFontSize(size);
                this.fireFontChanged();
            }
        });
        connection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme2) {
                JBTerminalSystemSettingsProviderBase.this.myColorScheme.updateGlobalScheme(scheme2);
                JBTerminalSystemSettingsProviderBase.this.fireFontChanged();
            }
        });
    }

    public KeyStroke[] getCopyKeyStrokes() {
        return this.getKeyStrokesByActionId("$Copy");
    }

    public KeyStroke[] getPasteKeyStrokes() {
        return this.getKeyStrokesByActionId("$Paste");
    }

    public KeyStroke[] getNextTabKeyStrokes() {
        return this.getKeyStrokesByActionId("NextTab");
    }

    public KeyStroke[] getPreviousTabKeyStrokes() {
        return this.getKeyStrokesByActionId("PreviousTab");
    }

    public KeyStroke[] getFindKeyStrokes() {
        return this.getKeyStrokesByActionId("Find");
    }

    public ColorPalette getTerminalColorPalette() {
        return new JBTerminalSchemeColorPalette(this.myColorScheme);
    }

    private KeyStroke[] getKeyStrokesByActionId(String actionId) {
        Shortcut[] shortcuts;
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>();
        for (Shortcut sc : shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)actionId).getShortcuts()) {
            if (!(sc instanceof KeyboardShortcut)) continue;
            KeyStroke ks = ((KeyboardShortcut)sc).getFirstKeyStroke();
            keyStrokes.add(ks);
        }
        return keyStrokes.toArray(new KeyStroke[keyStrokes.size()]);
    }

    public void dispose() {
    }

    public void addListener(TerminalSettingsListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(TerminalSettingsListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void fireFontChanged() {
        for (TerminalSettingsListener l : this.myListeners) {
            l.fontChanged();
        }
    }

    protected static int consoleFontSize(MyColorSchemeDelegate colorScheme) {
        int size = UISettings.getInstance().getPresentationMode() ? UISettings.getInstance().getPresentationModeFontSize() : colorScheme.getGlobal().getConsoleFontSize();
        return size;
    }

    @NotNull
    private static MyColorSchemeDelegate createBoundColorSchemeDelegate(@Nullable EditorColorsScheme customGlobalScheme) {
        MyColorSchemeDelegate myColorSchemeDelegate = new MyColorSchemeDelegate(customGlobalScheme);
        if (myColorSchemeDelegate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/terminal/JBTerminalSystemSettingsProviderBase", "createBoundColorSchemeDelegate"));
        }
        return myColorSchemeDelegate;
    }

    public EditorColorsScheme getColorScheme() {
        return this.myColorScheme;
    }

    public float getLineSpace() {
        return this.myColorScheme.getConsoleLineSpacing();
    }

    public TextStyle getSelectionColor() {
        return new TextStyle(TerminalColor.awt((Color)this.myColorScheme.getColor(EditorColors.SELECTION_FOREGROUND_COLOR)), TerminalColor.awt((Color)this.myColorScheme.getColor(EditorColors.SELECTION_BACKGROUND_COLOR)));
    }

    public TextStyle getFoundPatternColor() {
        return new TextStyle(TerminalColor.awt((Color)this.myColorScheme.getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES).getForegroundColor()), TerminalColor.awt((Color)this.myColorScheme.getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES).getBackgroundColor()));
    }

    public TextStyle getHyperlinkColor() {
        return new TextStyle(TerminalColor.awt((Color)this.myColorScheme.getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR).getForegroundColor()), TerminalColor.awt((Color)this.myColorScheme.getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR).getBackgroundColor()));
    }

    public TextStyle getDefaultStyle() {
        return new TextStyle(TerminalColor.awt((Color)this.myColorScheme.getDefaultForeground()), TerminalColor.awt((Color)this.myColorScheme.getDefaultBackground()));
    }

    public Font getTerminalFont() {
        Font normalFont = Font.decode(this.getFontName());
        if (normalFont == null) {
            normalFont = super.getTerminalFont();
        }
        normalFont = normalFont.deriveFont(this.getTerminalFontSize());
        return normalFont;
    }

    public String getFontName() {
        List fonts = this.myColorScheme.getConsoleFontPreferences().getEffectiveFontFamilies();
        if (fonts.size() > 0) {
            return (String)fonts.get(0);
        }
        return "Monospaced-14";
    }

    public float getTerminalFontSize() {
        return this.myColorScheme.getConsoleFontSize();
    }

    public boolean useAntialiasing() {
        return true;
    }

    public int caretBlinkingMs() {
        if (!EditorSettingsExternalizable.getInstance().isBlinkCaret()) {
            return 0;
        }
        return EditorSettingsExternalizable.getInstance().getBlinkPeriod();
    }

    public int getBufferMaxLinesCount() {
        int linesCount = Registry.get((String)"terminal.buffer.max.lines.count").asInteger();
        if (linesCount > 0) {
            return linesCount;
        }
        return super.getBufferMaxLinesCount();
    }

    public boolean overrideIdeShortcuts() {
        return false;
    }

    public boolean useInverseSelectionColor() {
        return false;
    }

    protected static class MyColorSchemeDelegate
    implements EditorColorsScheme {
        private final FontPreferencesImpl myFontPreferences = new FontPreferencesImpl();
        private final HashMap<TextAttributesKey, TextAttributes> myOwnAttributes = new HashMap();
        private final HashMap<ColorKey, Color> myOwnColors = new HashMap();
        private Map<EditorFontType, Font> myFontsMap = null;
        private String myFaceName = null;
        private EditorColorsScheme myGlobalScheme;
        private int myConsoleFontSize;

        protected MyColorSchemeDelegate(@Nullable EditorColorsScheme globalScheme) {
            this.updateGlobalScheme(globalScheme);
            this.myConsoleFontSize = JBTerminalSystemSettingsProviderBase.consoleFontSize(this);
            this.initFonts();
        }

        private EditorColorsScheme getGlobal() {
            return this.myGlobalScheme;
        }

        @NotNull
        public String getName() {
            String string = this.getGlobal().getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/terminal/JBTerminalSystemSettingsProviderBase$MyColorSchemeDelegate", "getName"));
            }
            return string;
        }

        protected void initFonts() {
            String consoleFontName = this.getConsoleFontName();
            int consoleFontSize = this.getConsoleFontSize();
            this.myFontPreferences.clear();
            this.myFontPreferences.register(consoleFontName, consoleFontSize);
            this.myFontsMap = new EnumMap<EditorFontType, Font>(EditorFontType.class);
            Font plainFont = new Font(consoleFontName, 0, consoleFontSize);
            Font boldFont = new Font(consoleFontName, 1, consoleFontSize);
            Font italicFont = new Font(consoleFontName, 2, consoleFontSize);
            Font boldItalicFont = new Font(consoleFontName, 3, consoleFontSize);
            this.myFontsMap.put(EditorFontType.PLAIN, plainFont);
            this.myFontsMap.put(EditorFontType.BOLD, boldFont);
            this.myFontsMap.put(EditorFontType.ITALIC, italicFont);
            this.myFontsMap.put(EditorFontType.BOLD_ITALIC, boldItalicFont);
        }

        public void setName(String name2) {
            this.getGlobal().setName(name2);
        }

        public TextAttributes getAttributes(TextAttributesKey key2) {
            if (this.myOwnAttributes.containsKey((Object)key2)) {
                return (TextAttributes)this.myOwnAttributes.get((Object)key2);
            }
            return this.getGlobal().getAttributes(key2);
        }

        public void setAttributes(@NotNull TextAttributesKey key2, TextAttributes attributes) {
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/terminal/JBTerminalSystemSettingsProviderBase$MyColorSchemeDelegate", "setAttributes"));
            }
            this.myOwnAttributes.put((Object)key2, (Object)attributes);
        }

        @NotNull
        public Color getDefaultBackground() {
            Color color = this.getGlobal().getColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY);
            Color color2 = color != null ? color : this.getGlobal().getDefaultBackground();
            if (color2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/terminal/JBTerminalSystemSettingsProviderBase$MyColorSchemeDelegate", "getDefaultBackground"));
            }
            return color2;
        }

        @NotNull
        public Color getDefaultForeground() {
            Color foregroundColor = this.getGlobal().getAttributes(ConsoleViewContentType.NORMAL_OUTPUT_KEY).getForegroundColor();
            Color color = foregroundColor != null ? foregroundColor : this.getGlobal().getDefaultForeground();
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/terminal/JBTerminalSystemSettingsProviderBase$MyColorSchemeDelegate", "getDefaultForeground"));
            }
            return color;
        }

        public Color getColor(ColorKey key2) {
            if (this.myOwnColors.containsKey((Object)key2)) {
                return (Color)this.myOwnColors.get((Object)key2);
            }
            return this.getGlobal().getColor(key2);
        }

        public void setColor(ColorKey key2, Color color) {
            this.myOwnColors.put((Object)key2, (Object)color);
        }

        @NotNull
        public FontPreferences getFontPreferences() {
            FontPreferences fontPreferences = this.myGlobalScheme.getFontPreferences();
            if (fontPreferences == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/terminal/JBTerminalSystemSettingsProviderBase$MyColorSchemeDelegate", "getFontPreferences"));
            }
            return fontPreferences;
        }

        public void setFontPreferences(@NotNull FontPreferences preferences) {
            if (preferences == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/terminal/JBTerminalSystemSettingsProviderBase$MyColorSchemeDelegate", "setFontPreferences"));
            }
            throw new IllegalStateException();
        }

        public int getEditorFontSize() {
            return this.getGlobal().getEditorFontSize();
        }

        public void setEditorFontSize(int fontSize) {
        }

        public FontSize getQuickDocFontSize() {
            return this.myGlobalScheme.getQuickDocFontSize();
        }

        public void setQuickDocFontSize(@NotNull FontSize fontSize) {
            if (fontSize == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontSize", "com/intellij/terminal/JBTerminalSystemSettingsProviderBase$MyColorSchemeDelegate", "setQuickDocFontSize"));
            }
            this.myGlobalScheme.setQuickDocFontSize(fontSize);
        }

        public String getEditorFontName() {
            return this.getGlobal().getEditorFontName();
        }

        public void setEditorFontName(String fontName) {
            throw new IllegalStateException();
        }

        public Font getFont(EditorFontType key2) {
            Font font;
            if (this.myFontsMap != null && (font = this.myFontsMap.get(key2)) != null) {
                return font;
            }
            return this.getGlobal().getFont(key2);
        }

        public void setFont(EditorFontType key2, Font font) {
            if (this.myFontsMap == null) {
                this.initFonts();
            }
            this.myFontsMap.put(key2, font);
        }

        public float getLineSpacing() {
            return this.getGlobal().getLineSpacing();
        }

        public void setLineSpacing(float lineSpacing) {
            this.getGlobal().setLineSpacing(lineSpacing);
        }

        @Nullable
        public Object clone() {
            return null;
        }

        public void readExternal(Element element) {
        }

        public void updateGlobalScheme(EditorColorsScheme scheme2) {
            this.myFontsMap = null;
            this.myGlobalScheme = scheme2 == null ? EditorColorsManager.getInstance().getGlobalScheme() : scheme2;
        }

        @NotNull
        public FontPreferences getConsoleFontPreferences() {
            FontPreferencesImpl fontPreferencesImpl = this.myFontPreferences;
            if (fontPreferencesImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/terminal/JBTerminalSystemSettingsProviderBase$MyColorSchemeDelegate", "getConsoleFontPreferences"));
            }
            return fontPreferencesImpl;
        }

        public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
            if (preferences == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/terminal/JBTerminalSystemSettingsProviderBase$MyColorSchemeDelegate", "setConsoleFontPreferences"));
            }
            preferences.copyTo((FontPreferences)this.myFontPreferences);
            this.initFonts();
        }

        public String getConsoleFontName() {
            if (this.myFaceName == null) {
                return this.getGlobal().getConsoleFontName();
            }
            return this.myFaceName;
        }

        public void setConsoleFontName(String fontName) {
            this.myFaceName = fontName;
            this.initFonts();
        }

        public int getConsoleFontSize() {
            if (this.myConsoleFontSize == -1) {
                return this.getGlobal().getConsoleFontSize();
            }
            return this.myConsoleFontSize;
        }

        public void setConsoleFontSize(int fontSize) {
            this.myConsoleFontSize = fontSize;
            this.initFonts();
        }

        public float getConsoleLineSpacing() {
            return this.getGlobal().getConsoleLineSpacing();
        }

        public void setConsoleLineSpacing(float lineSpacing) {
            this.getGlobal().setConsoleLineSpacing(lineSpacing);
        }

        @NotNull
        public Properties getMetaProperties() {
            Properties properties = this.myGlobalScheme.getMetaProperties();
            if (properties == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/terminal/JBTerminalSystemSettingsProviderBase$MyColorSchemeDelegate", "getMetaProperties"));
            }
            return properties;
        }
    }
}

