/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.testFramework.fixtures.impl.GlobalInspectionContextForTests;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.io.CharArrayReader;
import java.io.File;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class InspectionTestUtil {
    private InspectionTestUtil() {
    }

    protected static void compareWithExpected(Document expectedDoc, Document doc, boolean checkRange) throws Exception {
        ArrayList expectedProblems = new ArrayList(expectedDoc.getRootElement().getChildren("problem"));
        ArrayList reportedProblems = new ArrayList(doc.getRootElement().getChildren("problem"));
        Element[] expectedArray = expectedProblems.toArray(new Element[expectedProblems.size()]);
        boolean failed = false;
        block0: for (Element expectedProblem : expectedArray) {
            Element[] reportedArrayed;
            for (Element reportedProblem : reportedArrayed = reportedProblems.toArray(new Element[reportedProblems.size()])) {
                if (!InspectionTestUtil.compareProblemWithExpected(reportedProblem, expectedProblem, checkRange)) continue;
                expectedProblems.remove(expectedProblem);
                reportedProblems.remove(reportedProblem);
                continue block0;
            }
            Document missing = new Document(expectedProblem.clone());
            System.out.println("The following haven't been reported as expected: " + JDOMUtil.writeDocument((Document)missing, (String)"\n"));
            failed = true;
        }
        for (Element reportedProblem : reportedProblems) {
            Document extra = new Document(reportedProblem.clone());
            System.out.println("The following has been unexpectedly reported: " + JDOMUtil.writeDocument((Document)extra, (String)"\n"));
            failed = true;
        }
        Assert.assertFalse((boolean)failed);
    }

    static boolean compareProblemWithExpected(Element reportedProblem, Element expectedProblem, boolean checkRange) throws Exception {
        if (!InspectionTestUtil.compareFiles(reportedProblem, expectedProblem)) {
            return false;
        }
        if (!InspectionTestUtil.compareLines(reportedProblem, expectedProblem)) {
            return false;
        }
        if (!InspectionTestUtil.compareDescriptions(reportedProblem, expectedProblem)) {
            return false;
        }
        return !checkRange || InspectionTestUtil.compareTextRange(reportedProblem, expectedProblem);
    }

    static boolean compareTextRange(Element reportedProblem, Element expectedProblem) {
        Element reportedTextRange = reportedProblem.getChild("entry_point");
        if (reportedTextRange == null) {
            return false;
        }
        Element expectedTextRange = expectedProblem.getChild("entry_point");
        return Comparing.equal((String)reportedTextRange.getAttributeValue("TYPE"), (String)expectedTextRange.getAttributeValue("TYPE")) && Comparing.equal((String)reportedTextRange.getAttributeValue("FQNAME"), (String)expectedTextRange.getAttributeValue("FQNAME"));
    }

    static boolean compareDescriptions(Element reportedProblem, Element expectedProblem) throws Exception {
        String reportedDescription;
        String expectedDescription = expectedProblem.getChildText("description");
        if (expectedDescription.equals(reportedDescription = reportedProblem.getChildText("description"))) {
            return true;
        }
        StreamTokenizer tokenizer = new StreamTokenizer(new CharArrayReader(expectedDescription.toCharArray()));
        tokenizer.quoteChar(39);
        int idx = 0;
        while (tokenizer.nextToken() != -1) {
            String word;
            if (tokenizer.sval != null) {
                word = tokenizer.sval;
            } else {
                if (tokenizer.ttype != -2) continue;
                word = Double.toString(tokenizer.nval);
            }
            idx = reportedDescription.indexOf(word, idx);
            if (idx == -1) {
                return false;
            }
            idx += word.length();
        }
        return true;
    }

    static boolean compareLines(Element reportedProblem, Element expectedProblem) {
        return Comparing.equal((String)reportedProblem.getChildText("line"), (String)expectedProblem.getChildText("line"));
    }

    static boolean compareFiles(Element reportedProblem, Element expectedProblem) {
        String reportedFileName = reportedProblem.getChildText("file");
        if (reportedFileName == null) {
            return true;
        }
        File reportedFile = new File(reportedFileName);
        return Comparing.equal((String)reportedFile.getName(), (String)expectedProblem.getChildText("file"));
    }

    public static void compareToolResults(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper, boolean checkRange, @NotNull String testDir) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/testFramework/InspectionTestUtil", "compareToolResults"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/testFramework/InspectionTestUtil", "compareToolResults"));
        }
        if (testDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testDir", "com/intellij/testFramework/InspectionTestUtil", "compareToolResults"));
        }
        InspectionTestUtil.compareToolResults(context, checkRange, testDir, Collections.singletonList(toolWrapper));
    }

    static void compareToolResults(@NotNull GlobalInspectionContextImpl context, boolean checkRange, @NotNull String testDir, @NotNull Collection<? extends InspectionToolWrapper> toolWrappers) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/testFramework/InspectionTestUtil", "compareToolResults"));
        }
        if (testDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testDir", "com/intellij/testFramework/InspectionTestUtil", "compareToolResults"));
        }
        if (toolWrappers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrappers", "com/intellij/testFramework/InspectionTestUtil", "compareToolResults"));
        }
        Element root = new Element("problems");
        for (InspectionToolWrapper inspectionToolWrapper : toolWrappers) {
            InspectionToolPresentation presentation = context.getPresentation(inspectionToolWrapper);
            presentation.updateContent();
            presentation.exportResults(root, x -> false, x -> false);
        }
        try {
            File file2 = new File(testDir + "/expected.xml");
            InspectionTestUtil.compareWithExpected(JDOMUtil.loadDocument((File)file2), new Document(root), checkRange);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void runTool(@NotNull InspectionToolWrapper toolWrapper, @NotNull AnalysisScope scope, @NotNull GlobalInspectionContextForTests globalContext) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/testFramework/InspectionTestUtil", "runTool"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/testFramework/InspectionTestUtil", "runTool"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/testFramework/InspectionTestUtil", "runTool"));
        }
        String shortName = toolWrapper.getShortName();
        HighlightDisplayKey key2 = HighlightDisplayKey.find((String)shortName);
        if (key2 == null) {
            HighlightDisplayKey.register((String)shortName);
        }
        globalContext.doInspections(scope);
        do {
            UIUtil.dispatchAllInvocationEvents();
        } while (!globalContext.isFinished());
    }

    @NotNull
    public static <T extends InspectionProfileEntry> List<InspectionProfileEntry> instantiateTools(@NotNull Collection<Class<? extends T>> inspections) {
        if (inspections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspections", "com/intellij/testFramework/InspectionTestUtil", "instantiateTools"));
        }
        Set classNames = JBIterable.from(inspections).transform(Class::getName).toSet();
        List tools = JBIterable.of((Object[])new ExtensionPointName[]{LocalInspectionEP.LOCAL_INSPECTION, InspectionEP.GLOBAL_INSPECTION}).flatten(o -> Arrays.asList(o.getExtensions())).filter(o -> classNames.contains(o.implementationClass)).transform(InspectionEP::instantiateTool).toList();
        if (tools.size() != classNames.size()) {
            TreeSet missing = ContainerUtil.newTreeSet((Iterable)classNames);
            missing.removeAll(JBIterable.from((Iterable)tools).transform(o -> o.getClass().getName()).toSet());
            throw new RuntimeException("Unregistered inspections requested: " + missing);
        }
        List list2 = tools;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/InspectionTestUtil", "instantiateTools"));
        }
        return list2;
    }
}

