/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.ref.DebugReflectionUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeakHunter {
    public static void checkProjectLeak() throws Exception {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, project2 -> !project2.isDefault() && !project2.isLight());
    }

    public static void checkNonDefaultProjectLeak() throws Exception {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, project2 -> !project2.isDefault());
    }

    public static void checkLeak(@NotNull Object root, @NotNull Class<?> suspectClass) throws AssertionError {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/testFramework/LeakHunter", "checkLeak"));
        }
        if (suspectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspectClass", "com/intellij/testFramework/LeakHunter", "checkLeak"));
        }
        LeakHunter.checkLeak(root, suspectClass, null);
    }

    public static <T> void checkLeak(@NotNull Collection<Object> roots, @NotNull Class<T> suspectClass, @Nullable Condition<? super T> isReallyLeak) throws AssertionError {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/testFramework/LeakHunter", "checkLeak"));
        }
        if (suspectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspectClass", "com/intellij/testFramework/LeakHunter", "checkLeak"));
        }
        LeakHunter.processLeaks(roots, suspectClass, isReallyLeak, (leaked, backLink) -> {
            String place = leaked instanceof Project ? PlatformTestCase.getCreationPlace((Project)leaked) : "";
            System.out.println("Found leaked " + leaked.getClass() + ": " + leaked + "; hash: " + System.identityHashCode(leaked) + "; place: " + place);
            System.out.println(backLink);
            System.out.println(";-----");
            throw new AssertionError();
        });
    }

    static <T> void processLeaks(@NotNull Collection<Object> roots, @NotNull Class<T> suspectClass, @Nullable Condition<? super T> isReallyLeak, @NotNull PairProcessor<? super T, Object> processor2) throws AssertionError {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/testFramework/LeakHunter", "processLeaks"));
        }
        if (suspectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspectClass", "com/intellij/testFramework/LeakHunter", "processLeaks"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/testFramework/LeakHunter", "processLeaks"));
        }
        if (SwingUtilities.isEventDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        } else {
            UIUtil.pump();
        }
        PersistentEnumeratorBase.clearCacheForTests();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/testFramework/LeakHunter", "lambda$processLeaks$4"));
            }
            if (suspectClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspectClass", "com/intellij/testFramework/LeakHunter", "lambda$processLeaks$4"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/testFramework/LeakHunter", "lambda$processLeaks$4"));
            }
            DebugReflectionUtil.walkObjects((int)10000, (Collection)roots, (Class)suspectClass, (Condition)Conditions.alwaysTrue(), (value2, backLink) -> {
                if (processor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/testFramework/LeakHunter", "lambda$null$3"));
                }
                Object leaked = value2;
                if (isReallyLeak == null || isReallyLeak.value(leaked)) {
                    return processor2.process(leaked, backLink);
                }
                return true;
            });
        });
    }

    public static <T> void checkLeak(@NotNull Object root, @NotNull Class<T> suspectClass, @Nullable Condition<? super T> isReallyLeak) throws AssertionError {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/testFramework/LeakHunter", "checkLeak"));
        }
        if (suspectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspectClass", "com/intellij/testFramework/LeakHunter", "checkLeak"));
        }
        LeakHunter.checkLeak(Collections.singletonList(root), suspectClass, isReallyLeak);
    }

    @NotNull
    public static List<Object> allRoots() {
        ClassLoader classLoader = LeakHunter.class.getClassLoader();
        Vector allLoadedClasses = (Vector)ReflectionUtil.getField(classLoader.getClass(), (Object)classLoader, Vector.class, (String)"classes");
        List<Object> list2 = Arrays.asList(ApplicationManager.getApplication(), Disposer.getTree(), IdeEventQueue.getInstance(), LaterInvocator.getLaterInvocatorQueue(), ThreadTracker.getThreads(), allLoadedClasses);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LeakHunter", "allRoots"));
        }
        return list2;
    }
}

