/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.IdeaTestFixture;
import com.intellij.util.ThrowableRunnable;
import org.junit.Assert;

public class BaseFixture
implements IdeaTestFixture {
    private boolean myInitialized;
    private boolean myDisposed;
    private final Disposable myTestRootDisposable = Disposer.newDisposable();

    @Override
    public void setUp() throws Exception {
        Assert.assertFalse((String)"setUp() already has been called", (boolean)this.myInitialized);
        Assert.assertFalse((String)"tearDown() already has been called", (boolean)this.myDisposed);
        this.myInitialized = true;
    }

    @Override
    public void tearDown() throws Exception {
        Assert.assertTrue((String)"setUp() has not been called", (boolean)this.myInitialized);
        Assert.assertFalse((String)"tearDown() already has been called", (boolean)this.myDisposed);
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> Disposer.dispose((Disposable)this.myTestRootDisposable)));
        this.myDisposed = true;
        this.resetClassFields(this.getClass());
    }

    private void resetClassFields(Class<?> aClass) {
        try {
            UsefulTestCase.clearDeclaredFields(this, aClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (aClass != BaseFixture.class) {
            this.resetClassFields(aClass.getSuperclass());
        }
    }

    public final Disposable getTestRootDisposable() {
        return this.myTestRootDisposable;
    }
}

