/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration.createTest;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Template;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.TestIntegrationUtils;
import com.intellij.testIntegration.createTest.CreateTestDialog;
import com.intellij.testIntegration.createTest.TestGenerator;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTestGenerator
implements TestGenerator {
    @Override
    public PsiElement generateTest(final Project project2, final CreateTestDialog d) {
        return (PsiElement)PostprocessReformattingAspect.getInstance(project2).postponeFormattingInside(() -> (PsiElement)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiElement>(){

            public PsiElement compute() {
                try {
                    IdeDocumentHistory.getInstance(project2).includeCurrentPlaceAsChangePlace();
                    PsiClass targetClass = JavaTestGenerator.createTestClass(d);
                    if (targetClass == null) {
                        return null;
                    }
                    TestFramework frameworkDescriptor = d.getSelectedTestFrameworkDescriptor();
                    String defaultSuperClass = frameworkDescriptor.getDefaultSuperClass();
                    String superClassName = d.getSuperClassName();
                    if (!Comparing.strEqual((String)superClassName, (String)defaultSuperClass)) {
                        JavaTestGenerator.addSuperClass(targetClass, project2, superClassName);
                    }
                    Editor editor = CodeInsightUtil.positionCursorAtLBrace(project2, targetClass.getContainingFile(), targetClass);
                    JavaTestGenerator.addTestMethods(editor, targetClass, d.getTargetClass(), frameworkDescriptor, d.getSelectedMethods(), d.shouldGeneratedBefore(), d.shouldGeneratedAfter());
                    return targetClass;
                }
                catch (IncorrectOperationException e) {
                    JavaTestGenerator.showErrorLater(project2, d.getClassName());
                    return null;
                }
            }
        }));
    }

    @Nullable
    private static PsiClass createTestClass(CreateTestDialog d) {
        PsiClass classFromTemplate;
        TestFramework testFrameworkDescriptor = d.getSelectedTestFrameworkDescriptor();
        FileTemplateDescriptor fileTemplateDescriptor = TestIntegrationUtils.MethodKind.TEST_CLASS.getFileTemplateDescriptor(testFrameworkDescriptor);
        PsiDirectory targetDirectory = d.getTargetDirectory();
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(targetDirectory);
        if (aPackage != null) {
            GlobalSearchScope scope = GlobalSearchScopesCore.directoryScope((PsiDirectory)targetDirectory, (boolean)false);
            PsiClass[] classes2 = aPackage.findClassByShortName(d.getClassName(), scope);
            if (classes2.length > 0) {
                if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)classes2[0])) {
                    return null;
                }
                return classes2[0];
            }
        }
        if (fileTemplateDescriptor != null && (classFromTemplate = JavaTestGenerator.createTestClassFromCodeTemplate(d, fileTemplateDescriptor, targetDirectory)) != null) {
            return classFromTemplate;
        }
        return JavaDirectoryService.getInstance().createClass(targetDirectory, d.getClassName());
    }

    private static PsiClass createTestClassFromCodeTemplate(CreateTestDialog d, FileTemplateDescriptor fileTemplateDescriptor, PsiDirectory targetDirectory) {
        String templateName = fileTemplateDescriptor.getFileName();
        FileTemplate fileTemplate = FileTemplateManager.getInstance(targetDirectory.getProject()).getCodeTemplate(templateName);
        Properties defaultProperties = FileTemplateManager.getInstance(targetDirectory.getProject()).getDefaultProperties();
        Properties properties = new Properties(defaultProperties);
        properties.setProperty("NAME", d.getClassName());
        PsiClass targetClass = d.getTargetClass();
        if (targetClass != null && targetClass.isValid()) {
            properties.setProperty("CLASS_NAME", targetClass.getQualifiedName());
        }
        try {
            PsiElement psiElement = FileTemplateUtil.createFromTemplate(fileTemplate, templateName, properties, targetDirectory);
            if (psiElement instanceof PsiClass) {
                return (PsiClass)psiElement;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void addSuperClass(PsiClass targetClass, Project project2, String superClassName) throws IncorrectOperationException {
        if (superClassName == null) {
            return;
        }
        PsiReferenceList extendsList = targetClass.getExtendsList();
        if (extendsList == null) {
            return;
        }
        PsiElementFactory ef = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiClass superClass = JavaTestGenerator.findClass(project2, superClassName);
        PsiJavaCodeReferenceElement superClassRef = superClass != null ? ef.createClassReferenceElement(superClass) : ef.createFQClassNameReferenceElement(superClassName, GlobalSearchScope.allScope((Project)project2));
        PsiJavaCodeReferenceElement[] referenceElements = extendsList.getReferenceElements();
        if (referenceElements.length == 0) {
            extendsList.add((PsiElement)superClassRef);
        } else {
            referenceElements[0].replace((PsiElement)superClassRef);
        }
    }

    @Nullable
    private static PsiClass findClass(Project project2, String fqName) {
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project2);
        return JavaPsiFacade.getInstance((Project)project2).findClass(fqName, scope);
    }

    public static void addTestMethods(Editor editor, PsiClass targetClass, TestFramework descriptor, Collection<MemberInfo> methods, boolean generateBefore, boolean generateAfter) throws IncorrectOperationException {
        JavaTestGenerator.addTestMethods(editor, targetClass, null, descriptor, methods, generateBefore, generateAfter);
    }

    public static void addTestMethods(Editor editor, PsiClass targetClass, @Nullable PsiClass sourceClass, TestFramework descriptor, Collection<MemberInfo> methods, boolean generateBefore, boolean generateAfter) throws IncorrectOperationException {
        HashSet<String> existingNames = new HashSet<String>();
        PsiMethod anchor = null;
        if (generateBefore && descriptor.findSetUpMethod((PsiElement)targetClass) == null) {
            anchor = JavaTestGenerator.generateMethod(TestIntegrationUtils.MethodKind.SET_UP, descriptor, targetClass, sourceClass, editor, null, existingNames, null);
        }
        if (generateAfter && descriptor.findTearDownMethod((PsiElement)targetClass) == null) {
            anchor = JavaTestGenerator.generateMethod(TestIntegrationUtils.MethodKind.TEAR_DOWN, descriptor, targetClass, sourceClass, editor, null, existingNames, anchor);
        }
        Template template = TestIntegrationUtils.createTestMethodTemplate(TestIntegrationUtils.MethodKind.TEST, descriptor, targetClass, sourceClass, null, true, existingNames);
        JVMElementFactory elementFactory = JVMElementFactories.getFactory((Language)targetClass.getLanguage(), (Project)targetClass.getProject());
        String prefix = elementFactory != null ? elementFactory.createMethodFromText(template.getTemplateText(), (PsiElement)targetClass).getName() : "";
        existingNames.addAll(ContainerUtil.map((Object[])targetClass.getMethods(), method -> StringUtil.decapitalize((String)StringUtil.trimStart((String)method.getName(), (String)prefix))));
        for (MemberInfo m : methods) {
            anchor = JavaTestGenerator.generateMethod(TestIntegrationUtils.MethodKind.TEST, descriptor, targetClass, sourceClass, editor, ((PsiMember)m.getMember()).getName(), existingNames, anchor);
        }
    }

    private static void showErrorLater(Project project2, String targetClassName) {
        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project2, (String)CodeInsightBundle.message((String)"intention.error.cannot.create.class.message", (Object[])new Object[]{targetClassName}), (String)CodeInsightBundle.message((String)"intention.error.cannot.create.class.title", (Object[])new Object[0])));
    }

    private static PsiMethod generateMethod(@NotNull TestIntegrationUtils.MethodKind methodKind, TestFramework descriptor, PsiClass targetClass, @Nullable PsiClass sourceClass, Editor editor, @Nullable String name2, Set<String> existingNames, PsiMethod anchor) {
        if (methodKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodKind", "com/intellij/testIntegration/createTest/JavaTestGenerator", "generateMethod"));
        }
        PsiMethod method = (PsiMethod)targetClass.addAfter((PsiElement)TestIntegrationUtils.createDummyMethod((PsiElement)targetClass), (PsiElement)anchor);
        PsiDocumentManager.getInstance((Project)targetClass.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        TestIntegrationUtils.runTestMethodTemplate(methodKind, descriptor, editor, targetClass, sourceClass, method, name2, true, existingNames);
        return method;
    }

    @Override
    public String toString() {
        return CodeInsightBundle.message((String)"intention.create.test.dialog.java", (Object[])new Object[0]);
    }
}

