/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.util.concurrency.Semaphore;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractToolBeforeRunTask<ToolBeforeRunTask extends AbstractToolBeforeRunTask, T extends Tool>
extends BeforeRunTask<ToolBeforeRunTask> {
    @NonNls
    private static final String ACTION_ID_ATTRIBUTE = "actionId";
    private static final Logger LOG = Logger.getInstance(AbstractToolBeforeRunTask.class);
    protected String myToolActionId;

    public AbstractToolBeforeRunTask(Key<ToolBeforeRunTask> providerId) {
        super(providerId);
    }

    @Nullable
    public String getToolActionId() {
        return this.myToolActionId;
    }

    public void writeExternal(Element element) {
        super.writeExternal(element);
        if (this.myToolActionId != null) {
            element.setAttribute(ACTION_ID_ATTRIBUTE, this.myToolActionId);
        }
    }

    public void readExternal(Element element) {
        super.readExternal(element);
        this.myToolActionId = element.getAttributeValue(ACTION_ID_ATTRIBUTE);
    }

    public ToolBeforeRunTask clone() {
        return (ToolBeforeRunTask)((Object)((AbstractToolBeforeRunTask)super.clone()));
    }

    public void setToolActionId(String toolActionId) {
        this.myToolActionId = toolActionId;
    }

    public boolean isExecutable() {
        return this.myToolActionId != null;
    }

    public boolean execute(DataContext context, long executionId) {
        final Semaphore targetDone = new Semaphore();
        final Ref result2 = new Ref((Object)false);
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> ToolAction.runTool(this.myToolActionId, context, null, executionId, (ProcessListener)new ProcessAdapter(){

                public void startNotified(ProcessEvent event) {
                    targetDone.down();
                }

                public void processTerminated(ProcessEvent event) {
                    result2.set((Object)(event.getExitCode() == 0 ? 1 : 0));
                    targetDone.up();
                }
            }), ModalityState.NON_MODAL);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return false;
        }
        targetDone.waitFor();
        return (Boolean)result2.get();
    }

    @Nullable
    public T findCorrespondingTool() {
        if (this.myToolActionId == null) {
            return null;
        }
        List<T> tools = this.getTools();
        for (Tool tool : tools) {
            if (!this.myToolActionId.equals(tool.getActionId())) continue;
            return (T)tool;
        }
        return null;
    }

    protected abstract List<T> getTools();
}

