/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.AppIconScheme;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.Win7TaskBar;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryOutputStream;
import org.jetbrains.annotations.NotNull;

public abstract class AppIcon {
    private static final Logger LOG = Logger.getInstance(AppIcon.class);
    private static AppIcon ourIcon;

    @NotNull
    public static AppIcon getInstance() {
        if (ourIcon == null) {
            ourIcon = SystemInfo.isMac ? new MacAppIcon() : (SystemInfo.isWin7OrNewer ? new Win7AppIcon() : new EmptyIcon());
        }
        AppIcon appIcon = ourIcon;
        if (appIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/AppIcon", "getInstance"));
        }
        return appIcon;
    }

    public abstract boolean setProgress(Project var1, Object var2, AppIconScheme.Progress var3, double var4, boolean var6);

    public abstract boolean hideProgress(Project var1, Object var2);

    public abstract void setErrorBadge(Project var1, String var2);

    public abstract void setOkBadge(Project var1, boolean var2);

    public abstract void requestAttention(Project var1, boolean var2);

    public abstract void requestFocus(IdeFrame var1);

    private static void assertIsDispatchThread() {
        Application app = ApplicationManager.getApplication();
        if (app != null) {
            if (!app.isUnitTestMode()) {
                app.assertIsDispatchThread();
            }
        } else assert (EventQueue.isDispatchThread());
    }

    private static class EmptyIcon
    extends AppIcon {
        private EmptyIcon() {
        }

        @Override
        public boolean setProgress(Project project2, Object processId, AppIconScheme.Progress scheme2, double value2, boolean isOk) {
            return false;
        }

        @Override
        public boolean hideProgress(Project project2, Object processId) {
            return false;
        }

        @Override
        public void setErrorBadge(Project project2, String text2) {
        }

        @Override
        public void setOkBadge(Project project2, boolean visible) {
        }

        @Override
        public void requestAttention(Project project2, boolean critical) {
        }

        @Override
        public void requestFocus(IdeFrame frame) {
        }
    }

    private static class Win7AppIcon
    extends BaseIcon {
        private static Color errorBadgeShadowColor = new Color(0, 0, 0, 102);
        private static Color errorBadgeMainColor = new Color(255, 98, 89);
        private static Color errorBadgeTextBackgroundColor = new Color(0, 0, 0, 39);
        private Object myOkIcon;

        private Win7AppIcon() {
        }

        @Override
        public boolean _setProgress(IdeFrame frame, Object processId, AppIconScheme.Progress scheme2, double value2, boolean isOk) {
            this.myCurrentProcessId = processId;
            if (Math.abs(this.myLastValue - value2) < 0.02) {
                return true;
            }
            try {
                if (Win7AppIcon.isValid(frame)) {
                    Win7TaskBar.setProgress(frame, value2, isOk);
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            this.myLastValue = value2;
            this.myCurrentProcessId = null;
            return true;
        }

        @Override
        public boolean _hideProgress(IdeFrame frame, Object processId) {
            if (this.myCurrentProcessId != null && !this.myCurrentProcessId.equals(processId)) {
                return false;
            }
            try {
                if (Win7AppIcon.isValid(frame)) {
                    Win7TaskBar.hideProgress(frame);
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            this.myCurrentProcessId = null;
            this.myLastValue = 0.0;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void writeTransparentIcoImageWithSanselan(BufferedImage src, OutputStream os) throws ImageWriteException, IOException {
            LOG.assertTrue(2 == src.getType() || 6 == src.getType());
            int bitCount = 32;
            BinaryOutputStream bos = new BinaryOutputStream(os, 73);
            try {
                int t_scanline_size;
                int scanline_size = (bitCount * src.getWidth() + 7) / 8;
                if (scanline_size % 4 != 0) {
                    scanline_size += 4 - scanline_size % 4;
                }
                if ((t_scanline_size = (src.getWidth() + 7) / 8) % 4 != 0) {
                    t_scanline_size += 4 - t_scanline_size % 4;
                }
                int imageSize = 40 + src.getHeight() * scanline_size + src.getHeight() * t_scanline_size;
                bos.write2Bytes(0);
                bos.write2Bytes(1);
                bos.write2Bytes(1);
                int iconDirEntryWidth = src.getWidth();
                int iconDirEntryHeight = src.getHeight();
                if (iconDirEntryWidth > 255 || iconDirEntryHeight > 255) {
                    iconDirEntryWidth = 0;
                    iconDirEntryHeight = 0;
                }
                bos.write(iconDirEntryWidth);
                bos.write(iconDirEntryHeight);
                bos.write(0);
                bos.write(0);
                bos.write2Bytes(1);
                bos.write2Bytes(bitCount);
                bos.write4Bytes(imageSize);
                bos.write4Bytes(22);
                bos.write4Bytes(40);
                bos.write4Bytes(src.getWidth());
                bos.write4Bytes(2 * src.getHeight());
                bos.write2Bytes(1);
                bos.write2Bytes(bitCount);
                bos.write4Bytes(0);
                bos.write4Bytes(0);
                bos.write4Bytes(0);
                bos.write4Bytes(0);
                bos.write4Bytes(0);
                bos.write4Bytes(0);
                int bit_cache = 0;
                int bits_in_cache = 0;
                int row_padding = scanline_size - (bitCount * src.getWidth() + 7) / 8;
                for (int y = src.getHeight() - 1; y >= 0; --y) {
                    int x;
                    for (x = 0; x < src.getWidth(); ++x) {
                        int argb = src.getRGB(x, y);
                        bos.write(0xFF & argb);
                        bos.write(0xFF & argb >> 8);
                        bos.write(0xFF & argb >> 16);
                        bos.write(0xFF & argb >> 24);
                    }
                    for (x = 0; x < row_padding; ++x) {
                        bos.write(0);
                    }
                }
                int t_row_padding = t_scanline_size - (src.getWidth() + 7) / 8;
                for (int y = src.getHeight() - 1; y >= 0; --y) {
                    int x;
                    for (x = 0; x < src.getWidth(); ++x) {
                        int argb = src.getRGB(x, y);
                        int alpha = 0xFF & argb >> 24;
                        bit_cache <<= 1;
                        if (alpha == 0) {
                            bit_cache |= 1;
                        }
                        if (++bits_in_cache < 8) continue;
                        bos.write(0xFF & bit_cache);
                        bit_cache = 0;
                        bits_in_cache = 0;
                    }
                    if (bits_in_cache > 0) {
                        bos.write(0xFF & (bit_cache <<= 8 - bits_in_cache));
                        bit_cache = 0;
                        bits_in_cache = 0;
                    }
                    for (x = 0; x < t_row_padding; ++x) {
                        bos.write(0);
                    }
                }
            }
            finally {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public void _setTextBadge(IdeFrame frame, String text2) {
            if (!Win7AppIcon.isValid(frame)) {
                return;
            }
            Object icon = null;
            if (text2 != null) {
                try {
                    int size = 16;
                    BufferedImage image = UIUtil.createImage((Component)frame.getComponent(), (int)size, (int)size, (int)2);
                    Graphics2D g = image.createGraphics();
                    int shadowRadius = 16;
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setPaint(errorBadgeShadowColor);
                    g.fillRoundRect(size / 2 - shadowRadius / 2, size / 2 - shadowRadius / 2, shadowRadius, shadowRadius, size, size);
                    int mainRadius = 14;
                    g.setPaint(errorBadgeMainColor);
                    g.fillRoundRect(size / 2 - mainRadius / 2, size / 2 - mainRadius / 2, mainRadius, mainRadius, size, size);
                    Font font = g.getFont();
                    g.setFont(new Font(font.getName(), 1, 9));
                    FontMetrics fontMetrics = g.getFontMetrics();
                    int textWidth = fontMetrics.stringWidth(text2);
                    int textHeight = UIUtil.getHighestGlyphHeight((String)text2, (Font)font, (Graphics)g);
                    g.setPaint(errorBadgeTextBackgroundColor);
                    g.fillOval(size / 2 - textWidth / 2, size / 2 - textHeight / 2, textWidth, textHeight);
                    g.setColor(Color.white);
                    g.drawString(text2, size / 2 - textWidth / 2, size / 2 - fontMetrics.getHeight() / 2 + fontMetrics.getAscent());
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    Win7AppIcon.writeTransparentIcoImageWithSanselan(image, bytes);
                    icon = Win7TaskBar.createIcon(bytes.toByteArray());
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
            try {
                Win7TaskBar.setOverlayIcon(frame, icon, icon != null);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void _setOkBadge(IdeFrame frame, boolean visible) {
            if (!Win7AppIcon.isValid(frame)) {
                return;
            }
            Object icon = null;
            if (visible) {
                Class<Win7AppIcon> clazz = Win7AppIcon.class;
                // MONITORENTER : com.intellij.ui.AppIcon$Win7AppIcon.class
                if (this.myOkIcon == null) {
                    try {
                        BufferedImage image = ImageIO.read(this.getClass().getResource("/mac/appIconOk512.png"));
                        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                        Win7AppIcon.writeTransparentIcoImageWithSanselan(image, bytes);
                        this.myOkIcon = Win7TaskBar.createIcon(bytes.toByteArray());
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                        this.myOkIcon = null;
                    }
                }
                icon = this.myOkIcon;
                // MONITOREXIT : clazz
            }
            try {
                Win7TaskBar.setOverlayIcon(frame, icon, false);
                return;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        public void _requestAttention(IdeFrame frame, boolean critical) {
            try {
                if (Win7AppIcon.isValid(frame)) {
                    Win7TaskBar.attention(frame, critical);
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        protected IdeFrame getIdeFrame(Project project2) {
            return WindowManager.getInstance().getIdeFrame(project2);
        }

        @Override
        public void requestFocus(IdeFrame frame) {
        }

        private static boolean isValid(IdeFrame frame) {
            return frame != null && ((Component)frame).isDisplayable();
        }
    }

    private static class MacAppIcon
    extends BaseIcon {
        private BufferedImage myAppImage;
        private Map<Object, AppImage> myProgressImagesCache = new HashMap();
        private static Color PROGRESS_BACKGROUND_COLOR = new Color(255, 255, 255, 217);
        private static Color PROGRESS_OUTLINE_COLOR = new Color(140, 139, 140);

        private MacAppIcon() {
        }

        private BufferedImage getAppImage() {
            AppIcon.assertIsDispatchThread();
            try {
                if (this.myAppImage != null) {
                    return this.myAppImage;
                }
                Object app = MacAppIcon.getApp();
                Image appImage = (Image)MacAppIcon.getAppMethod("getDockIconImage", new Class[0]).invoke(app, new Object[0]);
                if (appImage == null) {
                    return null;
                }
                this.myAppImage = ImageUtil.toBufferedImage((Image)appImage);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            return this.myAppImage;
        }

        @Override
        public void _setTextBadge(IdeFrame frame, String text2) {
            AppIcon.assertIsDispatchThread();
            try {
                MacAppIcon.getAppMethod("setDockIconBadge", String.class).invoke(MacAppIcon.getApp(), text2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        public void requestFocus(IdeFrame frame) {
            AppIcon.assertIsDispatchThread();
            try {
                MacAppIcon.getAppMethod("requestForeground", Boolean.TYPE).invoke(MacAppIcon.getApp(), true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        public void _requestAttention(IdeFrame frame, boolean critical) {
            AppIcon.assertIsDispatchThread();
            try {
                MacAppIcon.getAppMethod("requestUserAttention", Boolean.TYPE).invoke(MacAppIcon.getApp(), critical);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        protected IdeFrame getIdeFrame(Project project2) {
            return null;
        }

        @Override
        public boolean _hideProgress(IdeFrame frame, Object processId) {
            AppIcon.assertIsDispatchThread();
            if (this.getAppImage() == null) {
                return false;
            }
            if (this.myCurrentProcessId != null && !this.myCurrentProcessId.equals(processId)) {
                return false;
            }
            MacAppIcon.setDockIcon(this.getAppImage());
            this.myProgressImagesCache.remove(this.myCurrentProcessId);
            this.myCurrentProcessId = null;
            this.myLastValue = 0.0;
            return true;
        }

        @Override
        public void _setOkBadge(IdeFrame frame, boolean visible) {
            AppIcon.assertIsDispatchThread();
            if (this.getAppImage() == null) {
                return;
            }
            AppImage img = this.createAppImage();
            if (visible) {
                Icon okIcon = AllIcons.Mac.AppIconOk512;
                int myImgWidth = img.myImg.getWidth();
                if (myImgWidth != 128) {
                    okIcon = IconUtil.scale((Icon)okIcon, (double)(myImgWidth / 128));
                }
                int x = myImgWidth - okIcon.getIconWidth();
                int y = 0;
                okIcon.paintIcon(JOptionPane.getRootFrame(), img.myG2d, x, y);
            }
            MacAppIcon.setDockIcon(img.myImg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean _setProgress(IdeFrame frame, Object processId, AppIconScheme.Progress scheme2, double value2, boolean isOk) {
            AppIcon.assertIsDispatchThread();
            if (this.getAppImage() == null) {
                return false;
            }
            this.myCurrentProcessId = processId;
            if (this.myLastValue > value2) {
                return true;
            }
            if (Math.abs(this.myLastValue - value2) < 0.02) {
                return true;
            }
            try {
                double progressHeight = (double)this.myAppImage.getHeight() * 0.13;
                double xInset = (double)this.myAppImage.getWidth() * 0.05;
                double yInset = (double)this.myAppImage.getHeight() * 0.15;
                double width = (double)this.myAppImage.getWidth() - xInset * 2.0;
                double y = (double)this.myAppImage.getHeight() - progressHeight - yInset;
                Area borderArea = new Area(new RoundRectangle2D.Double(xInset - 1.0, y - 1.0, width + 2.0, progressHeight + 2.0, progressHeight + 2.0, progressHeight + 2.0));
                Area backgroundArea = new Area(new Rectangle2D.Double(xInset, y, width, progressHeight));
                backgroundArea.intersect(borderArea);
                Area progressArea = new Area(new Rectangle2D.Double(xInset + 1.0, y + 1.0, (width - 2.0) * value2, progressHeight - 1.0));
                progressArea.intersect(borderArea);
                AppImage appImg = this.myProgressImagesCache.get(this.myCurrentProcessId);
                if (appImg == null) {
                    appImg = this.createAppImage();
                    this.myProgressImagesCache.put(this.myCurrentProcessId, appImg);
                }
                appImg.myG2d.setColor(PROGRESS_BACKGROUND_COLOR);
                appImg.myG2d.fill(backgroundArea);
                Color color = isOk ? scheme2.getOkColor() : scheme2.getErrorColor();
                appImg.myG2d.setColor(color);
                appImg.myG2d.fill(progressArea);
                appImg.myG2d.setColor(PROGRESS_OUTLINE_COLOR);
                appImg.myG2d.draw(backgroundArea);
                appImg.myG2d.draw(borderArea);
                MacAppIcon.setDockIcon(appImg.myImg);
                this.myLastValue = value2;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                this.myCurrentProcessId = null;
            }
            return true;
        }

        private AppImage createAppImage() {
            BufferedImage appImage = this.getAppImage();
            assert (appImage != null);
            BufferedImage current = new BufferedImage(appImage.getWidth(), appImage.getHeight(), 2);
            Graphics2D g = current.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            UIUtil.drawImage((Graphics)g, (Image)appImage, (int)0, (int)0, null);
            return new AppImage(current, g);
        }

        private static void setDockIcon(BufferedImage image) {
            try {
                MacAppIcon.getAppMethod("setDockIconImage", Image.class).invoke(MacAppIcon.getApp(), image);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        private static Method getAppMethod(String name2, Class ... args) throws NoSuchMethodException, ClassNotFoundException {
            return MacAppIcon.getAppClass().getMethod(name2, args);
        }

        private static Object getApp() throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
            return MacAppIcon.getAppClass().getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
        }

        private static Class<?> getAppClass() throws ClassNotFoundException {
            return Class.forName("com.apple.eawt.Application");
        }

        private static class AppImage {
            BufferedImage myImg;
            Graphics2D myG2d;

            AppImage(BufferedImage img, Graphics2D g2d) {
                this.myImg = img;
                this.myG2d = g2d;
            }
        }
    }

    private static abstract class BaseIcon
    extends AppIcon {
        private ApplicationActivationListener myAppListener;
        protected Object myCurrentProcessId;
        protected double myLastValue;

        private BaseIcon() {
        }

        @Override
        public final boolean setProgress(Project project2, Object processId, AppIconScheme.Progress scheme2, double value2, boolean isOk) {
            if (!this.isAppActive() && Registry.is((String)"ide.appIcon.progress") && (this.myCurrentProcessId == null || this.myCurrentProcessId.equals(processId))) {
                return this._setProgress(this.getIdeFrame(project2), processId, scheme2, value2, isOk);
            }
            return false;
        }

        @Override
        public final boolean hideProgress(Project project2, Object processId) {
            if (Registry.is((String)"ide.appIcon.progress")) {
                return this._hideProgress(this.getIdeFrame(project2), processId);
            }
            return false;
        }

        @Override
        public final void setErrorBadge(Project project2, String text2) {
            if (!this.isAppActive() && Registry.is((String)"ide.appIcon.badge")) {
                this._setOkBadge(this.getIdeFrame(project2), false);
                this._setTextBadge(this.getIdeFrame(project2), text2);
            }
        }

        @Override
        public final void setOkBadge(Project project2, boolean visible) {
            if (!this.isAppActive() && Registry.is((String)"ide.appIcon.badge")) {
                this._setTextBadge(this.getIdeFrame(project2), null);
                this._setOkBadge(this.getIdeFrame(project2), visible);
            }
        }

        @Override
        public final void requestAttention(Project project2, boolean critical) {
            if (!this.isAppActive() && Registry.is((String)"ide.appIcon.requestAttention")) {
                this._requestAttention(this.getIdeFrame(project2), critical);
            }
        }

        public abstract boolean _setProgress(IdeFrame var1, Object var2, AppIconScheme.Progress var3, double var4, boolean var6);

        public abstract boolean _hideProgress(IdeFrame var1, Object var2);

        public abstract void _setTextBadge(IdeFrame var1, String var2);

        public abstract void _setOkBadge(IdeFrame var1, boolean var2);

        public abstract void _requestAttention(IdeFrame var1, boolean var2);

        protected abstract IdeFrame getIdeFrame(Project var1);

        private boolean isAppActive() {
            Application app = ApplicationManager.getApplication();
            if (app != null && this.myAppListener == null) {
                this.myAppListener = new ApplicationActivationListener(){

                    public void applicationActivated(IdeFrame ideFrame) {
                        this.hideProgress(ideFrame.getProject(), myCurrentProcessId);
                        this._setOkBadge(ideFrame, false);
                        this._setTextBadge(ideFrame, null);
                    }
                };
                app.getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)this.myAppListener);
            }
            return app != null && app.isActive();
        }
    }
}

