/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.notification.EventLog;
import com.intellij.notification.Notification;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutConfiguration;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BalloonLayoutImpl
implements BalloonLayout {
    private final ComponentAdapter myResizeListener;
    protected JLayeredPane myLayeredPane;
    private final Insets myInsets;
    protected final List<Balloon> myBalloons;
    private final Map<Balloon, BalloonLayoutData> myLayoutData;
    private Integer myWidth;
    private final Alarm myRelayoutAlarm;
    private final Runnable myRelayoutRunnable;
    private JRootPane myParent;
    private final Runnable myCloseAll;
    private final Runnable myLayoutRunnable;
    private LafManagerListener myLafListener;
    private final List<Runnable> myListeners;

    public BalloonLayoutImpl(@NotNull JRootPane parent, @NotNull Insets insets) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ui/BalloonLayoutImpl", "<init>"));
        }
        if (insets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insets", "com/intellij/ui/BalloonLayoutImpl", "<init>"));
        }
        this.myResizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/BalloonLayoutImpl$1", "componentResized"));
                }
                BalloonLayoutImpl.this.queueRelayout();
            }
        };
        this.myBalloons = new ArrayList<Balloon>();
        this.myLayoutData = new HashMap<Balloon, BalloonLayoutData>();
        this.myRelayoutAlarm = new Alarm();
        this.myRelayoutRunnable = () -> {
            if (this.myLayeredPane == null) {
                return;
            }
            this.relayout();
            this.fireRelayout();
        };
        this.myCloseAll = () -> {
            for (Balloon balloon : new ArrayList<Balloon>(this.myBalloons)) {
                this.remove(balloon, true);
            }
        };
        this.myLayoutRunnable = () -> {
            this.calculateSize();
            this.relayout();
            this.fireRelayout();
        };
        this.myListeners = new ArrayList<Runnable>();
        this.myParent = parent;
        this.myLayeredPane = parent.getLayeredPane();
        this.myInsets = insets;
        this.myLayeredPane.addComponentListener(this.myResizeListener);
    }

    public void dispose() {
        this.myLayeredPane.removeComponentListener(this.myResizeListener);
        if (this.myLafListener != null) {
            LafManager.getInstance().removeLafManagerListener(this.myLafListener);
            this.myLafListener = null;
        }
        for (Balloon balloon : new ArrayList<Balloon>(this.myBalloons)) {
            Disposer.dispose((Disposable)balloon);
        }
        this.myRelayoutAlarm.cancelAllRequests();
        this.myBalloons.clear();
        this.myLayoutData.clear();
        this.myListeners.clear();
        this.myLayeredPane = null;
        this.myParent = null;
    }

    public void addListener(Runnable listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(Runnable listener2) {
        this.myListeners.remove(listener2);
    }

    private void fireRelayout() {
        for (Runnable listener2 : this.myListeners) {
            listener2.run();
        }
    }

    @Nullable
    public Component getTopBalloonComponent() {
        BalloonImpl balloon = (BalloonImpl)ContainerUtil.getLastItem(this.myBalloons);
        return balloon == null ? null : balloon.getComponent();
    }

    public void add(@NotNull Balloon balloon) {
        if (balloon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/ui/BalloonLayoutImpl", "add"));
        }
        this.add(balloon, null);
    }

    public void add(final @NotNull Balloon balloon, @Nullable Object layoutData) {
        int index;
        if (balloon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/ui/BalloonLayoutImpl", "add"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Balloon merge = this.merge(layoutData);
        if (merge == null) {
            if (BalloonLayoutImpl.getVisibleCount() > 0 && layoutData instanceof BalloonLayoutData && ((BalloonLayoutData)layoutData).groupId != null) {
                index = -1;
                int count = 0;
                int size = this.myBalloons.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    BalloonLayoutData ld = this.myLayoutData.get(this.myBalloons.get(i2));
                    if (ld == null || ld.groupId == null) continue;
                    if (index == -1) {
                        index = i2;
                    }
                    ++count;
                }
                if (count > 0 && count == BalloonLayoutImpl.getVisibleCount()) {
                    this.remove(this.myBalloons.get(index));
                }
            }
            this.myBalloons.add(balloon);
        } else {
            index = this.myBalloons.indexOf(merge);
            this.remove(merge);
            this.myBalloons.add(index, balloon);
        }
        if (layoutData instanceof BalloonLayoutData) {
            BalloonLayoutData balloonLayoutData = (BalloonLayoutData)layoutData;
            balloonLayoutData.closeAll = this.myCloseAll;
            balloonLayoutData.doLayout = this.myLayoutRunnable;
            this.myLayoutData.put(balloon, balloonLayoutData);
        }
        Disposer.register((Disposable)balloon, (Disposable)new Disposable(){

            public void dispose() {
                BalloonLayoutImpl.this.clearNMore(balloon);
                BalloonLayoutImpl.this.remove(balloon, false);
                BalloonLayoutImpl.this.queueRelayout();
            }
        });
        if (this.myLafListener == null && layoutData != null) {
            this.myLafListener = new LafManagerListener(){

                public void lookAndFeelChanged(LafManager source) {
                    for (BalloonLayoutData layoutData : BalloonLayoutImpl.this.myLayoutData.values()) {
                        if (layoutData.lafHandler == null) continue;
                        layoutData.lafHandler.run();
                    }
                }
            };
            LafManager.getInstance().addLafManagerListener(this.myLafListener);
        }
        this.calculateSize();
        this.relayout();
        if (!balloon.isDisposed()) {
            balloon.show(this.myLayeredPane);
        }
        this.fireRelayout();
    }

    @Nullable
    private Balloon merge(@Nullable Object data) {
        String mergeId = null;
        if (data instanceof String) {
            mergeId = (String)data;
        } else if (data instanceof BalloonLayoutData) {
            mergeId = ((BalloonLayoutData)data).groupId;
        }
        if (mergeId != null) {
            for (Map.Entry<Balloon, BalloonLayoutData> e : this.myLayoutData.entrySet()) {
                if (!mergeId.equals(e.getValue().groupId)) continue;
                return e.getKey();
            }
        }
        return null;
    }

    @Nullable
    public BalloonLayoutData.MergeInfo preMerge(@NotNull Notification notification) {
        BalloonLayoutData layoutData;
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/ui/BalloonLayoutImpl", "preMerge"));
        }
        Balloon balloon = this.merge(notification.getGroupId());
        if (balloon != null && (layoutData = this.myLayoutData.get(balloon)) != null) {
            return layoutData.merge();
        }
        return null;
    }

    public void remove(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/ui/BalloonLayoutImpl", "remove"));
        }
        Balloon balloon = this.merge(notification.getGroupId());
        if (balloon != null) {
            this.remove(balloon, true);
        }
    }

    private void remove(@NotNull Balloon balloon) {
        if (balloon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/ui/BalloonLayoutImpl", "remove"));
        }
        this.remove(balloon, false);
        balloon.hide(true);
        this.fireRelayout();
    }

    private void clearNMore(@NotNull Balloon balloon) {
        if (balloon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/ui/BalloonLayoutImpl", "clearNMore"));
        }
        BalloonLayoutData layoutData = this.myLayoutData.get(balloon);
        if (layoutData != null && layoutData.project != null && layoutData.mergeData != null) {
            EventLog.clearNMore(layoutData.project, Collections.singleton(layoutData.groupId));
        }
    }

    private void remove(@NotNull Balloon balloon, boolean hide) {
        if (balloon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/ui/BalloonLayoutImpl", "remove"));
        }
        this.myBalloons.remove(balloon);
        BalloonLayoutData layoutData = this.myLayoutData.remove(balloon);
        if (layoutData != null) {
            layoutData.mergeData = null;
        }
        if (hide) {
            balloon.hide();
            this.fireRelayout();
        }
    }

    public void closeAll() {
        this.myCloseAll.run();
    }

    public void closeFirst() {
        if (!this.myBalloons.isEmpty()) {
            this.remove(this.myBalloons.get(0), true);
        }
    }

    public int getBalloonCount() {
        return this.myBalloons.size();
    }

    private static int getVisibleCount() {
        return Registry.intValue((String)"ide.notification.visible.count", (int)2);
    }

    @NotNull
    private Dimension getSize(@NotNull Balloon balloon) {
        if (balloon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/ui/BalloonLayoutImpl", "getSize"));
        }
        BalloonLayoutData layoutData = this.myLayoutData.get(balloon);
        if (layoutData == null) {
            Dimension size = balloon.getPreferredSize();
            Dimension dimension = this.myWidth == null ? size : new Dimension(this.myWidth, size.height);
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/BalloonLayoutImpl", "getSize"));
            }
            return dimension;
        }
        Dimension dimension = new Dimension(this.myWidth, layoutData.height);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/BalloonLayoutImpl", "getSize"));
        }
        return dimension;
    }

    public boolean isEmpty() {
        return this.myBalloons.isEmpty();
    }

    public void queueRelayout() {
        this.myRelayoutAlarm.cancelAllRequests();
        this.myRelayoutAlarm.addRequest(this.myRelayoutRunnable, 200);
    }

    private void calculateSize() {
        this.myWidth = null;
        for (Balloon balloon : this.myBalloons) {
            BalloonLayoutData layoutData = this.myLayoutData.get(balloon);
            if (layoutData == null) continue;
            layoutData.height = balloon.getPreferredSize().height;
        }
        this.myWidth = BalloonLayoutConfiguration.FixedWidth;
    }

    private void relayout() {
        Dimension size = this.myLayeredPane.getSize();
        JBInsets.removeFrom((Dimension)size, (Insets)this.myInsets);
        Rectangle layoutRec = new Rectangle(new Point(this.myInsets.left, this.myInsets.top), size);
        List<ArrayList<Balloon>> columns = this.createColumns(layoutRec);
        while (columns.size() > 1) {
            this.remove(this.myBalloons.get(0), true);
            columns = this.createColumns(layoutRec);
        }
        ToolWindowsPane pane = (ToolWindowsPane)((Object)UIUtil.findComponentOfType((JComponent)this.myParent, ToolWindowsPane.class));
        JComponent layeredPane = pane != null ? pane.getMyLayeredPane() : null;
        int eachColumnX = (layeredPane == null ? this.myLayeredPane.getWidth() : layeredPane.getX() + layeredPane.getWidth()) - 4;
        this.doLayout((List<Balloon>)columns.get(0), eachColumnX + 4, (int)this.myLayeredPane.getBounds().getMaxY());
    }

    private void doLayout(List<Balloon> balloons, int startX, int bottomY) {
        int y = bottomY;
        ToolWindowsPane pane = (ToolWindowsPane)((Object)UIUtil.findComponentOfType((JComponent)this.myParent, ToolWindowsPane.class));
        if (pane != null) {
            y -= pane.getBottomHeight();
        }
        if (this.myParent instanceof IdeRootPane) {
            y -= ((IdeRootPane)this.myParent).getStatusBarHeight();
        }
        for (Balloon balloon : balloons) {
            Rectangle bounds = new Rectangle(this.getSize(balloon));
            bounds.setLocation(startX - bounds.width, y -= bounds.height);
            balloon.setBounds(bounds);
        }
    }

    private List<ArrayList<Balloon>> createColumns(Rectangle layoutRec) {
        ArrayList<ArrayList<Balloon>> columns = new ArrayList<ArrayList<Balloon>>();
        ArrayList<Balloon> eachColumn = new ArrayList<Balloon>();
        columns.add(eachColumn);
        int eachColumnHeight = 0;
        for (Balloon each : this.myBalloons) {
            Dimension eachSize = this.getSize(each);
            if ((double)(eachColumnHeight + eachSize.height) > layoutRec.getHeight()) {
                eachColumn = new ArrayList();
                columns.add(eachColumn);
                eachColumnHeight = 0;
            }
            eachColumn.add(each);
            eachColumnHeight += eachSize.height;
        }
        return columns;
    }
}

