/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SpeedSearchBase;
import javax.swing.ComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComboboxSpeedSearch
extends SpeedSearchBase<JComboBox> {
    public ComboboxSpeedSearch(@NotNull JComboBox comboBox) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comboBox", "com/intellij/ui/ComboboxSpeedSearch", "<init>"));
        }
        super(comboBox);
        ComboboxSpeedSearch.removeKeyStroke(comboBox.getInputMap(1), KeyStroke.getKeyStroke(32, 0));
    }

    private static void removeKeyStroke(@Nullable InputMap map2, KeyStroke ks) {
        while (map2 != null) {
            map2.remove(ks);
            map2 = map2.getParent();
        }
    }

    @Override
    protected void selectElement(Object element, String selectedText) {
        ((JComboBox)this.myComponent).setSelectedItem(element);
        ((JComboBox)this.myComponent).repaint();
    }

    @Override
    protected int getSelectedIndex() {
        return ((JComboBox)this.myComponent).getSelectedIndex();
    }

    @Override
    protected Object[] getAllElements() {
        ComboBoxModel model = ((JComboBox)this.myComponent).getModel();
        Object[] elements = new Object[model.getSize()];
        for (int i2 = 0; i2 < elements.length; ++i2) {
            elements[i2] = model.getElementAt(i2);
        }
        return elements;
    }

    @Override
    protected String getElementText(Object element) {
        return element == null ? null : element.toString();
    }
}

