/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.CommandLineProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.URLUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CustomProtocolHandler {
    public static final String LINE_NUMBER_ARG_NAME = "--line";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.CustomProtocolHandler");

    public boolean openLink(@NotNull URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/intellij/ui/CustomProtocolHandler", "openLink"));
        }
        LOG.info("CustomProtocolHandler.openLink");
        List<String> args = this.getOpenArgs(uri);
        return !args.isEmpty() && CommandLineProcessor.processExternalCommandLine(args, null) != null;
    }

    @NotNull
    public List<String> getOpenArgs(URI uri) {
        ArrayList<String> args = new ArrayList<String>();
        String query = uri.getQuery();
        String file2 = null;
        String line = null;
        if (query != null) {
            for (String param : query.split("&")) {
                String[] pair2 = param.split("=");
                String key2 = URLUtil.unescapePercentSequences((String)pair2[0]);
                if (pair2.length <= 1) continue;
                if ("file".equals(key2)) {
                    file2 = URLUtil.unescapePercentSequences((String)pair2[1]);
                    continue;
                }
                if (!"line".equals(key2)) continue;
                line = URLUtil.unescapePercentSequences((String)pair2[1]);
            }
        }
        if (file2 != null) {
            if (line != null) {
                args.add(LINE_NUMBER_ARG_NAME);
                args.add(line);
            }
            args.add(file2);
        }
        ArrayList<String> arrayList = args;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/CustomProtocolHandler", "getOpenArgs"));
        }
        return arrayList;
    }
}

