/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ClickListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.PlatformColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicHTML;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HoverHyperlinkLabel
extends JLabel {
    private String myOriginalText;
    private final List<HyperlinkListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public HoverHyperlinkLabel(String text2) {
        this(text2, PlatformColors.BLUE);
    }

    public HoverHyperlinkLabel(String text2, Color color) {
        super(text2);
        this.myOriginalText = text2;
        this.setForeground(color);
        this.setupListener();
    }

    private void setupListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                HoverHyperlinkLabel.super.setText(HoverHyperlinkLabel.underlineTextInHtml(HoverHyperlinkLabel.this.myOriginalText));
                HoverHyperlinkLabel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HoverHyperlinkLabel.super.setText(HoverHyperlinkLabel.this.myOriginalText);
                HoverHyperlinkLabel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/HoverHyperlinkLabel$2", "onClick"));
                }
                HyperlinkEvent event = new HyperlinkEvent(HoverHyperlinkLabel.this, HyperlinkEvent.EventType.ACTIVATED, null);
                for (HyperlinkListener listener2 : HoverHyperlinkLabel.this.myListeners) {
                    listener2.hyperlinkUpdate(event);
                }
                return true;
            }
        }.installOn((Component)this);
    }

    @Override
    public void setText(String text2) {
        if (BasicHTML.isHTMLString(this.getText())) {
            super.setText(HoverHyperlinkLabel.underlineTextInHtml(text2));
        } else {
            super.setText(text2);
        }
        this.myOriginalText = text2;
    }

    @NonNls
    private static String underlineTextInHtml(String text2) {
        return "<html><u>" + StringUtil.escapeXml((String)text2) + "</u></html>";
    }

    public String getOriginalText() {
        return this.myOriginalText;
    }

    public void addHyperlinkListener(HyperlinkListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeHyperlinkListener(HyperlinkListener listener2) {
        this.myListeners.remove(listener2);
    }
}

