/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.SystemNotificationsImpl;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

class MountainLionNotifications
implements SystemNotificationsImpl.Notifier {
    private static MountainLionNotifications ourInstance;

    public static synchronized MountainLionNotifications getInstance() {
        if (ourInstance == null) {
            ourInstance = new MountainLionNotifications();
        }
        return ourInstance;
    }

    private MountainLionNotifications() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

            public void applicationActivated(IdeFrame ideFrame) {
                MountainLionNotifications.cleanupDeliveredNotifications();
            }
        });
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appClosing() {
                MountainLionNotifications.cleanupDeliveredNotifications();
            }
        });
    }

    @Override
    public void notify(@NotNull String name2, @NotNull String title, @NotNull String description) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ui/MountainLionNotifications", "notify"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ui/MountainLionNotifications", "notify"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/ui/MountainLionNotifications", "notify"));
        }
        ID notification = Foundation.invoke((ID)Foundation.getObjcClass((String)"NSUserNotification"), (String)"new", (Object[])new Object[0]);
        Foundation.invoke((ID)notification, (String)"setTitle:", (Object[])new Object[]{Foundation.nsString((String)StringUtil.stripHtml((String)title, (boolean)true).replace("%", "%%"))});
        Foundation.invoke((ID)notification, (String)"setInformativeText:", (Object[])new Object[]{Foundation.nsString((String)StringUtil.stripHtml((String)description, (boolean)true).replace("%", "%%"))});
        ID center = Foundation.invoke((ID)Foundation.getObjcClass((String)"NSUserNotificationCenter"), (String)"defaultUserNotificationCenter", (Object[])new Object[0]);
        Foundation.invoke((ID)center, (String)"deliverNotification:", (Object[])new Object[]{notification});
    }

    private static void cleanupDeliveredNotifications() {
        ID center = Foundation.invoke((ID)Foundation.getObjcClass((String)"NSUserNotificationCenter"), (String)"defaultUserNotificationCenter", (Object[])new Object[0]);
        Foundation.invoke((ID)center, (String)"removeAllDeliveredNotifications", (Object[])new Object[0]);
    }
}

