/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.BalloonImpl;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.ImageObserver;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NotificationBalloonShadowBorderProvider
implements BalloonImpl.ShadowBorderProvider {
    private static final Insets INSETS = new JBInsets(4, 6, 8, 6);
    private final Color myFillColor;
    private final Color myBorderColor;

    public NotificationBalloonShadowBorderProvider(@NotNull Color fillColor, @NotNull Color borderColor) {
        if (fillColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fillColor", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "<init>"));
        }
        if (borderColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "borderColor", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "<init>"));
        }
        this.myFillColor = fillColor;
        this.myBorderColor = borderColor;
    }

    @Override
    @NotNull
    public Insets getInsets() {
        Insets insets = INSETS;
        if (insets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "getInsets"));
        }
        return insets;
    }

    @Override
    public void paintShadow(@NotNull JComponent component, @NotNull Graphics g) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "paintShadow"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "paintShadow"));
        }
        int width = component.getWidth();
        int height = component.getHeight();
        int topLeftWidth = AllIcons.Ide.Notification.Shadow.Top_left.getIconWidth();
        int topLeftHeight = AllIcons.Ide.Notification.Shadow.Top_left.getIconHeight();
        int topRightWidth = AllIcons.Ide.Notification.Shadow.Top_right.getIconWidth();
        int topRightHeight = AllIcons.Ide.Notification.Shadow.Top_right.getIconHeight();
        int bottomLeftWidth = AllIcons.Ide.Notification.Shadow.Bottom_left.getIconWidth();
        int bottomLeftHeight = AllIcons.Ide.Notification.Shadow.Bottom_left.getIconHeight();
        int bottomRightWidth = AllIcons.Ide.Notification.Shadow.Bottom_right.getIconWidth();
        int bottomRightHeight = AllIcons.Ide.Notification.Shadow.Bottom_right.getIconHeight();
        int topWidth = AllIcons.Ide.Notification.Shadow.Top.getIconWidth();
        int bottomWidth = AllIcons.Ide.Notification.Shadow.Bottom.getIconWidth();
        int bottomHeight = AllIcons.Ide.Notification.Shadow.Bottom.getIconHeight();
        int leftHeight = AllIcons.Ide.Notification.Shadow.Left.getIconHeight();
        int rightWidth = AllIcons.Ide.Notification.Shadow.Right.getIconWidth();
        int rightHeight = AllIcons.Ide.Notification.Shadow.Right.getIconHeight();
        NotificationBalloonShadowBorderProvider.drawLine(component, g, AllIcons.Ide.Notification.Shadow.Top, width, topLeftWidth, topRightWidth, topWidth, 0, true);
        NotificationBalloonShadowBorderProvider.drawLine(component, g, AllIcons.Ide.Notification.Shadow.Bottom, width, bottomLeftWidth, bottomRightWidth, bottomWidth, height - bottomHeight, true);
        NotificationBalloonShadowBorderProvider.drawLine(component, g, AllIcons.Ide.Notification.Shadow.Left, height, topLeftHeight, bottomLeftHeight, leftHeight, 0, false);
        NotificationBalloonShadowBorderProvider.drawLine(component, g, AllIcons.Ide.Notification.Shadow.Right, height, topRightHeight, bottomRightHeight, rightHeight, width - rightWidth, false);
        AllIcons.Ide.Notification.Shadow.Top_left.paintIcon(component, g, 0, 0);
        AllIcons.Ide.Notification.Shadow.Top_right.paintIcon(component, g, width - topRightWidth, 0);
        AllIcons.Ide.Notification.Shadow.Bottom_right.paintIcon(component, g, width - bottomRightWidth, height - bottomRightHeight);
        AllIcons.Ide.Notification.Shadow.Bottom_left.paintIcon(component, g, 0, height - bottomLeftHeight);
    }

    private static void drawLine(@NotNull JComponent component, @NotNull Graphics g, @NotNull Icon icon, int fullLength, int start, int end, int step, int start2, boolean horizontal) {
        int i2;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "drawLine"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "drawLine"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "drawLine"));
        }
        int length = fullLength - start - end;
        int count = length / step;
        int calcLength = step * count;
        int lastValue = start + calcLength;
        if (horizontal) {
            for (i2 = start; i2 < lastValue; i2 += step) {
                icon.paintIcon(component, g, i2, start2);
            }
        } else {
            for (i2 = start; i2 < lastValue; i2 += step) {
                icon.paintIcon(component, g, start2, i2);
            }
        }
        if (calcLength < length) {
            ImageIcon imageIcon = (ImageIcon)IconLoader.getIconSnapshot((Icon)icon);
            if (horizontal) {
                UIUtil.drawImage((Graphics)g, (Image)imageIcon.getImage(), (int)lastValue, (int)start2, (int)(length - calcLength), (int)imageIcon.getIconHeight(), (ImageObserver)component);
            } else {
                UIUtil.drawImage((Graphics)g, (Image)imageIcon.getImage(), (int)start2, (int)lastValue, (int)imageIcon.getIconWidth(), (int)(length - calcLength), (ImageObserver)component);
            }
        }
    }

    @Override
    public void paintBorder(@NotNull Rectangle bounds, @NotNull Graphics2D g) {
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "paintBorder"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "paintBorder"));
        }
        g.setColor(this.myFillColor);
        g.fill(new Rectangle2D.Double(bounds.x, bounds.y, bounds.width, bounds.height));
        g.setColor(this.myBorderColor);
        g.draw(new RoundRectangle2D.Double((double)bounds.x + 0.5, (double)bounds.y + 0.5, bounds.width - 1, bounds.height - 1, 3.0, 3.0));
    }

    @Override
    public void paintPointingShape(@NotNull Rectangle bounds, @NotNull Point pointTarget, @NotNull Balloon.Position position, @NotNull Graphics2D g) {
        int y;
        int x;
        int length;
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "paintPointingShape"));
        }
        if (pointTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointTarget", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "paintPointingShape"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "paintPointingShape"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/NotificationBalloonShadowBorderProvider", "paintPointingShape"));
        }
        if (position == Balloon.Position.above) {
            length = NotificationBalloonShadowBorderProvider.INSETS.bottom;
            x = pointTarget.x;
            y = bounds.y + bounds.height + length;
        } else if (position == Balloon.Position.below) {
            length = NotificationBalloonShadowBorderProvider.INSETS.top;
            x = pointTarget.x;
            y = bounds.y - length;
        } else if (position == Balloon.Position.atRight) {
            length = NotificationBalloonShadowBorderProvider.INSETS.left;
            x = bounds.x - length;
            y = pointTarget.y;
        } else {
            length = NotificationBalloonShadowBorderProvider.INSETS.right;
            x = bounds.x + bounds.width + length;
            y = pointTarget.y;
        }
        Polygon p = new Polygon();
        p.addPoint(x, y);
        length += 2;
        if (position == Balloon.Position.above) {
            p.addPoint(x - length, y - length);
            p.addPoint(x + length, y - length);
        } else if (position == Balloon.Position.below) {
            p.addPoint(x - length, y + length);
            p.addPoint(x + length, y + length);
        } else if (position == Balloon.Position.atRight) {
            p.addPoint(x + length, y - length);
            p.addPoint(x + length, y + length);
        } else {
            p.addPoint(x - length, y - length);
            p.addPoint(x - length, y + length);
        }
        g.setColor(this.myFillColor);
        g.fillPolygon(p);
        g.setColor(this.myBorderColor);
        length -= 2;
        if (position == Balloon.Position.above) {
            g.drawLine(x, y, x - length, y - length);
            g.drawLine(x, y, x + length, y - length);
        } else if (position == Balloon.Position.below) {
            g.drawLine(x, y, x - length, y + length);
            g.drawLine(x, y, x + length, y + length);
        } else if (position == Balloon.Position.atRight) {
            g.drawLine(x, y, x + length, y - length);
            g.drawLine(x, y, x + length, y + length);
        } else {
            g.drawLine(x, y, x - length, y - length);
            g.drawLine(x, y, x - length, y + length);
        }
    }
}

