/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpeedSearchComparator {
    private MinusculeMatcher myMinusculeMatcher;
    private String myRecentSearchText;
    private final boolean myShouldMatchFromTheBeginning;
    private final boolean myShouldMatchCamelCase;

    public SpeedSearchComparator() {
        this(true);
    }

    public SpeedSearchComparator(boolean shouldMatchFromTheBeginning) {
        this(shouldMatchFromTheBeginning, false);
    }

    public SpeedSearchComparator(boolean shouldMatchFromTheBeginning, boolean shouldMatchCamelCase) {
        this.myShouldMatchFromTheBeginning = shouldMatchFromTheBeginning;
        this.myShouldMatchCamelCase = shouldMatchCamelCase;
    }

    public int matchingDegree(String pattern, String text2) {
        return this.obtainMatcher(pattern).matchingDegree(text2);
    }

    @Nullable
    public Iterable<TextRange> matchingFragments(@NotNull String pattern, @NotNull String text2) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ui/SpeedSearchComparator", "matchingFragments"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/SpeedSearchComparator", "matchingFragments"));
        }
        return this.obtainMatcher(pattern).matchingFragments(text2);
    }

    private MinusculeMatcher obtainMatcher(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ui/SpeedSearchComparator", "obtainMatcher"));
        }
        if (this.myRecentSearchText == null || !this.myRecentSearchText.equals(pattern)) {
            this.myRecentSearchText = pattern;
            if (this.myShouldMatchCamelCase) {
                pattern = StringUtil.join((String[])NameUtil.nameToWords((String)pattern), (String)"*");
            }
            if (!this.myShouldMatchFromTheBeginning && !pattern.startsWith("*")) {
                pattern = "*" + pattern;
            }
            this.myMinusculeMatcher = this.createMatcher(pattern);
        }
        return this.myMinusculeMatcher;
    }

    @NotNull
    protected MinusculeMatcher createMatcher(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/ui/SpeedSearchComparator", "createMatcher"));
        }
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher((String)pattern).build();
        if (minusculeMatcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/SpeedSearchComparator", "createMatcher"));
        }
        return minusculeMatcher;
    }

    public String getRecentSearchText() {
        return this.myRecentSearchText;
    }
}

