/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeExpandCollapse {
    public static void collapse(JTree tree) {
        TreePath selectionPath = tree.getSelectionPath();
        tree.collapsePath(selectionPath);
    }

    public static void expand(JTree tree) {
        TreePath selectionPath = tree.getSelectionPath();
        tree.expandPath(selectionPath);
    }

    public static void expandAll(JTree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            paths = new TreePath[]{new TreePath(tree.getModel().getRoot())};
        }
        for (TreePath path : paths) {
            new ExpandContext(300, 10).expand(tree, path);
        }
    }

    private static class ExpandContext {
        private final int myLevelsLeft;
        private int myExpansionLimit;

        public ExpandContext(int expansionLimit, int levelsLeft) {
            this.myExpansionLimit = expansionLimit;
            this.myLevelsLeft = levelsLeft;
        }

        public int expand(JTree tree, TreePath path) {
            if (this.myLevelsLeft == 0) {
                return this.myExpansionLimit;
            }
            TreeModel model = tree.getModel();
            Object node = path.getLastPathComponent();
            int levelDecrement = 0;
            if (!tree.isExpanded(path) && !model.isLeaf(node)) {
                tree.expandPath(path);
                levelDecrement = 1;
                --this.myExpansionLimit;
            }
            for (int i2 = 0; i2 < model.getChildCount(node); ++i2) {
                Object child = model.getChild(node, i2);
                if (model.isLeaf(child)) continue;
                ExpandContext childContext = new ExpandContext(this.myExpansionLimit, this.myLevelsLeft - levelDecrement);
                this.myExpansionLimit = childContext.expand(tree, path.pathByAddingChild(child));
                if (this.myExpansionLimit > 0) continue;
                return 0;
            }
            return this.myExpansionLimit;
        }
    }
}

